/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.global;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Comparator;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class JpegCoefficientHistogram
implements GlobalFeature {
    protected int[] descriptorValues;
    protected final int BLOCK_SIZE = 8;
    protected double[][][][] transform;
    double[][][] dctScaler2 = new double[][][]{new double[][]{{0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}, {1.9734043721689, 1.94899230863397, 1.94946285758305}, {2.94332698437659, 2.98796119092502, 2.96024565199338}, {3.80255904577673, 4.37008158805412, 4.35141415401432}, {4.68161529944488, 5.72204262950584, 5.66166566827365}, {5.87064634019722, 7.54306903541829, 7.3857474119367}, {7.78994087483808, 10.2359236535064, 9.95778205927185}}, new double[][]{{1.19274531042455, 1.2152969832815, 1.20171324933339}, {2.2943803290662, 2.14415384022472, 2.15039994134979}, {3.25623650819256, 3.01385037727374, 3.03249686547772}, {4.27045252457434, 4.21446933397605, 4.23815367511332}, {5.17998028000972, 5.78600261610464, 5.81037357341976}, {6.19785417964287, 7.2822799946799, 7.26373154837891}, {7.69684274092057, 9.28633217515052, 9.21658162859184}, {10.0353932177135, 12.1802615431261, 11.9831585607954}}, new double[][]{{2.4646732594343, 2.46387210793402, 2.43507278648256}, {3.49836053443852, 3.27953398208675, 3.26284773577962}, {4.28065963174638, 4.13119763592951, 4.1308271078573}, {5.14409465284924, 5.70765094689331, 5.74219324470954}, {5.98518749895616, 6.93385341523623, 6.96708272307546}, {7.0299847606958, 8.42771919562544, 8.40220952430735}, {8.57907078388286, 10.4160723222439, 10.3679017528836}, {11.0685666474499, 13.4531303115576, 13.2927862368604}}, new double[][]{{3.70846881386602, 3.86908673744653, 3.83210828276994}, {4.80559125796947, 4.88056952563021, 4.82595757558342}, {5.42778400768362, 6.14578620000214, 6.17040735624603}, {6.08929033878163, 7.16832687031443, 7.20751420464431}, {6.86850046640731, 8.26420707459324, 8.29853895971336}, {7.84984618688477, 9.71743532538622, 9.7147262415522}, {9.51903135622904, 11.8234824848058, 11.7845246577222}, {12.0049646114253, 14.8400917638334, 14.7424927473365}}, new double[][]{{4.90318525184508, 5.99581694008571, 5.95615698669246}, {5.97444669974084, 7.12987554548257, 7.1095906114534}, {6.53741678314503, 7.89774782069033, 7.85927030323856}, {7.13754772163163, 8.79910033955154, 8.77810164915207}, {7.7562396411917, 9.81614830137095, 9.77351931847552}, {8.76689841135206, 11.1452991551185, 11.0811843459497}, {10.513368171242, 13.2459275832513, 13.1009567613693}, {13.1979037369898, 16.3323036754675, 16.1491682798314}}, new double[][]{{6.02160192386879, 8.0427560221024, 7.93223007591373}, {7.45458506605638, 9.27703833686395, 9.17127434342562}, {7.94204962999446, 9.98039068148056, 9.90039605113603}, {8.66079232688593, 10.8162595699569, 10.653988942289}, {9.47351300957499, 11.7292236951962, 11.5907955087553}, {10.2689869608636, 13.110178084127, 12.8952102613367}, {12.2305610572211, 15.2364340660148, 14.9924012867386}, {14.3930003174177, 18.3138604479156, 17.9595357309848}}, new double[][]{{7.61123713909278, 10.5887158283599, 10.4192188429678}, {9.20731703451098, 12.0628893168648, 11.9550573473496}, {9.85709132996928, 12.8701941652904, 12.6276025472299}, {10.3165183194159, 13.605842264484, 13.4316611205688}, {11.2692286351072, 14.4761780529619, 14.1929497377358}, {12.4358837402085, 15.9177322372191, 15.568967449971}, {14.5577475321854, 18.1287696351735, 17.5958497696997}, {16.874317177599, 21.112705389718, 20.5780027036999}}, new double[][]{{10.114830426421, 14.4286223409782, 14.081749212272}, {11.6031746911885, 16.1683668751011, 15.6551122883117}, {12.0837641414121, 16.7824928835092, 16.2757903018179}, {12.7704455546218, 17.5347046049121, 17.0202232421845}, {13.5794854546779, 18.3596755686211, 17.7964343726763}, {14.9521289593159, 19.7235148101556, 19.1020295141703}, {17.3688525982791, 21.8409326336491, 21.1185396395873}, {20.69640161027, 24.8034535963609, 23.8084412646294}}};

    @Override
    public void extract(BufferedImage bimg) {
        if (bimg.getColorModel().getColorSpace().getType() != 5) {
            BufferedImage img = new BufferedImage(bimg.getWidth(), bimg.getHeight(), 1);
            img.getGraphics().drawImage(bimg, 0, 0, null);
            bimg = img;
        }
        this.transform = this.createTransformArray();
        int newWidth = bimg.getWidth() - bimg.getWidth() % 8;
        int newHeight = bimg.getHeight() - bimg.getHeight() % 8;
        int[][][] yuvImage = this.getYUVImage(bimg.getRaster(), newWidth, newHeight, -128);
        this.descriptorValues = new int[192];
        this.getComponentHistogram(yuvImage, newWidth, newHeight, 0, this.descriptorValues);
        this.getComponentHistogram(yuvImage, newWidth, newHeight, 1, this.descriptorValues);
        this.getComponentHistogram(yuvImage, newWidth, newHeight, 2, this.descriptorValues);
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        return SerializationUtils.toByteArray(this.descriptorValues);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.descriptorValues = SerializationUtils.toIntArray(in);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        this.descriptorValues = SerializationUtils.toIntArray(in, offset, length);
    }

    @Override
    public double[] getFeatureVector() {
        double[] result = new double[this.descriptorValues.length];
        for (int i = 0; i < this.descriptorValues.length; ++i) {
            result[i] = this.descriptorValues[i];
        }
        return result;
    }

    protected void getComponentHistogram(int[][][] yuvImage, int width, int height, int component, int[] descriptorBytes) {
        int i;
        int hBlockCount = width / 8;
        int vBlockCount = height / 8;
        double[][] tempHistogram = new double[8][8];
        for (int by = 0; by < vBlockCount; ++by) {
            block1: for (int bx = 0; bx < hBlockCount; ++bx) {
                double[][] dctValues = new double[8][8];
                for (int v = 0; v < 8; ++v) {
                    for (int u = 0; u < 8; ++u) {
                        double t = 0.0;
                        for (int j = 0; j < 8; ++j) {
                            for (int i2 = 0; i2 < 8; ++i2) {
                                t += (double)yuvImage[bx * 8 + i2][by * 8 + j][component] * this.transform[i2][j][u][v];
                            }
                        }
                        double cU = 1.0;
                        double cV = 1.0;
                        if (u == 0) {
                            cU = 0.707106781;
                        }
                        if (v == 0) {
                            cV = 0.707106781;
                        }
                        dctValues[u][v] = cU * cV * t / 4.0;
                    }
                }
                dctValues[0][0] = 0.0;
                for (int j = 0; j < 8; ++j) {
                    for (i = 0; i < 8; ++i) {
                        if (!(Math.abs(dctValues[i][j]) < 0.001)) continue;
                        dctValues[i][j] = 0.0;
                    }
                }
                DctPoint[] dctPoints = new DctPoint[64];
                int p = 0;
                for (int j = 0; j < 8; ++j) {
                    for (int i3 = 0; i3 < 8; ++i3) {
                        dctPoints[p] = new DctPoint();
                        dctPoints[p].i = i3;
                        dctPoints[p].j = j;
                        dctPoints[p].v = Math.abs(this.dctScaler2[i3][j][component] * dctValues[i3][j]);
                        ++p;
                    }
                }
                Arrays.sort(dctPoints, new DctComparator());
                int n = 0;
                for (int cc = 0; cc < 64; ++cc) {
                    double[] dArray = tempHistogram[dctPoints[cc].i];
                    int n2 = dctPoints[cc].j;
                    dArray[n2] = dArray[n2] + 1.0 / (double)(cc + 1);
                    if (++n == 8) continue block1;
                }
            }
        }
        double maxPoint = 0.0;
        for (int j = 0; j < 8; ++j) {
            for (int i4 = 0; i4 < 8; ++i4) {
                if (!(tempHistogram[i4][j] > maxPoint)) continue;
                maxPoint = tempHistogram[i4][j];
            }
        }
        int p = 64 * component;
        for (int j = 0; j < 8; ++j) {
            for (i = 0; i < 8; ++i) {
                descriptorBytes[p] = (int)(tempHistogram[i][j] / maxPoint * 255.0);
                ++p;
            }
        }
    }

    @Override
    public double getDistance(LireFeature vd) {
        if (!(vd instanceof JpegCoefficientHistogram)) {
            throw new UnsupportedOperationException("Wrong descriptor.");
        }
        JpegCoefficientHistogram target = (JpegCoefficientHistogram)vd;
        if (this.descriptorValues == null) {
            throw new UnsupportedOperationException("source descriptor bytes are null");
        }
        if (target.descriptorValues == null) {
            throw new UnsupportedOperationException("target descriptor bytes are null");
        }
        int size2 = 192;
        double distance = 0.0;
        for (int i = 0; i < size2; ++i) {
            distance += (double)((this.descriptorValues[i] - target.descriptorValues[i]) * (this.descriptorValues[i] - target.descriptorValues[i]));
        }
        return Math.sqrt(distance / (double)size2);
    }

    protected int[][][] getYUVImage(WritableRaster raster, int newWidth, int newHeight, int shift) {
        int[][][] yuvImage = new int[newWidth][newHeight][3];
        int[] rgbPixel = new int[3];
        for (int j = 0; j < newHeight; ++j) {
            for (int i = 0; i < newWidth; ++i) {
                raster.getPixel(i, j, rgbPixel);
                int r = rgbPixel[0];
                int g = rgbPixel[1];
                int b = rgbPixel[2];
                yuvImage[i][j][0] = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b) + shift;
                yuvImage[i][j][1] = (int)(128.0 - 0.1687 * (double)r - 0.3313 * (double)g + 0.5 * (double)b) + shift;
                yuvImage[i][j][2] = (int)(128.0 + 0.5 * (double)r - 0.4187 * (double)g - 0.0813 * (double)b) + shift;
            }
        }
        return yuvImage;
    }

    protected double[][][][] createTransformArray() {
        double[][][][] t = new double[8][8][8][8];
        for (int v = 0; v < 8; ++v) {
            for (int u = 0; u < 8; ++u) {
                for (int j = 0; j < 8; ++j) {
                    for (int i = 0; i < 8; ++i) {
                        t[i][j][u][v] = Math.cos((double)((2 * i + 1) * u) * Math.PI / 2.0 / 8.0) * Math.cos((double)((2 * j + 1) * v) * Math.PI / 2.0 / 8.0);
                    }
                }
            }
        }
        return t;
    }

    @Override
    public String getFeatureName() {
        return "Histogram of JPEG Coefficients";
    }

    @Override
    public String getFieldName() {
        return "JpegCoeffs";
    }

    public class DctComparator
    implements Comparator<DctPoint> {
        @Override
        public int compare(DctPoint o1, DctPoint o2) {
            return Double.compare(o1.v, o2.v) * -1;
        }
    }

    protected class DctPoint {
        public int i;
        public int j;
        public double v;

        protected DctPoint() {
        }
    }
}

