/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.global;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.utils.ImageUtils;
import net.semanticmetadata.lire.utils.MetricsUtils;

public class LocalBinaryPatterns
implements GlobalFeature {
    double[] histogram = new double[256];

    @Override
    public void extract(BufferedImage image) {
        Arrays.fill(this.histogram, 0.0);
        this.extractRadiusWithOne(image);
    }

    private void extractRadiusWithOne(BufferedImage image) {
        int i;
        WritableRaster raster = ImageUtils.getGrayscaleImage(image).getRaster();
        int[] pixel = new int[9];
        int bin = 0;
        for (int x = 0; x < raster.getWidth() - 2; ++x) {
            for (int y = 0; y < raster.getHeight() - 2; ++y) {
                raster.getPixels(x, y, 3, 3, pixel);
                if (pixel[0] >= pixel[4]) {
                    ++bin;
                }
                if (pixel[1] >= pixel[4]) {
                    bin += 2;
                }
                if (pixel[2] >= pixel[4]) {
                    bin += 4;
                }
                if (pixel[5] >= pixel[4]) {
                    bin += 8;
                }
                if (pixel[8] >= pixel[4]) {
                    bin += 16;
                }
                if (pixel[7] >= pixel[4]) {
                    bin += 32;
                }
                if (pixel[6] >= pixel[4]) {
                    bin += 64;
                }
                if (pixel[3] >= pixel[4]) {
                    bin += 128;
                }
                int n = bin;
                this.histogram[n] = this.histogram[n] + 1.0;
                bin = 0;
            }
        }
        double max = 0.0;
        for (i = 0; i < this.histogram.length; ++i) {
            max = Math.max(this.histogram[i], max);
        }
        for (i = 0; i < this.histogram.length; ++i) {
            this.histogram[i] = Math.floor(this.histogram[i] / max * 127.0);
        }
    }

    private void extractWithRadiusTwo(BufferedImage image) {
        int i;
        WritableRaster raster = ImageUtils.getGrayscaleImage(image).getRaster();
        int[] pixel = new int[25];
        int bin = 0;
        for (int x = 0; x < raster.getWidth() - 4; ++x) {
            for (int y = 0; y < raster.getHeight() - 4; ++y) {
                raster.getPixels(x, y, 5, 5, pixel);
                if (pixel[1] >= pixel[12]) {
                    ++bin;
                }
                if (pixel[2] >= pixel[12]) {
                    bin += 2;
                }
                if (pixel[3] >= pixel[12]) {
                    bin += 4;
                }
                if (pixel[9] >= pixel[12]) {
                    bin += 8;
                }
                if (pixel[14] >= pixel[12]) {
                    bin += 16;
                }
                if (pixel[19] >= pixel[12]) {
                    bin += 32;
                }
                if (pixel[23] >= pixel[12]) {
                    bin += 64;
                }
                if (pixel[22] >= pixel[12]) {
                    bin += 128;
                }
                if (pixel[21] >= pixel[12]) {
                    bin += 256;
                }
                if (pixel[15] >= pixel[12]) {
                    bin += 512;
                }
                if (pixel[10] >= pixel[12]) {
                    bin += 1024;
                }
                if (pixel[5] >= pixel[12]) {
                    bin += 2048;
                }
                int n = bin;
                this.histogram[n] = this.histogram[n] + 1.0;
                bin = 0;
            }
        }
        double max = 0.0;
        for (i = 0; i < this.histogram.length; ++i) {
            max = Math.max(this.histogram[i], max);
        }
        for (i = 0; i < this.histogram.length; ++i) {
            this.histogram[i] = Math.floor(this.histogram[i] / max * 128.0);
        }
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        byte[] rep = new byte[this.histogram.length];
        for (int i = 0; i < this.histogram.length; ++i) {
            rep[i] = (byte)this.histogram[i];
        }
        return rep;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.setByteArrayRepresentation(in, 0, in.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.histogram[i] = in[i + offset];
        }
    }

    @Override
    public double[] getFeatureVector() {
        return this.histogram;
    }

    @Override
    public double getDistance(LireFeature feature) {
        return MetricsUtils.distL1(this.histogram, feature.getFeatureVector());
    }

    @Override
    public String getFeatureName() {
        return "Local Binary Patterns";
    }

    @Override
    public String getFieldName() {
        return "LBP";
    }
}

