/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.global;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.imageanalysis.utils.ColorConversion;
import net.semanticmetadata.lire.utils.ConversionUtils;
import net.semanticmetadata.lire.utils.ImageUtils;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class SimpleColorHistogram
implements GlobalFeature {
    public static int DEFAULT_NUMBER_OF_BINS = 64;
    public static HistogramType DEFAULT_HISTOGRAM_TYPE = HistogramType.RGB;
    public static DistanceFunction DEFAULT_DISTANCE_FUNCTION = DistanceFunction.JSD;
    private static final int[] quantTable = new int[]{1, 32, 4, 8, 16, 4, 16, 4, 16, 4, 1, 16, 4, 4, 8, 4, 8, 4, 8, 4, 1, 8, 4, 4, 4, 4, 8, 2, 8, 1, 1, 8, 4, 4, 4, 4, 4, 1, 4, 1};
    public static final int[][] rgbPalette64 = new int[][]{{0, 0, 0}, {0, 0, 85}, {0, 0, 170}, {0, 0, 255}, {0, 85, 0}, {0, 85, 85}, {0, 85, 170}, {0, 85, 255}, {0, 170, 0}, {0, 170, 85}, {0, 170, 170}, {0, 170, 255}, {0, 255, 0}, {0, 255, 85}, {0, 255, 170}, {0, 255, 255}, {85, 0, 0}, {85, 0, 85}, {85, 0, 170}, {85, 0, 255}, {85, 85, 0}, {85, 85, 85}, {85, 85, 170}, {85, 85, 255}, {85, 170, 0}, {85, 170, 85}, {85, 170, 170}, {85, 170, 255}, {85, 255, 0}, {85, 255, 85}, {85, 255, 170}, {85, 255, 255}, {170, 0, 0}, {170, 0, 85}, {170, 0, 170}, {170, 0, 255}, {170, 85, 0}, {170, 85, 85}, {170, 85, 170}, {170, 85, 255}, {170, 170, 0}, {170, 170, 85}, {170, 170, 170}, {170, 170, 255}, {170, 255, 0}, {170, 255, 85}, {170, 255, 170}, {170, 255, 255}, {255, 0, 0}, {255, 0, 85}, {255, 0, 170}, {255, 0, 255}, {255, 85, 0}, {255, 85, 85}, {255, 85, 170}, {255, 85, 255}, {255, 170, 0}, {255, 170, 85}, {255, 170, 170}, {255, 170, 255}, {255, 255, 0}, {255, 255, 85}, {255, 255, 170}, {255, 255, 255}};
    public static final int[] quant512 = new int[]{18, 55, 91, 128, 165, 201, 238, 256};
    private int[] pixel = new int[3];
    private int[] histogram;
    private HistogramType histogramType;
    private DistanceFunction distFunc;

    public SimpleColorHistogram() {
        this.histogramType = DEFAULT_HISTOGRAM_TYPE;
        this.histogram = new int[DEFAULT_NUMBER_OF_BINS];
        this.distFunc = DEFAULT_DISTANCE_FUNCTION;
    }

    public SimpleColorHistogram(HistogramType histogramType, DistanceFunction distFunction) {
        this.histogramType = histogramType;
        this.distFunc = distFunction;
        this.histogram = new int[DEFAULT_NUMBER_OF_BINS];
    }

    @Override
    public void extract(BufferedImage image) {
        image = ImageUtils.get8BitRGBImage(image);
        Arrays.fill(this.histogram, 0);
        WritableRaster raster = image.getRaster();
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                raster.getPixel(x, y, this.pixel);
                if (this.histogramType == HistogramType.HSV) {
                    ColorConversion.rgb2hsv(this.pixel[0], this.pixel[1], this.pixel[2], this.pixel);
                    int n = this.quant(this.pixel);
                    this.histogram[n] = this.histogram[n] + 1;
                    continue;
                }
                if (this.histogramType == HistogramType.Luminance) {
                    this.rgb2yuv(this.pixel[0], this.pixel[1], this.pixel[2], this.pixel);
                    continue;
                }
                if (this.histogramType == HistogramType.HMMD) {
                    int n = this.quantHmmd(this.rgb2hmmd(this.pixel[0], this.pixel[1], this.pixel[2]), DEFAULT_NUMBER_OF_BINS);
                    this.histogram[n] = this.histogram[n] + 1;
                    continue;
                }
                int n = this.quant(this.pixel);
                this.histogram[n] = this.histogram[n] + 1;
            }
        }
        this.normalize(this.histogram, image.getWidth() * image.getHeight());
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        return SerializationUtils.toByteArray(this.histogram);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.histogram = SerializationUtils.toIntArray(in);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        this.histogram = SerializationUtils.toIntArray(in, offset, length);
    }

    @Override
    public double[] getFeatureVector() {
        return ConversionUtils.toDouble(this.histogram);
    }

    private void normalize(int[] histogram, int numPixels) {
        int i;
        int max = 0;
        for (i = 0; i < histogram.length; ++i) {
            max = Math.max(histogram[i], max);
        }
        for (i = 0; i < histogram.length; ++i) {
            histogram[i] = histogram[i] * 255 / max;
        }
    }

    private int quant(int[] pixel) {
        if (this.histogramType == HistogramType.HSV) {
            int qS;
            int qV;
            int qH = (int)Math.floor((double)pixel[0] / 11.25);
            if (qH == 32) {
                --qH;
            }
            if ((qV = pixel[1] / 90) == 4) {
                --qV;
            }
            if ((qS = pixel[2] / 25) == 4) {
                --qS;
            }
            return qH * 16 + qV * 4 + qS;
        }
        if (this.histogramType == HistogramType.HMMD) {
            return this.quantHmmd(this.rgb2hmmd(pixel[0], pixel[1], pixel[2]), 255);
        }
        if (this.histogramType == HistogramType.Luminance) {
            return pixel[0] * this.histogram.length / 256;
        }
        int bin = 0;
        if (this.histogram.length == 512) {
            for (int i = 0; i < quant512.length - 1; ++i) {
                if (quant512[i] <= pixel[0] && pixel[0] < quant512[i + 1]) {
                    bin += i + 1;
                }
                if (quant512[i] <= pixel[1] && pixel[1] < quant512[i + 1]) {
                    bin += (i + 1) * 8;
                }
                if (quant512[i] > pixel[2] || pixel[2] >= quant512[i + 1]) continue;
                bin += (i + 1) * 8 * 8;
            }
            return bin;
        }
        int pos = (int)Math.round((double)pixel[2] / 85.0) + (int)Math.round((double)pixel[1] / 85.0) * 4 + (int)Math.round((double)pixel[0] / 85.0) * 4 * 4;
        return pos;
    }

    @Override
    public double getDistance(LireFeature vd) {
        if (!(vd instanceof SimpleColorHistogram)) {
            throw new UnsupportedOperationException("Wrong descriptor.");
        }
        SimpleColorHistogram ch = (SimpleColorHistogram)vd;
        if (ch.histogram.length != this.histogram.length || ch.histogramType != this.histogramType) {
            throw new UnsupportedOperationException("Histogram lengths or color spaces do not match");
        }
        double sum = 0.0;
        if (this.distFunc == DistanceFunction.JSD) {
            return MetricsUtils.jsd(this.histogram, ch.histogram);
        }
        if (this.distFunc == DistanceFunction.TANIMOTO) {
            return MetricsUtils.tanimoto(this.histogram, ch.histogram);
        }
        if (this.distFunc == DistanceFunction.L1) {
            return MetricsUtils.distL1(this.histogram, ch.histogram);
        }
        return MetricsUtils.distL2(this.histogram, ch.histogram);
    }

    public void rgb2yuv(int r, int g, int b, int[] yuv) {
        int y = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
        int u = (int)((float)(b - y) * 0.492f);
        int v = (int)((float)(r - y) * 0.877f);
        yuv[0] = y;
        yuv[1] = u;
        yuv[2] = v;
    }

    private int[] rgb2hmmd(int ir, int ig, int ib) {
        int[] hmmd = new int[5];
        float max = Math.max(Math.max(ir, ig), Math.max(ig, ib));
        float min = Math.min(Math.min(ir, ig), Math.min(ig, ib));
        float diff = max - min;
        float sum = (float)((double)(max + min) / 2.0);
        float hue = 0.0f;
        if (diff == 0.0f) {
            hue = 0.0f;
        } else if ((float)ir == max && ig - ib > 0) {
            hue = (float)(60 * (ig - ib)) / (max - min);
        } else if ((float)ir == max && ig - ib <= 0) {
            hue = (float)(60 * (ig - ib)) / (max - min) + 360.0f;
        } else if ((float)ig == max) {
            hue = (float)(60.0 * (2.0 + (double)((float)(ib - ir) / (max - min))));
        } else if ((float)ib == max) {
            hue = (float)(60.0 * (4.0 + (double)((float)(ir - ig) / (max - min))));
        }
        hmmd[0] = (int)hue;
        hmmd[1] = (int)max;
        hmmd[2] = (int)min;
        hmmd[3] = (int)(diff /= 2.0f);
        hmmd[4] = (int)sum;
        return hmmd;
    }

    private int quantHmmd(int[] hmmd, int quantizationLevels) {
        int h = 0;
        int offset = 0;
        int subspace = 0;
        boolean q = false;
        if (hmmd[3] < 7) {
            subspace = 0;
        } else if (hmmd[3] > 6 && hmmd[3] < 21) {
            subspace = 1;
        } else if (hmmd[3] > 19 && hmmd[3] < 61) {
            subspace = 2;
        } else if (hmmd[3] > 59 && hmmd[3] < 111) {
            subspace = 3;
        } else if (hmmd[3] > 109 && hmmd[3] < 256) {
            subspace = 4;
        }
        if (quantizationLevels == 256) {
            offset = 0;
            h = hmmd[0] / quantizationLevels * quantTable[offset + subspace] + hmmd[4] / quantizationLevels * quantTable[offset + subspace + 1];
        } else if (quantizationLevels == 128) {
            offset = 10;
            h = hmmd[0] / quantizationLevels * quantTable[offset + subspace] + hmmd[4] / quantizationLevels * quantTable[offset + subspace + 1];
        } else if (quantizationLevels == 64) {
            offset = 20;
            h = hmmd[0] / quantizationLevels * quantTable[offset + subspace] + hmmd[4] / quantizationLevels * quantTable[offset + subspace + 1];
        } else if (quantizationLevels == 32) {
            offset = 30;
            h = hmmd[0] / quantizationLevels * quantTable[offset + subspace] + hmmd[4] / quantizationLevels * quantTable[offset + subspace + 1];
        }
        return h;
    }

    @Override
    public String getFeatureName() {
        return "RGB Color Histogram";
    }

    @Override
    public String getFieldName() {
        return "ColorHist";
    }

    public static enum DistanceFunction {
        L1,
        L2,
        TANIMOTO,
        JSD;

    }

    public static enum HistogramType {
        RGB,
        HSV,
        Luminance,
        HMMD;

    }
}

