/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.global;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.WritableRaster;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.utils.ImageUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class Tamura
implements GlobalFeature {
    private static final int MAX_IMG_HEIGHT = 64;
    private int[][] grayScales;
    private int imgWidth;
    private int imgHeight;
    private double[] histogram;
    private static final double[][] filterH = new double[][]{{-1.0, 0.0, 1.0}, {-1.0, 0.0, 1.0}, {-1.0, 0.0, 1.0}};
    private static final double[][] filterV = new double[][]{{-1.0, -1.0, -1.0}, {0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}};
    private static final String TAMURA_NAME = "tamura";

    public double coarseness(int n0, int n1) {
        double result = 0.0;
        for (int i = 1; i < n0 - 1; ++i) {
            for (int j = 1; j < n1 - 1; ++j) {
                result += Math.pow(2.0, this.sizeLeadDiffValue(i, j));
            }
        }
        result = 1.0 / (double)(n0 * n1) * result;
        return result;
    }

    public double averageOverNeighborhoods(int x, int y, int k) {
        double result = 0.0;
        double border = Math.pow(2.0, 2 * k);
        int x0 = 0;
        int y0 = 0;
        int i = 0;
        while ((double)i < border) {
            int j = 0;
            while ((double)j < border) {
                x0 = x - (int)Math.pow(2.0, k - 1) + i;
                y0 = y - (int)Math.pow(2.0, k - 1) + j;
                if (x0 < 0) {
                    x0 = 0;
                }
                if (y0 < 0) {
                    y0 = 0;
                }
                if (x0 >= this.imgWidth) {
                    x0 = this.imgWidth - 1;
                }
                if (y0 >= this.imgHeight) {
                    y0 = this.imgHeight - 1;
                }
                result += (double)this.grayScales[x0][y0];
                ++j;
            }
            ++i;
        }
        result = 1.0 / Math.pow(2.0, 2 * k) * result;
        return result;
    }

    public double differencesBetweenNeighborhoodsHorizontal(int x, int y, int k) {
        double result = 0.0;
        result = Math.abs(this.averageOverNeighborhoods(x + (int)Math.pow(2.0, k - 1), y, k) - this.averageOverNeighborhoods(x - (int)Math.pow(2.0, k - 1), y, k));
        return result;
    }

    public double differencesBetweenNeighborhoodsVertical(int x, int y, int k) {
        double result = 0.0;
        result = Math.abs(this.averageOverNeighborhoods(x, y + (int)Math.pow(2.0, k - 1), k) - this.averageOverNeighborhoods(x, y - (int)Math.pow(2.0, k - 1), k));
        return result;
    }

    public int sizeLeadDiffValue(int x, int y) {
        double result = 0.0;
        int maxK = 1;
        for (int k = 0; k < 3; ++k) {
            double tmp = Math.max(this.differencesBetweenNeighborhoodsHorizontal(x, y, k), this.differencesBetweenNeighborhoodsVertical(x, y, k));
            if (!(result < tmp)) continue;
            maxK = k;
            result = tmp;
        }
        return maxK;
    }

    public double contrast() {
        double result = 0.0;
        double my4 = 0.0;
        double alpha4 = 0.0;
        double my = this.calculateMy();
        double sigma = this.calculateSigma(my);
        if (sigma <= 0.0) {
            return 0.0;
        }
        for (int x = 0; x < this.imgWidth; ++x) {
            for (int y = 0; y < this.imgHeight; ++y) {
                my4 += Math.pow((double)this.grayScales[x][y] - my, 4.0);
            }
        }
        alpha4 = my4 / Math.pow(sigma, 4.0);
        result = sigma / Math.pow(alpha4, 0.25);
        return result;
    }

    public double calculateMy() {
        double mean = 0.0;
        for (int x = 0; x < this.imgWidth; ++x) {
            for (int y = 0; y < this.imgHeight; ++y) {
                mean += (double)this.grayScales[x][y];
            }
        }
        return mean /= (double)(this.imgWidth * this.imgHeight);
    }

    public double calculateSigma(double mean) {
        double result = 0.0;
        for (int x = 0; x < this.imgWidth; ++x) {
            for (int y = 0; y < this.imgHeight; ++y) {
                result += Math.pow((double)this.grayScales[x][y] - mean, 2.0);
            }
        }
        return Math.sqrt(result /= (double)(this.imgWidth * this.imgHeight));
    }

    public double[] directionality() {
        double[] histogram = new double[16];
        double maxResult = 3.0;
        double binWindow = maxResult / (double)(histogram.length - 1);
        int bin = -1;
        for (int x = 1; x < this.imgWidth - 1; ++x) {
            for (int y = 1; y < this.imgHeight - 1; ++y) {
                int n = bin = (int)((1.5707963267948966 + Math.atan(this.calculateDeltaV(x, y) / this.calculateDeltaH(x, y))) / binWindow);
                histogram[n] = histogram[n] + 1.0;
            }
        }
        return histogram;
    }

    public double calculateDeltaH(int x, int y) {
        double result = 0.0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                result += (double)this.grayScales[x - 1 + i][y - 1 + j] * filterH[i][j];
            }
        }
        return result;
    }

    public double calculateDeltaV(int x, int y) {
        double result = 0.0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                result += (double)this.grayScales[x - 1 + i][y - 1 + j] * filterV[i][j];
            }
        }
        return result;
    }

    public double getDistance(double[] targetFeature, double[] queryFeature) {
        double result = 0.0;
        for (int i = 2; i < targetFeature.length; ++i) {
            result += Math.pow(targetFeature[i] - queryFeature[i], 2.0);
        }
        return result;
    }

    @Override
    public void extract(BufferedImage image) {
        int i;
        this.histogram = new double[18];
        ColorConvertOp op = new ColorConvertOp(image.getColorModel().getColorSpace(), ColorSpace.getInstance(1003), new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
        BufferedImage bimg = op.filter(image, null);
        bimg = ImageUtils.scaleImage(bimg, 64);
        WritableRaster raster = bimg.getRaster();
        int[] tmp = new int[3];
        this.grayScales = new int[raster.getWidth()][raster.getHeight()];
        for (i = 0; i < raster.getWidth(); ++i) {
            for (int j = 0; j < raster.getHeight(); ++j) {
                raster.getPixel(i, j, tmp);
                this.grayScales[i][j] = tmp[0];
            }
        }
        this.imgWidth = bimg.getWidth();
        this.imgHeight = bimg.getHeight();
        this.histogram[0] = this.coarseness(bimg.getWidth(), bimg.getHeight());
        this.histogram[1] = this.contrast();
        double[] directionality = this.directionality();
        for (i = 2; i < this.histogram.length; ++i) {
            this.histogram[i] = directionality[i - 2];
        }
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        return SerializationUtils.toByteArray(this.histogram);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.histogram = SerializationUtils.toDoubleArray(in);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        this.histogram = SerializationUtils.toDoubleArray(in, offset, length);
    }

    @Override
    public double[] getFeatureVector() {
        return this.histogram;
    }

    @Override
    public double getDistance(LireFeature feature) {
        if (!(feature instanceof Tamura)) {
            throw new UnsupportedOperationException("Wrong descriptor.");
        }
        Tamura tamura = (Tamura)feature;
        return this.getDistance(tamura.histogram, this.histogram);
    }

    @Override
    public String getFeatureName() {
        return "Tamura Features";
    }

    @Override
    public String getFieldName() {
        return "TAMURA";
    }
}

