/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.global.centrist;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.utils.ImageUtils;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class SimpleCentrist
implements GlobalFeature {
    private boolean applyMaxNorm = false;
    double[] histogram;

    @Override
    public void extract(BufferedImage image) {
        this.histogram = new double[256];
        for (int i = 0; i < this.histogram.length; ++i) {
            this.histogram[i] = 0.0;
        }
        WritableRaster raster = ImageUtils.getGrayscaleImage(image).getRaster();
        int[] px = new int[3];
        for (int x = 1; x < raster.getWidth() - 1; ++x) {
            for (int y = 1; y < raster.getHeight() - 1; ++y) {
                raster.getPixel(x, y, px);
                int ctValue = 0;
                int intensity = px[0];
                if (raster.getPixel(x - 1, y - 1, px)[0] <= intensity) {
                    ctValue |= 1;
                }
                if (raster.getPixel(x, y - 1, px)[0] <= intensity) {
                    ctValue |= 2;
                }
                if (raster.getPixel(x + 1, y - 1, px)[0] <= intensity) {
                    ctValue |= 4;
                }
                if (raster.getPixel(x - 1, y + 1, px)[0] <= intensity) {
                    ctValue |= 8;
                }
                if (raster.getPixel(x, y + 1, px)[0] <= intensity) {
                    ctValue |= 0x10;
                }
                if (raster.getPixel(x + 1, y + 1, px)[0] <= intensity) {
                    ctValue |= 0x20;
                }
                if (raster.getPixel(x - 1, y, px)[0] <= intensity) {
                    ctValue |= 0x40;
                }
                if (raster.getPixel(x + 1, y, px)[0] <= intensity) {
                    ctValue |= 0x80;
                }
                int n = Math.min(ctValue, 255);
                this.histogram[n] = this.histogram[n] + 1.0;
            }
        }
        if (this.applyMaxNorm) {
            this.normalize(this.histogram);
        }
    }

    private void normalize(double[] in) {
        double max = 0.0;
        for (double d : in) {
            max = Math.max(max, d);
        }
        for (int i = 0; i < in.length; ++i) {
            in[i] = in[i] / max;
        }
    }

    @Override
    public String getFeatureName() {
        return "SimpleCentrist";
    }

    @Override
    public String getFieldName() {
        return "SimpleCentrist";
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        return SerializationUtils.toByteArray(this.histogram);
    }

    @Override
    public void setByteArrayRepresentation(byte[] featureData) {
        this.setByteArrayRepresentation(featureData, 0, featureData.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] featureData, int offset, int length) {
        this.histogram = SerializationUtils.toDoubleArray(featureData, offset, length);
    }

    @Override
    public double getDistance(LireFeature feature) {
        if (feature instanceof SimpleCentrist) {
            return MetricsUtils.distL1(this.histogram, feature.getFeatureVector());
        }
        return -1.0;
    }

    @Override
    public double[] getFeatureVector() {
        return this.histogram;
    }
}

