/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.global.centrist;

import java.awt.image.BufferedImage;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.imageanalysis.features.global.centrist.SimpleCentrist;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class SpatialPyramidCentrist
implements GlobalFeature {
    private boolean applyMaxNorm = true;
    private int histLength = 256;
    int histogramSize = this.histLength * 6 + this.histLength * 4 * 4 + this.histLength * 9;
    double[] histogram = new double[this.histogramSize];

    @Override
    public void extract(BufferedImage image) {
        int j;
        int i;
        SimpleCentrist simpleCentrist = new SimpleCentrist();
        simpleCentrist.extract(image);
        System.arraycopy(simpleCentrist.getFeatureVector(), 0, this.histogram, 0, this.histLength);
        int w = image.getWidth() / 2;
        int h = image.getHeight() / 2;
        simpleCentrist.extract(image.getSubimage(0, 0, w, h));
        System.arraycopy(simpleCentrist.getFeatureVector(), 0, this.histogram, this.histLength * 1, this.histLength);
        simpleCentrist.extract(image.getSubimage(w, 0, w, h));
        System.arraycopy(simpleCentrist.getFeatureVector(), 0, this.histogram, this.histLength * 2, this.histLength);
        simpleCentrist.extract(image.getSubimage(0, h, w, h));
        System.arraycopy(simpleCentrist.getFeatureVector(), 0, this.histogram, this.histLength * 3, this.histLength);
        simpleCentrist.extract(image.getSubimage(w, h, w, h));
        System.arraycopy(simpleCentrist.getFeatureVector(), 0, this.histogram, this.histLength * 4, this.histLength);
        simpleCentrist.extract(image.getSubimage(w / 2, h / 2, w, h));
        System.arraycopy(simpleCentrist.getFeatureVector(), 0, this.histogram, this.histLength * 5, this.histLength);
        int wstep = image.getWidth() / 4;
        int hstep = image.getHeight() / 4;
        int binPos = 6;
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                simpleCentrist.extract(image.getSubimage(i * wstep, j * hstep, wstep, hstep));
                System.arraycopy(simpleCentrist.getFeatureVector(), 0, this.histogram, this.histLength * binPos, this.histLength);
                ++binPos;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                simpleCentrist.extract(image.getSubimage(wstep / 2 + i * wstep, hstep / 2 + j * hstep, wstep, hstep));
                System.arraycopy(simpleCentrist.getFeatureVector(), 0, this.histogram, this.histLength * binPos, this.histLength);
                ++binPos;
            }
        }
        if (this.applyMaxNorm) {
            this.normalize(this.histogram);
        }
    }

    private void normalize(double[] in) {
        double max = 0.0;
        for (double d : in) {
            max = Math.max(max, d);
        }
        for (int i = 0; i < in.length; ++i) {
            in[i] = in[i] / max;
        }
    }

    @Override
    public String getFeatureName() {
        return "Centrist";
    }

    @Override
    public String getFieldName() {
        return "Centrist";
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        return SerializationUtils.toByteArray(this.histogram);
    }

    @Override
    public void setByteArrayRepresentation(byte[] featureData) {
        this.setByteArrayRepresentation(featureData, 0, featureData.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] featureData, int offset, int length) {
        this.histogram = SerializationUtils.toDoubleArray(featureData, offset, length);
    }

    @Override
    public double getDistance(LireFeature feature) {
        if (feature instanceof SpatialPyramidCentrist) {
            return MetricsUtils.distL1(this.histogram, feature.getFeatureVector());
        }
        return -1.0;
    }

    @Override
    public double[] getFeatureVector() {
        return this.histogram;
    }
}

