/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.global.joint;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.utils.ImageUtils;
import net.semanticmetadata.lire.utils.MetricsUtils;

public class LocalBinaryPatternsAndOpponent
implements GlobalFeature {
    static final double sq2 = Math.sqrt(2.0);
    static final double sq6 = Math.sqrt(3.0);
    static final double sq3 = Math.sqrt(6.0);
    double[] histogram = new double[288];
    static int[] binTranslate = new int[256];

    @Override
    public void extract(BufferedImage image) {
        Arrays.fill(this.histogram, 0.0);
        this.extractWithRadiusOne(image);
    }

    private void extractWithRadiusOne(BufferedImage image) {
        int i;
        int colorPos = 0;
        WritableRaster raster = ImageUtils.getGrayscaleImage(image).getRaster();
        WritableRaster rasterColor = image.getRaster();
        int[] pixel = new int[9];
        int[] pattern = new int[8];
        int[] px = new int[3];
        for (int x = 0; x < raster.getWidth() - 2; ++x) {
            for (int y = 0; y < raster.getHeight() - 2; ++y) {
                Arrays.fill(pattern, 0);
                raster.getPixels(x, y, 3, 3, pixel);
                if (pixel[0] >= pixel[4]) {
                    pattern[0] = 1;
                }
                if (pixel[1] >= pixel[4]) {
                    pattern[1] = 1;
                }
                if (pixel[2] >= pixel[4]) {
                    pattern[2] = 1;
                }
                if (pixel[5] >= pixel[4]) {
                    pattern[3] = 1;
                }
                if (pixel[8] >= pixel[4]) {
                    pattern[4] = 1;
                }
                if (pixel[7] >= pixel[4]) {
                    pattern[5] = 1;
                }
                if (pixel[6] >= pixel[4]) {
                    pattern[6] = 1;
                }
                if (pixel[3] >= pixel[4]) {
                    pattern[7] = 1;
                }
                rasterColor.getPixel(x, y, px);
                double o1 = (double)(px[0] - px[1]) / sq2;
                double o2 = (double)(px[0] + px[1] - 2 * px[2]) / sq6;
                double o3 = (double)(px[0] + px[1] + px[2]) / sq3;
                o1 = (o1 + 255.0 / sq2) / (510.0 / sq2);
                o2 = (o2 + 510.0 / sq6) / (1020.0 / sq6);
                colorPos = (int)Math.min(Math.floor(o1 * 2.0), 1.0) + (int)Math.min(Math.floor(o2 * 2.0), 1.0) * 2 + (int)Math.min(Math.floor((o3 /= 765.0 / sq3) * 2.0), 1.0) * 2 * 2;
                int n = colorPos * 36 + this.getBin(pattern);
                this.histogram[n] = this.histogram[n] + 1.0;
            }
        }
        double max = 0.0;
        for (i = 0; i < this.histogram.length; ++i) {
            max = Math.max(this.histogram[i], max);
        }
        for (i = 0; i < this.histogram.length; ++i) {
            this.histogram[i] = Math.floor(this.histogram[i] / max * 8.0);
        }
    }

    private int getBin(int[] pattern) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < 8; ++i) {
            min = Math.min(this.getNumber(pattern), min);
            int tmp = pattern[7];
            for (int j = pattern.length - 1; j > 0; --j) {
                pattern[j] = pattern[j - 1];
            }
            pattern[0] = tmp;
        }
        return binTranslate[min];
    }

    private int getNumber(int[] pattern) {
        int result = 0;
        int current = 1;
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] > 0) {
                result += current;
            }
            current *= 2;
        }
        return result;
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        byte[] rep = new byte[this.histogram.length];
        for (int i = 0; i < this.histogram.length; ++i) {
            rep[i] = (byte)this.histogram[i];
        }
        return rep;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.setByteArrayRepresentation(in, 0, in.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.histogram[i - offset] = in[i];
        }
    }

    @Override
    public double[] getFeatureVector() {
        return this.histogram;
    }

    @Override
    public double getDistance(LireFeature feature) {
        return MetricsUtils.tanimoto(this.histogram, feature.getFeatureVector());
    }

    @Override
    public String getFeatureName() {
        return "LBP Opponent Joint Histogram";
    }

    @Override
    public String getFieldName() {
        return "LBPOpp";
    }

    static {
        Arrays.fill(binTranslate, 0);
        LocalBinaryPatternsAndOpponent.binTranslate[0] = 0;
        LocalBinaryPatternsAndOpponent.binTranslate[1] = 1;
        LocalBinaryPatternsAndOpponent.binTranslate[3] = 2;
        LocalBinaryPatternsAndOpponent.binTranslate[5] = 3;
        LocalBinaryPatternsAndOpponent.binTranslate[7] = 4;
        LocalBinaryPatternsAndOpponent.binTranslate[9] = 5;
        LocalBinaryPatternsAndOpponent.binTranslate[11] = 6;
        LocalBinaryPatternsAndOpponent.binTranslate[13] = 7;
        LocalBinaryPatternsAndOpponent.binTranslate[15] = 8;
        LocalBinaryPatternsAndOpponent.binTranslate[17] = 9;
        LocalBinaryPatternsAndOpponent.binTranslate[19] = 10;
        LocalBinaryPatternsAndOpponent.binTranslate[21] = 11;
        LocalBinaryPatternsAndOpponent.binTranslate[23] = 12;
        LocalBinaryPatternsAndOpponent.binTranslate[25] = 13;
        LocalBinaryPatternsAndOpponent.binTranslate[27] = 14;
        LocalBinaryPatternsAndOpponent.binTranslate[29] = 15;
        LocalBinaryPatternsAndOpponent.binTranslate[31] = 16;
        LocalBinaryPatternsAndOpponent.binTranslate[37] = 17;
        LocalBinaryPatternsAndOpponent.binTranslate[39] = 18;
        LocalBinaryPatternsAndOpponent.binTranslate[43] = 19;
        LocalBinaryPatternsAndOpponent.binTranslate[45] = 20;
        LocalBinaryPatternsAndOpponent.binTranslate[47] = 21;
        LocalBinaryPatternsAndOpponent.binTranslate[51] = 22;
        LocalBinaryPatternsAndOpponent.binTranslate[53] = 23;
        LocalBinaryPatternsAndOpponent.binTranslate[55] = 24;
        LocalBinaryPatternsAndOpponent.binTranslate[59] = 25;
        LocalBinaryPatternsAndOpponent.binTranslate[61] = 26;
        LocalBinaryPatternsAndOpponent.binTranslate[63] = 27;
        LocalBinaryPatternsAndOpponent.binTranslate[85] = 28;
        LocalBinaryPatternsAndOpponent.binTranslate[87] = 29;
        LocalBinaryPatternsAndOpponent.binTranslate[91] = 30;
        LocalBinaryPatternsAndOpponent.binTranslate[95] = 31;
        LocalBinaryPatternsAndOpponent.binTranslate[111] = 32;
        LocalBinaryPatternsAndOpponent.binTranslate[119] = 33;
        LocalBinaryPatternsAndOpponent.binTranslate[127] = 34;
        LocalBinaryPatternsAndOpponent.binTranslate[255] = 35;
    }
}

