/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.global.mpeg7;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.logging.Logger;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class ScalableColorImpl {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    double[] descriptor;
    protected BufferedImage img;
    protected int NumberOfCoefficients = 64;
    protected int NumberOfBitplanesDiscarded = 0;
    protected int _ySize;
    protected int _xSize;
    protected int _h_value;
    protected int _s_value;
    protected int _v_value;
    protected double _quant_h;
    protected double _quant_s;
    protected double _quant_v;
    protected int _xNumOfBlocks;
    protected int _yNumOfBlocks;
    protected int[][][] _wholeHist = null;
    protected int[] haarTransformedHistogram;
    protected static int[][] scalableColorQuantValues = new int[][]{{217, 9, 255}, {-71, 9, 255}, {-27, 8, 127}, {-54, 9, 255}, {-8, 7, 63}, {-14, 7, 63}, {-22, 7, 63}, {-29, 8, 127}, {-6, 6, 31}, {-13, 7, 63}, {-11, 6, 31}, {-22, 7, 63}, {-9, 7, 63}, {-14, 7, 63}, {-19, 7, 63}, {-22, 7, 63}, {0, 4, 7}, {-1, 5, 15}, {0, 3, 3}, {-2, 6, 31}, {1, 5, 15}, {-5, 6, 31}, {0, 5, 15}, {0, 7, 63}, {2, 5, 15}, {-2, 6, 31}, {-2, 5, 15}, {0, 7, 63}, {3, 5, 15}, {-5, 6, 31}, {-1, 6, 31}, {4, 7, 63}, {0, 3, 3}, {0, 3, 3}, {0, 3, 3}, {-1, 5, 15}, {0, 3, 3}, {0, 3, 3}, {-1, 5, 15}, {-2, 5, 15}, {-1, 5, 15}, {-1, 4, 7}, {-1, 5, 15}, {-3, 5, 15}, {-1, 5, 15}, {-2, 5, 15}, {-4, 5, 15}, {-5, 5, 15}, {-1, 5, 15}, {0, 3, 3}, {-2, 5, 15}, {-2, 5, 15}, {-2, 5, 15}, {-3, 5, 15}, {-3, 5, 15}, {0, 5, 15}, {0, 5, 15}, {0, 5, 15}, {0, 5, 15}, {2, 5, 15}, {-1, 5, 15}, {0, 5, 15}, {3, 6, 31}, {3, 5, 15}, {0, 2, 1}, {0, 2, 1}, {0, 3, 3}, {0, 4, 7}, {0, 2, 1}, {0, 2, 1}, {0, 3, 3}, {-1, 4, 7}, {-1, 4, 7}, {-1, 4, 7}, {-2, 5, 15}, {-1, 5, 15}, {-2, 5, 15}, {-2, 5, 15}, {-2, 5, 15}, {-1, 5, 15}, {0, 3, 3}, {0, 2, 1}, {0, 3, 3}, {-1, 4, 7}, {0, 2, 1}, {0, 3, 3}, {-1, 4, 7}, {-1, 5, 15}, {-2, 5, 15}, {-1, 4, 7}, {-2, 5, 15}, {-1, 5, 15}, {-3, 5, 15}, {-3, 5, 15}, {-2, 5, 15}, {0, 5, 15}, {0, 3, 3}, {0, 3, 3}, {0, 3, 3}, {-1, 4, 7}, {0, 3, 3}, {0, 3, 3}, {-2, 5, 15}, {-2, 5, 15}, {-2, 5, 15}, {-2, 4, 7}, {-2, 5, 15}, {-1, 5, 15}, {-3, 5, 15}, {-3, 5, 15}, {-1, 5, 15}, {0, 5, 15}, {1, 4, 7}, {0, 3, 3}, {0, 4, 7}, {-1, 4, 7}, {0, 3, 3}, {0, 4, 7}, {-1, 4, 7}, {0, 4, 7}, {-1, 4, 7}, {-1, 3, 3}, {-1, 4, 7}, {0, 4, 7}, {-1, 5, 15}, {0, 5, 15}, {1, 5, 15}, {-1, 5, 15}, {0, 2, 1}, {0, 2, 1}, {0, 3, 3}, {0, 3, 3}, {0, 2, 1}, {0, 2, 1}, {0, 3, 3}, {0, 3, 3}, {0, 2, 1}, {0, 2, 1}, {0, 3, 3}, {0, 4, 7}, {0, 2, 1}, {0, 2, 1}, {0, 3, 3}, {0, 3, 3}, {0, 3, 3}, {0, 2, 1}, {0, 3, 3}, {1, 4, 7}, {0, 2, 1}, {0, 3, 3}, {-1, 4, 7}, {1, 4, 7}, {0, 3, 3}, {0, 3, 3}, {0, 3, 3}, {0, 4, 7}, {0, 3, 3}, {0, 3, 3}, {-1, 4, 7}, {0, 4, 7}, {0, 3, 3}, {0, 2, 1}, {0, 3, 3}, {0, 3, 3}, {0, 2, 1}, {0, 2, 1}, {0, 3, 3}, {0, 3, 3}, {0, 3, 3}, {0, 2, 1}, {0, 3, 3}, {1, 4, 7}, {0, 2, 1}, {0, 3, 3}, {0, 4, 7}, {1, 4, 7}, {0, 3, 3}, {0, 2, 1}, {0, 3, 3}, {1, 5, 15}, {0, 3, 3}, {0, 3, 3}, {-1, 5, 15}, {2, 5, 15}, {0, 3, 3}, {0, 3, 3}, {0, 3, 3}, {0, 4, 7}, {0, 3, 3}, {0, 3, 3}, {-1, 4, 7}, {1, 5, 15}, {0, 3, 3}, {0, 2, 1}, {0, 3, 3}, {0, 3, 3}, {0, 2, 1}, {0, 3, 3}, {0, 4, 7}, {0, 4, 7}, {0, 3, 3}, {0, 2, 1}, {0, 3, 3}, {1, 4, 7}, {0, 3, 3}, {0, 3, 3}, {-1, 5, 15}, {1, 5, 15}, {0, 3, 3}, {0, 2, 1}, {-1, 3, 3}, {1, 5, 15}, {0, 3, 3}, {-1, 4, 7}, {-1, 5, 15}, {2, 5, 15}, {0, 3, 3}, {0, 3, 3}, {0, 3, 3}, {0, 4, 7}, {0, 3, 3}, {-1, 3, 3}, {0, 4, 7}, {1, 4, 7}, {1, 3, 3}, {0, 2, 1}, {-1, 3, 3}, {0, 3, 3}, {0, 3, 3}, {0, 3, 3}, {0, 3, 3}, {1, 4, 7}, {0, 3, 3}, {0, 2, 1}, {-1, 3, 3}, {0, 4, 7}, {0, 3, 3}, {0, 3, 3}, {0, 4, 7}, {1, 4, 7}, {0, 3, 3}, {0, 2, 1}, {0, 3, 3}, {0, 4, 7}, {0, 3, 3}, {-1, 3, 3}, {0, 4, 7}, {1, 4, 7}, {0, 3, 3}, {0, 3, 3}, {0, 3, 3}, {0, 3, 3}, {0, 3, 3}, {-1, 3, 3}, {0, 3, 3}, {-1, 4, 7}};
    protected static final int[][] tabelle = new int[][]{{0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 4, 8, 12, 0, 4, 8, 12, 0, 4, 8, 12, 0, 4, 8, 12, 0, 4, 8, 12, 0, 4, 8, 12, 0, 4, 8, 12, 0, 8, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 14, 14, 14, 14, 14, 14, 14, 14, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 10, 0, 0, 0, 0, 2, 2, 2, 2, 8, 8, 8, 8, 10, 10, 10, 10, 0, 0, 0, 0, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0}, {1, 3, 5, 7, 9, 11, 13, 15, 1, 3, 5, 7, 9, 11, 13, 15, 1, 3, 5, 7, 9, 11, 13, 15, 1, 3, 5, 7, 9, 11, 13, 15, 1, 3, 5, 7, 9, 11, 13, 15, 1, 3, 5, 7, 9, 11, 13, 15, 1, 3, 5, 7, 9, 11, 13, 15, 1, 3, 5, 7, 9, 11, 13, 15, 1, 3, 5, 7, 9, 11, 13, 15, 1, 3, 5, 7, 9, 11, 13, 15, 1, 3, 5, 7, 9, 11, 13, 15, 1, 3, 5, 7, 9, 11, 13, 15, 1, 3, 5, 7, 9, 11, 13, 15, 1, 3, 5, 7, 9, 11, 13, 15, 1, 3, 5, 7, 9, 11, 13, 15, 1, 3, 5, 7, 9, 11, 13, 15, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14, 2, 6, 10, 14, 2, 6, 10, 14, 2, 6, 10, 14, 2, 6, 10, 14, 0, 4, 8, 12, 0, 4, 8, 12, 0, 4, 8, 12, 4, 12, 8}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 5, 5, 5, 5, 5, 5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 9, 9, 9, 9, 9, 9, 11, 11, 11, 11, 11, 11, 11, 11, 13, 13, 13, 13, 13, 13, 13, 13, 15, 15, 15, 15, 15, 15, 15, 15, 4, 4, 4, 4, 4, 4, 4, 4, 6, 6, 6, 6, 6, 6, 6, 6, 12, 12, 12, 12, 12, 12, 12, 12, 14, 14, 14, 14, 14, 14, 14, 14, 0, 0, 0, 0, 2, 2, 2, 2, 8, 8, 8, 8, 10, 10, 10, 10, 2, 2, 2, 2, 10, 10, 10, 10, 8, 8, 8, 8, 0, 0, 0}, {128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 4, 4, 2, 2, 1}};
    protected static final int[] sorttab = new int[]{0, 4, 8, 12, 32, 36, 40, 44, 128, 132, 136, 140, 160, 164, 168, 172, 2, 6, 10, 14, 34, 38, 42, 46, 130, 134, 138, 142, 162, 166, 170, 174, 64, 66, 68, 70, 72, 74, 76, 78, 96, 98, 100, 102, 104, 106, 108, 110, 192, 194, 196, 198, 200, 202, 204, 206, 224, 226, 228, 230, 232, 234, 236, 238, 16, 18, 20, 22, 24, 26, 28, 30, 48, 50, 52, 54, 56, 58, 60, 62, 80, 82, 84, 86, 88, 90, 92, 94, 112, 114, 116, 118, 120, 122, 124, 126, 144, 146, 148, 150, 152, 154, 156, 158, 176, 178, 180, 182, 184, 186, 188, 190, 208, 210, 212, 214, 216, 218, 220, 222, 240, 242, 244, 246, 248, 250, 252, 254, 1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 41, 43, 45, 47, 49, 51, 53, 55, 57, 59, 61, 63, 65, 67, 69, 71, 73, 75, 77, 79, 81, 83, 85, 87, 89, 91, 93, 95, 97, 99, 101, 103, 105, 107, 109, 111, 113, 115, 117, 119, 121, 123, 125, 127, 129, 131, 133, 135, 137, 139, 141, 143, 145, 147, 149, 151, 153, 155, 157, 159, 161, 163, 165, 167, 169, 171, 173, 175, 177, 179, 181, 183, 185, 187, 189, 191, 193, 195, 197, 199, 201, 203, 205, 207, 209, 211, 213, 215, 217, 219, 221, 223, 225, 227, 229, 231, 233, 235, 237, 239, 241, 243, 245, 247, 249, 251, 253, 255};
    private int[] pixels = null;

    public ScalableColorImpl() {
    }

    public ScalableColorImpl(BufferedImage image, int NumberOfCoefficients, int NumberOfBitplanesDiscarded) {
        this.img = image;
        int numC = NumberOfCoefficients;
        if (numC < 31) {
            numC = 16;
        } else if (numC < 64) {
            numC = 32;
        } else if (numC < 128) {
            numC = 64;
        } else if (numC < 256) {
            numC = 128;
        } else if (numC >= 256) {
            numC = 256;
        }
        int numB = NumberOfBitplanesDiscarded;
        if (numB < 1) {
            numB = 0;
        }
        if (numB > 8) {
            numB = 8;
        }
        this.NumberOfBitplanesDiscarded = numB;
        this.NumberOfCoefficients = numC;
        this._xSize = this.img.getWidth();
        this._ySize = this.img.getHeight();
        this.init();
        this.extract();
    }

    public ScalableColorImpl(BufferedImage image) {
        this.img = image;
        this.NumberOfBitplanesDiscarded = 0;
        this.NumberOfCoefficients = 64;
        this._xSize = this.img.getWidth();
        this._ySize = this.img.getHeight();
        this.init();
        this.extract();
    }

    public void extract(BufferedImage image) {
        this.img = image;
        this.NumberOfBitplanesDiscarded = 0;
        this.NumberOfCoefficients = 64;
        this._xSize = this.img.getWidth();
        this._ySize = this.img.getHeight();
        this.init();
        this.extract();
    }

    public ScalableColorImpl(int[] pixels) {
        this.img = null;
        this.NumberOfBitplanesDiscarded = 0;
        this.NumberOfCoefficients = 64;
        this._xSize = 1;
        this._ySize = pixels.length / 3;
        this.pixels = pixels;
        this.init();
        this.extract();
    }

    protected void init() {
        this._xNumOfBlocks = 1;
        this._yNumOfBlocks = 1;
        this._h_value = 16;
        this._s_value = 4;
        this._v_value = 4;
        this.descriptor = new double[this.NumberOfCoefficients];
    }

    protected void extract() {
        int m;
        int imageColSize = this._xSize * this._ySize * 3;
        int[] hsvImageBuffer = this.createHsvImageBuffer(imageColSize);
        if (this._xNumOfBlocks > this._xSize) {
            this._xNumOfBlocks = this._xSize;
        }
        if (this._yNumOfBlocks > this._ySize) {
            this._yNumOfBlocks = this._ySize;
        }
        int width = this._xSize / this._xNumOfBlocks;
        int height = this._ySize / this._yNumOfBlocks;
        this._wholeHist = new int[this._h_value][this._s_value][this._v_value];
        for (int k = 0; k < this._h_value; ++k) {
            for (int l = 0; l < this._s_value; ++l) {
                for (m = 0; m < this._v_value; ++m) {
                    this._wholeHist[k][l][m] = 0;
                }
            }
        }
        int x = 0;
        int y = 0;
        for (m = 0; m < this._xNumOfBlocks; ++m) {
            for (int n = 0; n < this._yNumOfBlocks; ++n) {
                for (int j = y; j < y + height; ++j) {
                    int xy;
                    for (int i = xy = x * 3 + j * this._xSize * 3; i < xy + width * 3; i += 3) {
                        this._Quant(hsvImageBuffer[i], hsvImageBuffer[i + 1], hsvImageBuffer[i + 2], m, n);
                    }
                }
                y += height;
            }
            x += width;
            y = 0;
        }
        int sumPixels = 0;
        int[] tmpHist = new int[this._h_value * this._v_value * this._s_value];
        int count = 0;
        for (int k = 0; k < this._v_value; ++k) {
            for (int l = 0; l < this._s_value; ++l) {
                for (int m2 = 0; m2 < this._h_value; ++m2) {
                    tmpHist[count] = this._wholeHist[m2][l][k];
                    sumPixels += tmpHist[count];
                    ++count;
                }
            }
        }
        this.QuantizeHistogram(tmpHist, sumPixels);
        this.haarTransformedHistogram = this.HaarTransform(tmpHist);
        this.descriptor = SerializationUtils.toDoubleArray(this.haarTransformedHistogram);
    }

    private int[] createHsvImageBuffer(int imageColSize) {
        int[] hsvImageBuffer;
        block3: {
            block2: {
                hsvImageBuffer = null;
                hsvImageBuffer = new int[imageColSize];
                if (this.img == null) break block2;
                int[] hsv = new int[3];
                WritableRaster raster = this.img.getRaster();
                int[] pixel = raster.getNumBands() > 3 ? new int[raster.getNumBands()] : new int[3];
                for (int i = 0; i < imageColSize; i += 3) {
                    raster.getPixel(i / 3 % this._xSize, i / 3 / this._xSize, pixel);
                    ScalableColorImpl.convertRgbToHsv(pixel[0], pixel[1], pixel[2], hsv);
                    hsvImageBuffer[i] = hsv[0];
                    hsvImageBuffer[i + 1] = hsv[1];
                    hsvImageBuffer[i + 2] = hsv[2];
                }
                break block3;
            }
            if (this.pixels == null) break block3;
            int[] hsv = new int[3];
            for (int i = 0; i < this.pixels.length; i += 3) {
                ScalableColorImpl.convertRgbToHsv(this.pixels[i], this.pixels[i + 1], this.pixels[i + 2], hsv);
                hsvImageBuffer[i] = hsv[0];
                hsvImageBuffer[i + 1] = hsv[1];
                hsvImageBuffer[i + 2] = hsv[2];
            }
        }
        return hsvImageBuffer;
    }

    public void recalc() {
        if (this.img != null) {
            int[] tmpHist = new int[this._h_value * this._v_value * this._s_value];
            int count = 0;
            int sumPixels = 0;
            for (int k = 0; k < this._v_value; ++k) {
                for (int l = 0; l < this._s_value; ++l) {
                    for (int m = 0; m < this._h_value; ++m) {
                        tmpHist[count] = this._wholeHist[m][l][k];
                        sumPixels += tmpHist[count];
                        ++count;
                    }
                }
            }
            this.QuantizeHistogram(tmpHist, sumPixels);
            this.haarTransformedHistogram = this.HaarTransform(tmpHist);
            this.descriptor = SerializationUtils.toDoubleArray(this.haarTransformedHistogram);
        }
    }

    protected static void convertRgbToHsv(int R, int G, int B, int[] hsv) {
        double floath;
        int order;
        int minrgb;
        int maxrgb;
        if (G > B) {
            if (R > G) {
                maxrgb = R;
                minrgb = B;
                order = 0;
            } else if (B > R) {
                maxrgb = G;
                minrgb = R;
                order = 1;
            } else {
                maxrgb = G;
                minrgb = B;
                order = 2;
            }
        } else if (R > B) {
            maxrgb = R;
            minrgb = G;
            order = 3;
        } else if (G > R) {
            maxrgb = B;
            minrgb = R;
            order = 4;
        } else {
            maxrgb = B;
            minrgb = G;
            order = 5;
        }
        if (maxrgb == 0) {
            hsv[0] = 0;
            hsv[1] = 0;
            hsv[2] = 0;
            return;
        }
        hsv[2] = maxrgb;
        hsv[1] = (maxrgb - minrgb) * 255 / maxrgb;
        if (maxrgb == minrgb) {
            hsv[0] = 0;
            return;
        }
        switch (order) {
            case 0: {
                floath = 1.0 - (double)(R - G) / (double)(R - B);
                break;
            }
            case 1: {
                floath = 3.0 - (double)(G - B) / (double)(G - R);
                break;
            }
            case 2: {
                floath = 1.0 + (double)(G - R) / (double)(G - B);
                break;
            }
            case 3: {
                floath = 5.0 + (double)(R - B) / (double)(R - G);
                break;
            }
            case 4: {
                floath = 3.0 + (double)(B - G) / (double)(B - R);
                break;
            }
            case 5: {
                floath = 5.0 - (double)(B - R) / (double)(B - G);
                break;
            }
            default: {
                System.err.println("Error: Internal error in RGB to HSV transformation");
                floath = 0.0;
            }
        }
        hsv[0] = (int)(floath / 6.0 * 255.0);
    }

    protected void _Quant(int H, int S, int V, int m, int n) {
        int i = (int)((float)(H * this._h_value) / 256.0f);
        int j = (int)((float)(S * this._s_value) / 256.0f);
        int k = (int)((float)(V * this._v_value) / 256.0f);
        int[] nArray = this._wholeHist[i][j];
        int n2 = k;
        nArray[n2] = nArray[n2] + 1;
    }

    public int getSimilarity(ScalableColorImpl secHist) {
        int diffsum = 0;
        int diff = 0;
        if (secHist.NumberOfBitplanesDiscarded == this.NumberOfBitplanesDiscarded && secHist.NumberOfCoefficients == this.NumberOfCoefficients && secHist.haarTransformedHistogram != null && this.haarTransformedHistogram != null) {
            int[] secHaarHist = secHist.haarTransformedHistogram;
            for (int l = 0; l < this.NumberOfCoefficients; ++l) {
                diff = Math.abs(secHaarHist[l] - this.haarTransformedHistogram[l]);
                diffsum += diff;
            }
        } else {
            if (this.haarTransformedHistogram != null && secHist.haarTransformedHistogram != null) {
                this.logger.info("NumberOfBitplanesDiscarded and/or NumberOfCoefficients not matching");
            } else {
                this.logger.info("One of the Descriptor histograms is NULL");
            }
            return -1;
        }
        return diffsum;
    }

    static void histo_3d_hirarch_5(int[][] tabelle, int tablae, int[] histogram, int h_size, int s_size, int v_size, int hist_nr) {
        int i;
        int[][] matrix = new int[16][16];
        for (i = 0; i < h_size * s_size * v_size; ++i) {
            matrix[i % h_size][i / h_size] = histogram[i];
        }
        for (i = 0; i < tablae; ++i) {
            int y1 = tabelle[0][i];
            int x1 = tabelle[1][i];
            int y2 = tabelle[2][i];
            int x2 = tabelle[3][i];
            int sum = matrix[y1][x1] + matrix[y2][x2];
            int dif = matrix[y2][x2] - matrix[y1][x1];
            matrix[y1][x1] = sum;
            matrix[y2][x2] = dif;
        }
        for (i = 0; i < h_size * s_size * v_size; ++i) {
            histogram[i] = matrix[i % h_size][i / h_size];
        }
    }

    private static void histo_3d_hirarch_16_5(int[][] tabelle, int tablae, int[] histogram, int h_size, int s_size, int v_size, int hist_nr) {
        int i;
        int[][] matrix = new int[16][16];
        boolean iprint = false;
        for (i = 0; i < h_size * s_size * v_size; ++i) {
            matrix[i % h_size][i / h_size] = histogram[i];
        }
        for (i = 0; i < tablae; ++i) {
            if (tabelle[4][i] <= 8) continue;
            int y1 = tabelle[0][i];
            int x1 = tabelle[1][i];
            int y2 = tabelle[2][i];
            int x2 = tabelle[3][i];
            int sum = matrix[y1][x1] + matrix[y2][x2];
            int dif = matrix[y2][x2] - matrix[y1][x1];
            if (iprint) {
                matrix[y1][x1] = sum;
            }
            matrix[y2][x2] = dif;
        }
        for (i = 0; i < h_size * s_size * v_size; ++i) {
            histogram[i] = matrix[i % h_size][i / h_size];
        }
    }

    int[] QuantizeHistogram(int[] aHist, int sumPixels) {
        int factor = 0;
        factor = 2047;
        for (int i = 0; i < this.NumberOfCoefficients; ++i) {
            double binwert = (double)factor * ((double)aHist[i] / (double)sumPixels);
            int ibinwert = (int)(binwert + 0.49999);
            if (ibinwert > factor) {
                ibinwert = factor;
            }
            aHist[i] = ibinwert;
        }
        factor = 15;
        int iwert = 0;
        double potenz = 0.4;
        double maxwert = 818.8;
        for (int i = 0; i < this.NumberOfCoefficients; ++i) {
            double wert = aHist[i];
            if (wert > maxwert) {
                iwert = factor;
            }
            if (wert <= maxwert) {
                double arg = wert / maxwert;
                wert = (double)factor * Math.pow(arg, potenz);
                iwert = (int)(wert + 0.5);
            }
            if (iwert > factor) {
                iwert = factor;
            }
            aHist[i] = iwert;
        }
        return aHist;
    }

    private int[] HaarTransform(int[] aHist) {
        int tablae = 255;
        int RecHistogram = 0;
        int max_color = 256;
        int h_size = 16;
        int s_size = 4;
        int v_size = 4;
        int hist_nr = 256;
        RecHistogram = 0;
        int[] histogram_in = new int[max_color];
        int[] histogram_out = new int[max_color];
        for (int i = 0; i < this.NumberOfCoefficients; ++i) {
            histogram_in[i] = aHist[i];
        }
        if (RecHistogram == 2) {
            ScalableColorImpl.histo_3d_hirarch_16_5(tabelle, tablae, histogram_in, h_size, s_size, v_size, hist_nr);
            ScalableColorImpl.hsv_hir_quant_lin_5(histogram_in);
        }
        if (RecHistogram != 2) {
            ScalableColorImpl.histo_3d_hirarch_5(tabelle, tablae, histogram_in, h_size, s_size, v_size, hist_nr);
            for (int j = 0; j < 256; ++j) {
                int index = sorttab[j];
                histogram_out[j] = histogram_in[index];
            }
            ScalableColorImpl.hsv_hir_quant_lin_5(histogram_out);
            ScalableColorImpl.red_bits_pro_bin_5(histogram_out, this.NumberOfBitplanesDiscarded, 0);
        }
        int[] returnHist = new int[hist_nr];
        System.arraycopy(histogram_out, 0, returnHist, 0, hist_nr);
        return returnHist;
    }

    static void red_bits_pro_bin_5(int[] histogram, int NumberOfBitplanesDiscarded, int ivert) {
        if (NumberOfBitplanesDiscarded == 0) {
            return;
        }
        int bits_pro_bild = 0;
        int max_bits_pro_bin = 0;
        int anzkof = 0;
        if (NumberOfBitplanesDiscarded > 0) {
            for (int i = 0; i < 256; ++i) {
                int wert;
                int bits_pro_bin = scalableColorQuantValues[i][1] - NumberOfBitplanesDiscarded;
                if (bits_pro_bin < 2) {
                    wert = histogram[i];
                    if (wert >= 0) {
                        histogram[i] = 1;
                    }
                    if (wert < 0) {
                        histogram[i] = 0;
                    }
                    ++bits_pro_bild;
                }
                if (bits_pro_bin < 2) continue;
                int wert1 = wert = histogram[i];
                if (wert < 0) {
                    wert = -wert;
                }
                bits_pro_bild += bits_pro_bin;
                if (bits_pro_bin > max_bits_pro_bin) {
                    max_bits_pro_bin = bits_pro_bin;
                }
                ++anzkof;
                for (int j = 0; j < NumberOfBitplanesDiscarded; ++j) {
                    wert >>= 1;
                }
                if (wert1 < 0) {
                    wert = -wert;
                }
                histogram[i] = wert;
            }
        }
    }

    private static void hsv_hir_quant_lin_5(int[] histogram) {
        for (int i = 0; i < 256; ++i) {
            int wert = histogram[i] - scalableColorQuantValues[i][0];
            int maxwert = scalableColorQuantValues[i][2];
            if (wert > maxwert) {
                wert = maxwert;
            }
            if (wert < -maxwert) {
                wert = -maxwert;
            }
            histogram[i] = wert;
        }
    }

    public int getNumberOfCoefficients() {
        return this.NumberOfCoefficients;
    }

    public void setNumberOfCoefficients(int numberOfCoefficients) {
        if (this.img != null) {
            this.NumberOfCoefficients = numberOfCoefficients;
        }
    }

    public int getNumberOfBitplanesDiscarded() {
        return this.NumberOfBitplanesDiscarded;
    }

    public void setNumberOfBitplanesDiscarded(int numberOfBitplanesDiscarded) {
        if (this.img != null) {
            this.NumberOfBitplanesDiscarded = numberOfBitplanesDiscarded;
        }
    }

    public int[] getHaarTransformedHistogram() {
        return this.haarTransformedHistogram;
    }

    public boolean isRecalcable() {
        return this._wholeHist != null;
    }

    public double getDistance(LireFeature descriptor) {
        if (!(descriptor instanceof ScalableColorImpl)) {
            return -1.0;
        }
        ScalableColorImpl sc = (ScalableColorImpl)((Object)descriptor);
        return sc.getSimilarity(this);
    }
}

