/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.global.spatialpyramid;

import java.awt.image.BufferedImage;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.imageanalysis.features.global.AutoColorCorrelogram;
import net.semanticmetadata.lire.utils.MetricsUtils;

public class SPACC
implements GlobalFeature {
    private int histLength = 256;
    int histogramSize = this.histLength * 5 + this.histLength * 4 * 4;
    double[] histogram = new double[this.histogramSize];
    int tmp;

    @Override
    public void extract(BufferedImage bimg) {
        AutoColorCorrelogram acc = new AutoColorCorrelogram();
        acc.extract(bimg);
        System.arraycopy(acc.getFeatureVector(), 0, this.histogram, 0, this.histLength);
        int w = bimg.getWidth() / 2;
        int h = bimg.getHeight() / 2;
        acc.extract(bimg.getSubimage(0, 0, w, h));
        System.arraycopy(acc.getFeatureVector(), 0, this.histogram, this.histLength * 1, this.histLength);
        acc.extract(bimg.getSubimage(w, 0, w, h));
        System.arraycopy(acc.getFeatureVector(), 0, this.histogram, this.histLength * 2, this.histLength);
        acc.extract(bimg.getSubimage(0, h, w, h));
        System.arraycopy(acc.getFeatureVector(), 0, this.histogram, this.histLength * 3, this.histLength);
        acc.extract(bimg.getSubimage(w, h, w, h));
        System.arraycopy(acc.getFeatureVector(), 0, this.histogram, this.histLength * 4, this.histLength);
        int wstep = bimg.getWidth() / 4;
        int hstep = bimg.getHeight() / 4;
        int binPos = 5;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                acc.extract(bimg.getSubimage(i * wstep, j * hstep, wstep, hstep));
                System.arraycopy(acc.getFeatureVector(), 0, this.histogram, this.histLength * binPos, this.histLength);
                ++binPos;
            }
        }
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        byte[] result = new byte[this.histogramSize / 2];
        for (int i = 0; i < result.length; ++i) {
            this.tmp = (int)this.histogram[i << 1] << 4;
            this.tmp |= (int)this.histogram[(i << 1) + 1];
            result[i] = (byte)(this.tmp - 128);
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.setByteArrayRepresentation(in, 0, in.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.tmp = in[i] + 128;
            this.histogram[(i - offset << 1) + 1] = this.tmp & 0xF;
            this.histogram[i - offset << 1] = this.tmp >> 4;
        }
    }

    @Override
    public double[] getFeatureVector() {
        return this.histogram;
    }

    @Override
    public double getDistance(LireFeature feature) {
        if (!(feature instanceof SPACC)) {
            return -1.0;
        }
        return MetricsUtils.tanimoto(this.histogram, feature.getFeatureVector());
    }

    @Override
    public String getFeatureName() {
        return "Auto Color Correlogram Spatial Pyramid";
    }

    @Override
    public String getFieldName() {
        return "f_spacc";
    }
}

