/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.global.spatialpyramid;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.imageanalysis.features.global.JCD;
import net.semanticmetadata.lire.utils.MetricsUtils;

public class SPJCD
implements GlobalFeature {
    private int histLength = 168;
    int histogramSize = this.histLength * 5 + this.histLength * 4 * 4;
    double[] histogram = new double[this.histogramSize];
    int tmp;

    @Override
    public void extract(BufferedImage bimg) {
        JCD jcd = new JCD();
        jcd.extract(bimg);
        System.arraycopy(jcd.getFeatureVector(), 0, this.histogram, 0, this.histLength);
        int w = bimg.getWidth() / 2;
        int h = bimg.getHeight() / 2;
        jcd.extract(bimg.getSubimage(0, 0, w, h));
        System.arraycopy(jcd.getFeatureVector(), 0, this.histogram, this.histLength * 1, this.histLength);
        jcd.extract(bimg.getSubimage(w, 0, w, h));
        System.arraycopy(jcd.getFeatureVector(), 0, this.histogram, this.histLength * 2, this.histLength);
        jcd.extract(bimg.getSubimage(0, h, w, h));
        System.arraycopy(jcd.getFeatureVector(), 0, this.histogram, this.histLength * 3, this.histLength);
        jcd.extract(bimg.getSubimage(w, h, w, h));
        System.arraycopy(jcd.getFeatureVector(), 0, this.histogram, this.histLength * 4, this.histLength);
        int wstep = bimg.getWidth() / 4;
        int hstep = bimg.getHeight() / 4;
        int binPos = 5;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                jcd.extract(bimg.getSubimage(i * wstep, j * hstep, wstep, hstep));
                System.arraycopy(jcd.getFeatureVector(), 0, this.histogram, this.histLength * binPos, this.histLength);
                ++binPos;
            }
        }
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        int position = -1;
        for (int i = 0; i < this.histogram.length; ++i) {
            if (position == -1) {
                if (this.histogram[i] != 0.0) continue;
                position = i;
                continue;
            }
            if (position <= -1 || this.histogram[i] == 0.0) continue;
            position = -1;
        }
        if (position < 0) {
            position = 143;
        }
        int length = (position + 1) / 2;
        if ((position + 1) % 2 == 1) {
            length = position / 2 + 1;
        }
        byte[] result = new byte[length];
        for (int i = 0; i < result.length; ++i) {
            this.tmp = (int)(this.histogram[i << 1] * 2.0) << 4;
            this.tmp |= (int)(this.histogram[(i << 1) + 1] * 2.0);
            result[i] = (byte)(this.tmp - 128);
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        if (in.length << 1 < this.histogram.length) {
            Arrays.fill(this.histogram, in.length << 1, this.histogram.length - 1, 0.0);
        }
        for (int i = 0; i < in.length; ++i) {
            this.tmp = in[i] + 128;
            this.histogram[(i << 1) + 1] = (double)(this.tmp & 0xF) / 2.0;
            this.histogram[i << 1] = (double)(this.tmp >> 4) / 2.0;
        }
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        if (length << 1 < this.histogram.length) {
            Arrays.fill(this.histogram, length << 1, this.histogram.length - 1, 0.0);
        }
        for (int i = offset; i < offset + length; ++i) {
            this.tmp = in[i] + 128;
            this.histogram[(i - offset << 1) + 1] = (double)(this.tmp & 0xF) / 2.0;
            this.histogram[i - offset << 1] = (double)(this.tmp >> 4) / 2.0;
        }
    }

    @Override
    public double[] getFeatureVector() {
        return this.histogram;
    }

    @Override
    public double getDistance(LireFeature feature) {
        if (!(feature instanceof SPJCD)) {
            return -1.0;
        }
        return MetricsUtils.tanimoto(this.histogram, feature.getFeatureVector());
    }

    @Override
    public String getFeatureName() {
        return "JCD Spatial Pyramid";
    }

    @Override
    public String getFieldName() {
        return "f_spjcd";
    }
}

