/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.global.spatialpyramid;

import java.awt.image.BufferedImage;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.imageanalysis.features.global.RotationInvariantLocalBinaryPatterns;
import net.semanticmetadata.lire.utils.MetricsUtils;

public class SPLBP
implements GlobalFeature {
    int histogramSize = 756;
    double[] histogram = new double[this.histogramSize];
    int tmp;

    @Override
    public void extract(BufferedImage bimg) {
        RotationInvariantLocalBinaryPatterns feature = new RotationInvariantLocalBinaryPatterns();
        feature.extract(bimg);
        System.arraycopy(feature.getFeatureVector(), 0, this.histogram, 0, 36);
        int w = bimg.getWidth() / 2;
        int h = bimg.getHeight() / 2;
        feature.extract(bimg.getSubimage(0, 0, w, h));
        System.arraycopy(feature.getFeatureVector(), 0, this.histogram, 36, 36);
        feature.extract(bimg.getSubimage(w, 0, w, h));
        System.arraycopy(feature.getFeatureVector(), 0, this.histogram, 72, 36);
        feature.extract(bimg.getSubimage(0, h, w, h));
        System.arraycopy(feature.getFeatureVector(), 0, this.histogram, 108, 36);
        feature.extract(bimg.getSubimage(w, h, w, h));
        System.arraycopy(feature.getFeatureVector(), 0, this.histogram, 144, 36);
        int wstep = bimg.getWidth() / 4;
        int hstep = bimg.getHeight() / 4;
        int binPos = 5;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                feature.extract(bimg.getSubimage(i * wstep, j * hstep, wstep, hstep));
                System.arraycopy(feature.getFeatureVector(), 0, this.histogram, 36 * binPos, 36);
                ++binPos;
            }
        }
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        byte[] result = new byte[this.histogram.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)this.histogram[i];
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.setByteArrayRepresentation(in, 0, in.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.tmp = in[i] + 128;
            this.histogram[i - offset] = in[i];
        }
    }

    @Override
    public double[] getFeatureVector() {
        return this.histogram;
    }

    @Override
    public double getDistance(LireFeature feature) {
        if (!(feature instanceof SPLBP)) {
            return -1.0;
        }
        return MetricsUtils.distL1(this.histogram, feature.getFeatureVector());
    }

    @Override
    public String getFeatureName() {
        return "Spatial Pyramid of Local Binary Patterns (simple)";
    }

    @Override
    public String getFieldName() {
        return "f_splbp";
    }
}

