/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.opencvfeatures;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeatureExtractor;
import net.semanticmetadata.lire.imageanalysis.features.local.opencvfeatures.CvSiftFeature;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfKeyPoint;
import org.opencv.features2d.DescriptorExtractor;
import org.opencv.features2d.FeatureDetector;
import org.opencv.features2d.KeyPoint;
import org.opencv.imgproc.Imgproc;

public class CvSiftExtractor
implements LocalFeatureExtractor {
    private int nfeatures = 0;
    private int nOctaveLayers = 3;
    private double contrastThreshold = 0.04;
    private double edgeThreshold = 10.0;
    private double sigma = 1.6;
    LinkedList<CvSiftFeature> features = null;
    FeatureDetector detector;
    DescriptorExtractor extractor;

    public CvSiftExtractor() {
        this.init();
    }

    public CvSiftExtractor(int features, int OctaveLayers, double contrastThres, double edgeThres, double sgm) {
        this.nfeatures = features;
        this.nOctaveLayers = OctaveLayers;
        this.contrastThreshold = contrastThres;
        this.edgeThreshold = edgeThres;
        this.sigma = sgm;
        this.init();
    }

    private void init() {
        System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
        this.detector = FeatureDetector.create((int)3);
        this.extractor = DescriptorExtractor.create((int)1);
        try {
            File temp = File.createTempFile("tempFile", ".tmp");
            String settings = "%YAML:1.0\nnfeatures: " + this.nfeatures + "\nnOctaveLayers: " + this.nOctaveLayers + "\ncontrastThreshold: " + this.contrastThreshold + "\nedgeThreshold: " + this.edgeThreshold + "\nsigma: " + this.sigma;
            FileWriter writer = new FileWriter(temp, false);
            writer.write(settings);
            writer.close();
            this.extractor.read(temp.getPath());
            this.detector.read(temp.getPath());
            temp.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public LinkedList<CvSiftFeature> getFeatures() {
        return this.features;
    }

    @Override
    public Class<? extends LocalFeature> getClassOfFeatures() {
        return CvSiftFeature.class;
    }

    @Override
    public void extract(BufferedImage img) {
        MatOfKeyPoint keypoints = new MatOfKeyPoint();
        Mat descriptors = new Mat();
        byte[] data = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        Mat matRGB = new Mat(img.getHeight(), img.getWidth(), CvType.CV_8UC3);
        matRGB.put(0, 0, data);
        Mat matGray = new Mat(img.getHeight(), img.getWidth(), CvType.CV_8UC1);
        Imgproc.cvtColor((Mat)matRGB, (Mat)matGray, (int)6);
        byte[] dataGray = new byte[matGray.rows() * matGray.cols() * (int)matGray.elemSize()];
        matGray.get(0, 0, dataGray);
        this.detector.detect(matGray, keypoints);
        this.extractor.compute(matGray, keypoints, descriptors);
        List myKeys = keypoints.toList();
        this.features = new LinkedList();
        int rows = myKeys.size();
        for (int i = 0; i < rows; ++i) {
            int cols = descriptors.row(i).cols();
            double[] desc = new double[cols];
            KeyPoint key = (KeyPoint)myKeys.get(i);
            for (int j = 0; j < cols; ++j) {
                desc[j] = descriptors.get(i, j)[0];
            }
            CvSiftFeature feat = new CvSiftFeature(key.pt.x, key.pt.y, key.size, desc);
            this.features.add(feat);
        }
    }

    public LinkedList<CvSiftFeature> computeSiftKeypoints(BufferedImage img) {
        MatOfKeyPoint keypoints = new MatOfKeyPoint();
        byte[] data = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        Mat matRGB = new Mat(img.getHeight(), img.getWidth(), CvType.CV_8UC3);
        matRGB.put(0, 0, data);
        Mat matGray = new Mat(img.getHeight(), img.getWidth(), CvType.CV_8UC1);
        Imgproc.cvtColor((Mat)matRGB, (Mat)matGray, (int)6);
        byte[] dataGray = new byte[matGray.rows() * matGray.cols() * (int)matGray.elemSize()];
        matGray.get(0, 0, dataGray);
        this.detector.detect(matGray, keypoints);
        List myKeys = keypoints.toList();
        LinkedList<CvSiftFeature> myKeypoints = new LinkedList<CvSiftFeature>();
        for (KeyPoint key : myKeys) {
            CvSiftFeature feat = new CvSiftFeature(key.pt.x, key.pt.y, key.size, null);
            myKeypoints.add(feat);
        }
        return myKeypoints;
    }

    public String getParameters() {
        return "nfeatures: " + this.nfeatures + " nOctaveLayers: " + this.nOctaveLayers + " contrastThreshold: " + this.contrastThreshold + " edgeThreshold: " + this.edgeThreshold + " sigma: " + this.sigma;
    }
}

