/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.opencvfeatures;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeatureExtractor;
import net.semanticmetadata.lire.imageanalysis.features.local.opencvfeatures.CvSurfFeature;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfKeyPoint;
import org.opencv.features2d.DescriptorExtractor;
import org.opencv.features2d.FeatureDetector;
import org.opencv.features2d.KeyPoint;
import org.opencv.imgproc.Imgproc;

public class CvSurfExtractor
implements LocalFeatureExtractor {
    private double hessianThreshold = 500.0;
    private int nOctaves = 4;
    private int nOctaveLayers = 2;
    private int extended = 1;
    private int upright = 0;
    LinkedList<CvSurfFeature> features;
    FeatureDetector detector;
    DescriptorExtractor extractor;

    public CvSurfExtractor() {
        this.init();
    }

    public CvSurfExtractor(double hessianThreshold, int nOctaves, int nOctaveLayers, int extended, int upright) {
        this.hessianThreshold = hessianThreshold;
        this.nOctaves = nOctaves;
        this.nOctaveLayers = nOctaveLayers;
        this.extended = extended;
        this.upright = upright;
        this.init();
    }

    private void init() {
        System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
        this.detector = FeatureDetector.create((int)4);
        this.extractor = DescriptorExtractor.create((int)2);
        try {
            File temp = File.createTempFile("tempFile", ".tmp");
            String settings = "%YAML:1.0\nhessianThreshold: " + this.hessianThreshold + "\nnOctaves: " + this.nOctaves + "\nnOctaveLayers: " + this.nOctaveLayers + "\nextended: " + this.extended + "\nupright: " + this.upright;
            FileWriter writer = new FileWriter(temp, false);
            writer.write(settings);
            writer.close();
            this.extractor.read(temp.getPath());
            this.detector.read(temp.getPath());
            temp.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public LinkedList<CvSurfFeature> getFeatures() {
        return this.features;
    }

    @Override
    public Class<? extends LocalFeature> getClassOfFeatures() {
        return CvSurfFeature.class;
    }

    @Override
    public void extract(BufferedImage img) {
        MatOfKeyPoint keypoints = new MatOfKeyPoint();
        Mat descriptors = new Mat();
        byte[] data = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        Mat matRGB = new Mat(img.getHeight(), img.getWidth(), CvType.CV_8UC3);
        matRGB.put(0, 0, data);
        Mat matGray = new Mat(img.getHeight(), img.getWidth(), CvType.CV_8UC1);
        Imgproc.cvtColor((Mat)matRGB, (Mat)matGray, (int)6);
        byte[] dataGray = new byte[matGray.rows() * matGray.cols() * (int)matGray.elemSize()];
        matGray.get(0, 0, dataGray);
        this.detector.detect(matGray, keypoints);
        this.extractor.compute(matGray, keypoints, descriptors);
        List myKeys = keypoints.toList();
        this.features = new LinkedList();
        int rows = myKeys.size();
        for (int i = 0; i < rows; ++i) {
            int cols = descriptors.row(i).cols();
            double[] desc = new double[cols];
            KeyPoint key = (KeyPoint)myKeys.get(i);
            for (int j = 0; j < cols; ++j) {
                desc[j] = descriptors.get(i, j)[0];
            }
            CvSurfFeature feat = new CvSurfFeature(key.pt.x, key.pt.y, key.size, desc);
            this.features.add(feat);
        }
    }

    public LinkedList<CvSurfFeature> computeSurfKeypoints(BufferedImage img) {
        MatOfKeyPoint keypoints = new MatOfKeyPoint();
        byte[] data = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        Mat matRGB = new Mat(img.getHeight(), img.getWidth(), CvType.CV_8UC3);
        matRGB.put(0, 0, data);
        Mat matGray = new Mat(img.getHeight(), img.getWidth(), CvType.CV_8UC1);
        Imgproc.cvtColor((Mat)matRGB, (Mat)matGray, (int)6);
        byte[] dataGray = new byte[matGray.rows() * matGray.cols() * (int)matGray.elemSize()];
        matGray.get(0, 0, dataGray);
        this.detector.detect(matGray, keypoints);
        List myKeys = keypoints.toList();
        LinkedList<CvSurfFeature> myKeypoints = new LinkedList<CvSurfFeature>();
        for (KeyPoint key : myKeys) {
            CvSurfFeature feat = new CvSurfFeature(key.pt.x, key.pt.y, key.size, null);
            myKeypoints.add(feat);
        }
        return myKeypoints;
    }

    public String getParameters() {
        return "hessianThreshold: " + this.hessianThreshold + " nOctaves: " + this.nOctaves + " nOctaveLayers: " + this.nOctaveLayers + " extended: " + this.extended + " upright: " + this.upright;
    }
}

