/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.opencvfeatures;

import java.io.Serializable;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeatureExtractor;
import net.semanticmetadata.lire.imageanalysis.features.local.opencvfeatures.CvSurfExtractor;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class CvSurfFeature
implements Serializable,
LocalFeature {
    private double X = -1.0;
    private double Y = -1.0;
    private double size = -1.0;
    private double[] feature = null;

    public CvSurfFeature() {
    }

    public CvSurfFeature(double X, double Y, double size, double[] feature) {
        this.X = X;
        this.Y = Y;
        this.size = size;
        this.feature = feature;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.feature.length; ++i) {
            sb.append(this.feature[i]);
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    public double getDistance(LireFeature f) {
        if (!(f instanceof CvSurfFeature)) {
            return -1.0;
        }
        return MetricsUtils.distL2(this.feature, ((CvSurfFeature)f).feature);
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        return SerializationUtils.toByteArray(this.feature);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.feature = SerializationUtils.toDoubleArray(in);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        this.feature = SerializationUtils.toDoubleArray(in, offset, length);
    }

    @Override
    public double[] getFeatureVector() {
        return this.feature;
    }

    @Override
    public String getFeatureName() {
        return "cvSURF";
    }

    @Override
    public String getFieldName() {
        return "CvSURF";
    }

    @Override
    public double getX() {
        return this.X;
    }

    @Override
    public double getY() {
        return this.Y;
    }

    @Override
    public double getSize() {
        return this.size;
    }

    public Class<? extends LocalFeatureExtractor> getClassOfExtractor() {
        return CvSurfExtractor.class;
    }
}

