/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.selfsimilarities;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeatureExtractor;
import net.semanticmetadata.lire.imageanalysis.features.local.selfsimilarities.SelfSimilaritiesFeature;

public class SelfSimilaritiesExtractor
implements LocalFeatureExtractor {
    private int patch_size = 5;
    private int desc_rad = 40;
    private int cor_size = this.desc_rad * 2 + this.patch_size;
    private int nrad = 3;
    private int nang = 12;
    private int var_noise = 300000;
    private double saliency_thresh = 0.7;
    private double homogeneity_thresh = 0.7;
    private double snn_thresh = 0.85;
    private double[] ssdescs;
    double ssd_min_bound1;
    double ssd_min_bound2;
    LinkedList<SelfSimilaritiesFeature> features = null;

    @Override
    public void extract(BufferedImage img) {
        int image_width = img.getWidth();
        int image_height = img.getHeight();
        int image_channels = img.getColorModel().getNumColorComponents();
        int[][] ImageGridRed = new int[image_width][image_height];
        int[][] ImageGridGreen = new int[image_width][image_height];
        int[][] ImageGridBlue = new int[image_width][image_height];
        for (int x = 0; x < image_width; ++x) {
            for (int y = 0; y < image_height; ++y) {
                int pixel = img.getRGB(x, y);
                ImageGridRed[x][y] = pixel >> 16 & 0xFF;
                ImageGridGreen[x][y] = pixel >> 8 & 0xFF;
                ImageGridBlue[x][y] = pixel & 0xFF;
            }
        }
        int xfrom = 0;
        int xto = image_width - this.cor_size + 1;
        int yfrom = 0;
        int yto = image_height - this.cor_size + 1;
        int ssd_sz = this.cor_size - this.patch_size + 1;
        int dim = this.nrad * this.nang;
        int ssd_sz_pow = ssd_sz * ssd_sz;
        this.ssdescs = new double[yto * xto * dim];
        int[] imask = this.createImask(ssd_sz);
        int corPatchRad = this.cor_size / 2 - this.patch_size / 2;
        for (int y = yfrom; y < yto; ++y) {
            int[] ssd = this.ssd_compute(ImageGridRed, ImageGridGreen, ImageGridBlue, xfrom, xfrom + ssd_sz, y, y + ssd_sz, xfrom + corPatchRad, y + corPatchRad, ssd_sz, this.patch_size);
            this.ssdesc_descriptor(ssd, imask, ssd_sz_pow, this.var_noise, (y * xto + xfrom) * dim);
            for (int x = xfrom + 1; x < xto; ++x) {
                this.ssd_compute_irow(ImageGridRed, ImageGridGreen, ImageGridBlue, x, x + ssd_sz, y, y + ssd_sz, x + corPatchRad, y + corPatchRad, this.patch_size, ssd);
                this.ssdesc_descriptor(ssd, imask, ssd_sz_pow, this.var_noise, (y * xto + x) * dim);
            }
        }
        this.prune_normalise_ssdescs(xfrom, xto, yfrom, yto, dim);
    }

    private int[] createImask(int ssd_sz) {
        int[] imask = new int[ssd_sz * ssd_sz];
        int center = (ssd_sz - 1) / 2;
        double lpbase = Math.pow(10.0, Math.log10(this.nrad) / (double)this.nrad);
        double[] radiiQuants = new double[this.nrad];
        for (int i = 0; i < this.nrad - 1; ++i) {
            radiiQuants[i] = (Math.pow(lpbase, i + 1) - 1.0) / (double)(this.nrad - 1) * (double)center;
        }
        radiiQuants[this.nrad - 1] = this.desc_rad;
        for (int x = 0; x < ssd_sz; ++x) {
            int xCord = center - x;
            for (int y = 0; y < ssd_sz; ++y) {
                int rind;
                int yCord = center - y;
                double r = Math.sqrt(xCord * xCord + yCord * yCord);
                double ang = Math.atan2(xCord, yCord) + Math.PI;
                if (r > radiiQuants[this.nrad - 1]) {
                    imask[y * ssd_sz + x] = -1;
                    continue;
                }
                for (rind = 0; rind < this.nrad && !(r <= radiiQuants[rind]); ++rind) {
                }
                rind = this.nrad - 1 - rind;
                imask[y * ssd_sz + x] = (int)(ang * (double)this.nang / (Math.PI * 2)) % this.nang * this.nrad + rind;
            }
        }
        imask[center * ssd_sz + center] = -1;
        return imask;
    }

    private int[] ssd_compute(int[][] ImageGridRed, int[][] ImageGridGreen, int[][] ImageGridBlue, int xl, int xr, int yl, int yr, int xp, int yp, int ssd_sz, int sz) {
        int[] ssd = new int[ssd_sz * ssd_sz];
        int counter = 0;
        for (int yy = yl; yy < yr; ++yy) {
            for (int xx = xl; xx < xr; ++xx) {
                ssd[counter] = 0;
                for (int xc = 0; xc < sz; ++xc) {
                    int x1 = xx + xc;
                    int x2 = xp + xc;
                    for (int yc = 0; yc < sz; ++yc) {
                        int y1 = yy + yc;
                        int y2 = yp + yc;
                        double diff = ImageGridRed[x1][y1] - ImageGridRed[x2][y2];
                        int n = counter;
                        ssd[n] = (int)((double)ssd[n] + diff * diff);
                        diff = ImageGridGreen[x1][y1] - ImageGridGreen[x2][y2];
                        int n2 = counter;
                        ssd[n2] = (int)((double)ssd[n2] + diff * diff);
                        diff = ImageGridBlue[x1][y1] - ImageGridBlue[x2][y2];
                        int n3 = counter;
                        ssd[n3] = (int)((double)ssd[n3] + diff * diff);
                    }
                }
                ++counter;
            }
        }
        return ssd;
    }

    private void ssdesc_descriptor(int[] ssd, int[] imask, int ssd_sz_to, int var_noise, int offset) {
        double autoQ = 0.0;
        double divisor = autoQ > (double)var_noise ? autoQ : (double)var_noise;
        for (int i = 0; i < ssd_sz_to; ++i) {
            if (imask[i] == -1) continue;
            int ptr = imask[i] + offset;
            double val = Math.exp(-1.0 * (double)ssd[i] / divisor);
            this.ssdescs[ptr] = this.ssdescs[ptr] > val ? this.ssdescs[ptr] : val;
        }
    }

    private void ssd_compute_irow(int[][] ImageGridRed, int[][] ImageGridGreen, int[][] ImageGridBlue, int xl, int xr, int yl, int yr, int xp, int yp, int sz, int[] ssd) {
        int counter = 0;
        int x2 = xp - 1;
        int x4 = xp + sz - 1;
        for (int yy = yl; yy < yr; ++yy) {
            for (int xx = xl; xx < xr; ++xx) {
                int x1 = xx - 1;
                int x3 = xx + sz - 1;
                for (int yc = 0; yc < sz; ++yc) {
                    int y1 = yy + yc;
                    int y2 = yp + yc;
                    int diff = ImageGridRed[x1][y1] - ImageGridRed[x2][y2];
                    int n = counter;
                    ssd[n] = ssd[n] - diff * diff;
                    diff = ImageGridRed[x3][y1] - ImageGridRed[x4][y2];
                    int n2 = counter;
                    ssd[n2] = ssd[n2] + diff * diff;
                    diff = ImageGridGreen[x1][y1] - ImageGridGreen[x2][y2];
                    int n3 = counter;
                    ssd[n3] = ssd[n3] - diff * diff;
                    diff = ImageGridGreen[x3][y1] - ImageGridGreen[x4][y2];
                    int n4 = counter;
                    ssd[n4] = ssd[n4] + diff * diff;
                    diff = ImageGridBlue[x1][y1] - ImageGridBlue[x2][y2];
                    int n5 = counter;
                    ssd[n5] = ssd[n5] - diff * diff;
                    diff = ImageGridBlue[x3][y1] - ImageGridBlue[x4][y2];
                    int n6 = counter;
                    ssd[n6] = ssd[n6] + diff * diff;
                }
                ++counter;
            }
        }
    }

    private double calc_ssd_ssdesc_min2(int ssdesc1Ptr, int ssdesc2Ptr, int ssdesc_size, double boundMultiplier) {
        double bm = boundMultiplier == -1.0 ? Math.sqrt(ssdesc_size) : boundMultiplier;
        double one_norm = 0.0;
        for (int i = 0; i < ssdesc_size; ++i) {
            one_norm += Math.abs(this.ssdescs[ssdesc1Ptr + i] - this.ssdescs[ssdesc2Ptr + i]);
        }
        if (one_norm <= this.ssd_min_bound2) {
            double two_norm = 0.0;
            for (int i = 0; i < ssdesc_size; ++i) {
                double diff = this.ssdescs[ssdesc1Ptr + i] - this.ssdescs[ssdesc2Ptr + i];
                two_norm += diff * diff;
            }
            double two_norm_bound = (two_norm = Math.sqrt(two_norm)) * bm;
            if (two_norm_bound < this.ssd_min_bound2 && two_norm_bound >= this.ssd_min_bound1) {
                this.ssd_min_bound2 = two_norm_bound;
            }
            if (two_norm_bound < this.ssd_min_bound1) {
                this.ssd_min_bound2 = this.ssd_min_bound1;
                this.ssd_min_bound1 = two_norm_bound;
            }
            return two_norm;
        }
        return -1.0;
    }

    private void prune_normalise_ssdescs(int xfrom, int xto, int yfrom, int yto, int dim) {
        double max_ssd;
        double min_ssd;
        LinkedList<int[]> draw_coords = new LinkedList<int[]>();
        double boundMultiplier = Math.sqrt(dim);
        int ssdesc1Ptr = -dim;
        int corRad = (this.cor_size - 1) / 2;
        LinkedList<Double> desc_sims = new LinkedList<Double>();
        for (int y = yfrom; y < yto; ++y) {
            for (int x = xfrom; x < xto; ++x) {
                max_ssd = min_ssd = this.ssdescs[ssdesc1Ptr += dim];
                double diff = max_ssd - min_ssd;
                for (int i = 1; i < dim; ++i) {
                    min_ssd = this.ssdescs[ssdesc1Ptr + i] < min_ssd ? this.ssdescs[ssdesc1Ptr + i] : min_ssd;
                    max_ssd = this.ssdescs[ssdesc1Ptr + i] > max_ssd ? this.ssdescs[ssdesc1Ptr + i] : max_ssd;
                }
                if (max_ssd < 1.0 - this.saliency_thresh || min_ssd > this.homogeneity_thresh) continue;
                if (this.snn_thresh < 1.0) {
                    desc_sims.clear();
                    this.ssd_min_bound2 = this.ssd_min_bound1 = Double.MAX_VALUE;
                    int ssdesc2Ptr = -dim;
                    for (int y2 = 0; y2 < yto; ++y2) {
                        for (int x2 = 0; x2 < xto; ++x2) {
                            double ssd;
                            if (ssdesc1Ptr == (ssdesc2Ptr += dim) || (ssd = this.calc_ssd_ssdesc_min2(ssdesc1Ptr, ssdesc2Ptr, dim, boundMultiplier)) == -1.0) continue;
                            desc_sims.add(ssd);
                        }
                    }
                    Collections.sort(desc_sims);
                    if ((Double)desc_sims.get(0) / (Double)desc_sims.get(1) > this.snn_thresh) continue;
                    draw_coords.add(new int[]{x + corRad, y + corRad});
                    continue;
                }
                draw_coords.add(new int[]{x + corRad, y + corRad});
            }
        }
        this.features = new LinkedList();
        for (int i = 0; i < draw_coords.size(); ++i) {
            int[] coords = (int[])draw_coords.get(i);
            ssdesc1Ptr = ((coords[1] - corRad) * xto + (coords[0] - corRad)) * dim;
            max_ssd = min_ssd = this.ssdescs[ssdesc1Ptr];
            for (int ii = 1; ii < dim; ++ii) {
                min_ssd = this.ssdescs[ssdesc1Ptr + ii] < min_ssd ? this.ssdescs[ssdesc1Ptr + ii] : min_ssd;
                max_ssd = this.ssdescs[ssdesc1Ptr + ii] > max_ssd ? this.ssdescs[ssdesc1Ptr + ii] : max_ssd;
            }
            double[] resp = new double[dim];
            for (int binOffset = 0; binOffset < dim; ++binOffset) {
                resp[binOffset] = (this.ssdescs[ssdesc1Ptr + binOffset] - min_ssd) / (max_ssd - min_ssd);
            }
            SelfSimilaritiesFeature feat = new SelfSimilaritiesFeature(resp, coords[0], coords[1], this.cor_size);
            this.features.add(feat);
        }
    }

    @Override
    public List<? extends LocalFeature> getFeatures() {
        return this.features;
    }

    @Override
    public Class<? extends LocalFeature> getClassOfFeatures() {
        return SelfSimilaritiesFeature.class;
    }
}

