/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.selfsimilarities;

import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.imageanalysis.features.local.selfsimilarities.SelfSimilaritiesExtractor;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class SelfSimilaritiesFeature
implements LocalFeature {
    private double X = -1.0;
    private double Y = -1.0;
    private double size = -1.0;
    private double[] feature = null;

    public SelfSimilaritiesFeature() {
    }

    public SelfSimilaritiesFeature(double[] feature, double X, double Y, double size) {
        this.feature = feature;
        this.X = X;
        this.Y = Y;
        this.size = size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.feature.length; ++i) {
            sb.append(this.feature[i]);
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    public double getDistance(LireFeature f) {
        if (!(f instanceof SelfSimilaritiesFeature)) {
            return -1.0;
        }
        return MetricsUtils.distL2(this.feature, ((SelfSimilaritiesFeature)f).feature);
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        return SerializationUtils.toByteArray(this.feature);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.feature = SerializationUtils.toDoubleArray(in);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        this.feature = SerializationUtils.toDoubleArray(in, offset, length);
    }

    @Override
    public String getFeatureName() {
        return "selfSimilarities";
    }

    @Override
    public String getFieldName() {
        return "SelfSimilarities";
    }

    @Override
    public double getX() {
        return this.X;
    }

    @Override
    public double getY() {
        return this.Y;
    }

    @Override
    public double getSize() {
        return this.size;
    }

    @Override
    public Class<?> getClassOfExtractor() {
        return SelfSimilaritiesExtractor.class;
    }

    @Override
    public double[] getFeatureVector() {
        return this.feature;
    }
}

