/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.selfsimilarities;

import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeatureExtractor;
import net.semanticmetadata.lire.imageanalysis.features.local.selfsimilarities.SelfSimilaritiesOrigFeature;

public class SelfSimilaritiesOrigExtractor
implements LocalFeatureExtractor {
    private int density = 5;
    private int size = 5;
    private int coRelWindowRadius = 10;
    private int numRadiiIntervals = 2;
    private int numThetaIntervals = 4;
    private int varNoise = 2700;
    private int autoVarRadius = 1;
    private int saliencyThresh = 0;
    LinkedList<SelfSimilaritiesOrigFeature> features = null;

    @Override
    public void extract(BufferedImage img) {
        int nChannels = img.getColorModel().getNumColorComponents();
        int radius = (this.size - 1) / 2;
        int marg = radius + this.coRelWindowRadius;
        int NUMradius = (this.size - 1) / 2;
        int NUMpixels = this.size * this.size;
        int NUMcols = img.getWidth();
        int NUMrows = img.getHeight();
        int[][] ImageGridRed = new int[NUMcols][NUMrows];
        int[][] ImageGridGreen = new int[NUMcols][NUMrows];
        int[][] ImageGridBlue = new int[NUMcols][NUMrows];
        for (int x = 0; x < NUMcols; ++x) {
            for (int y = 0; y < NUMrows; ++y) {
                int pixel = img.getRGB(x, y);
                ImageGridRed[x][y] = pixel >> 16 & 0xFF;
                ImageGridGreen[x][y] = pixel >> 8 & 0xFF;
                ImageGridBlue[x][y] = pixel & 0xFF;
            }
        }
        if (this.autoVarRadius > this.coRelWindowRadius) {
            System.out.println("Incorrect data, autoVarRadius cant be greater than coRelWindowRadius");
            return;
        }
        int interiorH = NUMrows - 2 * NUMradius;
        int numPixels = (2 * NUMradius + 1) * (2 * NUMradius + 1);
        int dim = this.coRelWindowRadius * 2 + 1;
        int[] xGrid = new int[dim * dim];
        int[] yGrid = new int[dim * dim];
        int tempCoRelWindowRadiusX = this.coRelWindowRadius;
        int counter = 0;
        for (int i = 0; i < dim; ++i) {
            int tempCoRelWindowRadiusY = this.coRelWindowRadius;
            for (int j = 0; j < dim; ++j) {
                xGrid[counter] = -1 * tempCoRelWindowRadiusX;
                yGrid[counter] = tempCoRelWindowRadiusY--;
                ++counter;
            }
            --tempCoRelWindowRadiusX;
        }
        dim *= dim;
        int[] circleMask = new int[dim];
        int[] autoVarMask = new int[dim];
        for (int i = 0; i < dim; ++i) {
            circleMask[i] = xGrid[i] * xGrid[i] + yGrid[i] * yGrid[i] <= this.coRelWindowRadius * this.coRelWindowRadius ? 1 : 0;
            autoVarMask[i] = xGrid[i] * xGrid[i] + yGrid[i] * yGrid[i] <= this.autoVarRadius * this.autoVarRadius ? 1 : 0;
        }
        circleMask[(dim - 1) / 2] = 0;
        autoVarMask[(dim - 1) / 2] = 0;
        int[] radii = new int[dim];
        double[] thetas = new double[dim];
        for (int i = 0; i < dim; ++i) {
            circleMask[i] = circleMask[i] + autoVarMask[i];
            radii[i] = xGrid[i] * xGrid[i] + yGrid[i] * yGrid[i];
            thetas[i] = 0.0;
        }
        block12: for (int x = 0; x < dim; ++x) {
            int xC = xGrid[x];
            int yC = yGrid[x];
            int xQuad = xC >= 0 ? 1 : 0;
            int yQuad = yC >= 0 ? 1 : 0;
            int quad = xQuad * 2 + yQuad;
            switch (quad) {
                case 0: {
                    if (xC == 0) {
                        thetas[x] = Math.PI;
                        continue block12;
                    }
                    thetas[x] = 4.71238898038469 - Math.atan((double)yC / (double)xC);
                    continue block12;
                }
                case 1: {
                    if (xC == 0) {
                        thetas[x] = 0.0;
                        continue block12;
                    }
                    thetas[x] = 4.71238898038469 - Math.atan((double)yC / (double)xC);
                    continue block12;
                }
                case 2: {
                    if (xC == 0) {
                        thetas[x] = Math.PI;
                        continue block12;
                    }
                    thetas[x] = 1.5707963267948966 - Math.atan((double)yC / (double)xC);
                    continue block12;
                }
                case 3: {
                    thetas[x] = xC == 0 ? 0.0 : 1.5707963267948966 - Math.atan((double)yC / (double)xC);
                }
            }
        }
        double thetaInterval = Math.PI * 2 / (double)this.numThetaIntervals;
        int[] thetaIndexes = new int[dim];
        for (int i = 0; i < dim; ++i) {
            thetaIndexes[i] = (int)Math.floor(thetas[i] / thetaInterval);
        }
        double radiiInterval = Math.log(1 + this.coRelWindowRadius) / (double)this.numRadiiIntervals;
        double[] radiiQuants = new double[this.numRadiiIntervals];
        for (int i = 1; i <= this.numRadiiIntervals - 1; ++i) {
            double num = Math.exp((double)i * radiiInterval) - 1.0;
            radiiQuants[i - 1] = num * num;
        }
        radiiQuants[this.numRadiiIntervals - 1] = this.coRelWindowRadius * this.coRelWindowRadius;
        int[] radiiIndexes = new int[dim];
        for (int i = 0; i < dim; ++i) {
            radiiIndexes[i] = 0;
            for (int k = 0; k < radiiQuants.length; ++k) {
                if (!((double)radii[i] <= radiiQuants[k])) continue;
                int n = i;
                radiiIndexes[n] = radiiIndexes[n] + 1;
            }
            radiiIndexes[i] = radiiIndexes[i] - 1;
        }
        int[] binIndexes = new int[dim];
        for (int i = 0; i < dim; ++i) {
            binIndexes[i] = thetaIndexes[i] * radiiQuants.length + radiiIndexes[i];
        }
        LinkedList<Integer> nonzero = new LinkedList<Integer>();
        for (int i = 0; i < dim; ++i) {
            if (circleMask[i] <= 0) continue;
            nonzero.add(i);
        }
        int[] xGridVN = new int[nonzero.size()];
        int[] yGridVN = new int[nonzero.size()];
        int[] circleMaskVN = new int[nonzero.size()];
        int[] binIndexesVN = new int[nonzero.size()];
        for (int i = 0; i < nonzero.size(); ++i) {
            int pointer = (Integer)nonzero.get(i);
            xGridVN[i] = xGrid[pointer];
            yGridVN[i] = yGrid[pointer];
            circleMaskVN[i] = circleMask[pointer];
            binIndexesVN[i] = binIndexes[pointer];
        }
        int[] coRelCircleOffsets = new int[nonzero.size()];
        LinkedList<Integer> autoVarianceIndices = new LinkedList<Integer>();
        for (int i = 0; i < nonzero.size(); ++i) {
            coRelCircleOffsets[i] = xGridVN[i] * interiorH + yGridVN[i];
            if (circleMaskVN[i] != 2) continue;
            autoVarianceIndices.add(i);
        }
        int totalBins = this.numRadiiIntervals * this.numThetaIntervals;
        int[][] binIndices = new int[totalBins][];
        for (int i = 0; i < totalBins; ++i) {
            int j;
            LinkedList<Integer> myList = new LinkedList<Integer>();
            for (j = 0; j < binIndexesVN.length; ++j) {
                if (binIndexesVN[j] != i) continue;
                myList.add(j);
            }
            int[] tempList = new int[myList.size()];
            for (j = 0; j < myList.size(); ++j) {
                tempList[j] = (Integer)myList.get(j);
            }
            binIndices[i] = tempList;
        }
        int numAutoVarianceIndices = autoVarianceIndices.size();
        int numSSDs = coRelCircleOffsets.length;
        double[][] simMaps = new double[((NUMrows - marg * 2 - 1) / this.density + 1) * ((NUMcols - marg * 2 - 1) / this.density + 1)][totalBins];
        int[] allXCoords = new int[((NUMrows - marg * 2 - 1) / this.density + 1) * ((NUMcols - marg * 2 - 1) / this.density + 1)];
        int[] allYCoords = new int[((NUMrows - marg * 2 - 1) / this.density + 1) * ((NUMcols - marg * 2 - 1) / this.density + 1)];
        double[] ssdTraveller = new double[xGridVN.length];
        counter = 0;
        int fromI = marg - NUMradius;
        int toI = NUMcols - marg - NUMradius;
        int fromJ = marg - NUMradius;
        int toJ = NUMrows - marg - NUMradius;
        for (int i = fromI; i < toI; i += this.density) {
            for (int j = fromJ; j < toJ; j += this.density) {
                allXCoords[counter] = i;
                allYCoords[counter] = j;
                ssdTraveller = new double[xGridVN.length];
                for (int ii = 0; ii < xGridVN.length; ++ii) {
                    ssdTraveller[ii] = 0.0;
                    for (int k = 0; k < this.size; ++k) {
                        for (int l = 0; l < this.size; ++l) {
                            int diff = ImageGridRed[i + k][j + l] - ImageGridRed[i + k + xGridVN[ii]][j + l + yGridVN[ii]];
                            int n = ii;
                            ssdTraveller[n] = ssdTraveller[n] + (double)(diff * diff);
                            diff = ImageGridGreen[i + k][j + l] - ImageGridGreen[i + k + xGridVN[ii]][j + l + yGridVN[ii]];
                            int n2 = ii;
                            ssdTraveller[n2] = ssdTraveller[n2] + (double)(diff * diff);
                            diff = ImageGridBlue[i + k][j + l] - ImageGridBlue[i + k + xGridVN[ii]][j + l + yGridVN[ii]];
                            int n3 = ii;
                            ssdTraveller[n3] = ssdTraveller[n3] + (double)(diff * diff);
                        }
                    }
                }
                double autoQ = 0.0;
                for (int jj = 0; jj < numAutoVarianceIndices; ++jj) {
                    autoQ = ssdTraveller[(Integer)autoVarianceIndices.get(jj)] > autoQ ? ssdTraveller[(Integer)autoVarianceIndices.get(jj)] : autoQ;
                }
                double divisor = autoQ > (double)this.varNoise ? autoQ : (double)this.varNoise;
                for (int k = 0; k < numSSDs; ++k) {
                    ssdTraveller[k] = Math.exp(-1.0 * ssdTraveller[k] / divisor);
                }
                for (int l = 0; l < totalBins; ++l) {
                    double max = ssdTraveller[binIndices[l][0]];
                    for (int jj = 1; jj < binIndices[l].length; ++jj) {
                        if (!(ssdTraveller[binIndices[l][jj]] > max)) continue;
                        max = ssdTraveller[binIndices[l][jj]];
                    }
                    simMaps[counter][l] = max;
                }
                ++counter;
            }
        }
        LinkedList<Integer> indsSalient = new LinkedList<Integer>();
        LinkedList<Integer> indsOkay = new LinkedList<Integer>();
        for (int i = 0; i < simMaps.length; ++i) {
            int threshMaps = 0;
            for (int j = 0; j < totalBins; ++j) {
                if (!(simMaps[i][j] >= (double)this.saliencyThresh)) continue;
                ++threshMaps;
            }
            if (threshMaps == 0) {
                indsSalient.add(i);
            }
            if (threshMaps == 0) continue;
            indsOkay.add(i);
        }
        this.features = new LinkedList();
        double mySize = this.size + this.coRelWindowRadius * 2;
        for (int i = 0; i < indsOkay.size(); ++i) {
            int j;
            double[] newMaps = new double[totalBins];
            double max = simMaps[(Integer)indsOkay.get(i)][0];
            for (j = 0; j < totalBins; ++j) {
                newMaps[j] = simMaps[(Integer)indsOkay.get(i)][j];
                if (!(simMaps[(Integer)indsOkay.get(i)][j] > max)) continue;
                max = simMaps[(Integer)indsOkay.get(i)][j];
            }
            for (j = 0; j < totalBins; ++j) {
                newMaps[j] = newMaps[j] / max;
            }
            SelfSimilaritiesOrigFeature feat = new SelfSimilaritiesOrigFeature(newMaps, allXCoords[(Integer)indsOkay.get(i)], allYCoords[(Integer)indsOkay.get(i)], mySize);
            this.features.add(feat);
        }
    }

    @Override
    public List<? extends LocalFeature> getFeatures() {
        return this.features;
    }

    @Override
    public Class<? extends LocalFeature> getClassOfFeatures() {
        return SelfSimilaritiesOrigFeature.class;
    }
}

