/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.shapecontext;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeatureExtractor;
import net.semanticmetadata.lire.imageanalysis.features.local.shapecontext.ShapeContext;
import net.semanticmetadata.lire.imageanalysis.features.local.shapecontext.ShapemeHistogram;
import net.semanticmetadata.lire.imageanalysis.filters.CannyEdgeDetector;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DefaultRealMatrixChangingVisitor;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealMatrixChangingVisitor;

public class ShapeContextExtractor
implements LocalFeatureExtractor {
    public static final int SAMPLE_POINTS = 500;
    LinkedList<ShapeContext> listOfFeatures;

    public static LinkedList<ShapeContext> createHistogram(Point[] points, int angularBins, int radialBins, float innerRadius, float outerRadius) {
        RealMatrix anglesMatrix = ShapeContextExtractor.calculateAngleMatrix(points, angularBins);
        RealMatrix radiusMatrix = ShapeContextExtractor.calculateRadiusMatrix(points, radialBins, innerRadius, outerRadius);
        return ShapeContextExtractor.constructFeatureList(anglesMatrix, radiusMatrix, angularBins, radialBins, points);
    }

    private static RealMatrix calculateAngleMatrix(Point[] points, final int angularBins) {
        int numOfSamples = points.length;
        double twoPI = Math.PI * 2;
        Array2DRowRealMatrix anglesMatrix = new Array2DRowRealMatrix(numOfSamples, numOfSamples);
        for (int i = 0; i < numOfSamples; ++i) {
            for (int j = 0; j < numOfSamples; ++j) {
                double xLength = points[i].x - points[j].x;
                double yLength = points[i].y - points[j].y;
                anglesMatrix.setEntry(i, j, Math.atan2(xLength, yLength));
                anglesMatrix.setEntry(i, j, (anglesMatrix.getEntry(i, j) % twoPI + twoPI) % twoPI);
            }
        }
        anglesMatrix.walkInOptimizedOrder((RealMatrixChangingVisitor)new DefaultRealMatrixChangingVisitor(){

            public double visit(int row, int column, double value) {
                return Math.floor(value / (Math.PI * 2 / (double)angularBins));
            }
        });
        return anglesMatrix;
    }

    private static RealMatrix calculateRadiusMatrix(Point[] points, int radialBins, float innerRadius, float outerRadius) {
        double sumDist = 0.0;
        Array2DRowRealMatrix radiusMatrix = new Array2DRowRealMatrix(points.length, points.length);
        for (int i = 0; i < points.length; ++i) {
            for (int j = i + 1; j < points.length; ++j) {
                double euclidean = Utils.euclidDistance(points[i], points[j]);
                radiusMatrix.setEntry(i, j, euclidean);
                radiusMatrix.setEntry(j, i, euclidean);
                sumDist += euclidean * 2.0;
            }
        }
        double meanDistance = sumDist / Math.pow(points.length, 2.0);
        if (meanDistance != 0.0) {
            final double finalMeanDistance = meanDistance;
            radiusMatrix.walkInOptimizedOrder((RealMatrixChangingVisitor)new DefaultRealMatrixChangingVisitor(){

                public double visit(int row, int column, double value) {
                    return value / finalMeanDistance;
                }
            });
        }
        double[] LogSpace = Utils.logSpace(innerRadius, outerRadius, radialBins);
        double upperLogSpaceValue = LogSpace[radialBins - 1];
        for (int i = 0; i < points.length; ++i) {
            block3: for (int j = 0; j < points.length; ++j) {
                double val = radiusMatrix.getEntry(i, j);
                radiusMatrix.setEntry(i, j, (double)Utils.NAN);
                if (val > upperLogSpaceValue) continue;
                for (int k = 0; k < radialBins; ++k) {
                    if (!(val < LogSpace[k])) continue;
                    radiusMatrix.setEntry(i, j, (double)k);
                    continue block3;
                }
            }
        }
        return radiusMatrix;
    }

    private static LinkedList<ShapeContext> constructFeatureList(RealMatrix angleMatrix, RealMatrix radiusMatrix, int radialBins, int angularBins, Point[] points) {
        int rowLen = angleMatrix.getRowDimension();
        int columnLen = angleMatrix.getColumnDimension();
        if (rowLen != radiusMatrix.getRowDimension() || columnLen != radiusMatrix.getColumnDimension()) {
            return null;
        }
        LinkedList<ShapeContext> shapeContexts = new LinkedList<ShapeContext>();
        for (int i = 0; i < rowLen; ++i) {
            Array2DRowRealMatrix histogram = new Array2DRowRealMatrix(radialBins, angularBins);
            for (int j = i; j < columnLen; ++j) {
                int radialBin = (int)radiusMatrix.getEntry(i, j);
                int angularBin = (int)angleMatrix.getEntry(i, j);
                if (radialBin == Utils.NAN || angularBin == Utils.NAN) continue;
                histogram.setEntry(angularBin, radialBin, histogram.getEntry(angularBin, radialBin) + 1.0);
            }
            shapeContexts.add(new ShapeContext(ShapeContextExtractor.elements((RealMatrix)histogram), points[i].x, points[i].y));
        }
        return shapeContexts;
    }

    @Override
    public List<? extends LocalFeature> getFeatures() {
        return this.listOfFeatures;
    }

    @Override
    public Class<? extends LocalFeature> getClassOfFeatures() {
        return ShapemeHistogram.class;
    }

    @Override
    public void extract(BufferedImage image) {
        Point[] pointsArray;
        try {
            List<Point> pts = ShapeContextExtractor.getEdgePoints(image, 500);
            pointsArray = pts.toArray(new Point[pts.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            pointsArray = new Point[]{};
        }
        this.listOfFeatures = ShapeContextExtractor.createHistogram(pointsArray, 12, 5, 0.2f, 2.0f);
    }

    public static List<Point> getEdgePoints(BufferedImage image, int samplePoints) {
        CannyEdgeDetector cannyEdgeDetector = new CannyEdgeDetector(image);
        image = cannyEdgeDetector.filter();
        ArrayList<Point> points = new ArrayList<Point>();
        int[] tmp = new int[1];
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                if (image.getRaster().getPixel(j, i, tmp)[0] != 0) continue;
                points.add(new Point(j, i));
            }
        }
        return ShapeContextExtractor.distributedSample(points, samplePoints);
    }

    public static BufferedImage getSampledPointsImage(BufferedImage image) {
        int[] pixel = new int[]{255};
        List<Point> points = ShapeContextExtractor.getEdgePoints(image, 500);
        BufferedImage imgNew = new BufferedImage(image.getWidth(), image.getHeight(), 12);
        for (Point point : points) {
            imgNew.getRaster().setPixel(point.x, point.y, pixel);
        }
        return imgNew;
    }

    private static double[] elements(RealMatrix re) {
        int k = 0;
        double[] res = new double[re.getRowDimension() * re.getColumnDimension()];
        for (int i = 0; i < re.getRowDimension(); ++i) {
            for (int j = 0; j < re.getColumnDimension(); ++j) {
                res[k++] = re.getEntry(i, j);
            }
        }
        return res;
    }

    public static <T> Set<T> randomSample(List<T> items, int m) {
        if (items.size() <= m) {
            return new HashSet<T>(items);
        }
        Random rnd = new Random(100L);
        HashSet<T> res = new HashSet<T>(m);
        int n = items.size();
        for (int i = n - m; i < n; ++i) {
            int pos = rnd.nextInt(i + 1);
            T item = items.get(pos);
            if (res.contains(item)) {
                res.add(items.get(i));
                continue;
            }
            res.add(item);
        }
        return res;
    }

    public static <T> List<T> distributedSample(List<T> items, int m) {
        if (items.size() <= m) {
            return new ArrayList<T>(items);
        }
        ArrayList<T> res = new ArrayList<T>(m);
        int n = items.size();
        int step = n / m;
        for (int i = 0; i < n; i += step) {
            res.add(items.get(i));
        }
        return res;
    }

    public static class Utils {
        public static int NAN = -1;

        public static double euclidDistance(Point point1, Point point2) {
            double xSqr = Math.pow(point1.x - point2.x, 2.0);
            double ySqr = Math.pow(point1.y - point2.y, 2.0);
            return Math.sqrt(xSqr + ySqr);
        }

        public static double[] logSpace(double lowBoundary, double highBoundary, int numSlices) {
            lowBoundary = Math.log10(lowBoundary);
            highBoundary = Math.log10(highBoundary);
            double[] logSpace = new double[numSlices];
            double distance = highBoundary - lowBoundary;
            int numOfSlices = numSlices - 1;
            double delta = distance / (double)numOfSlices;
            for (int i = 0; i < numOfSlices; i = (int)((short)(i + 1))) {
                logSpace[i] = Math.pow(10.0, lowBoundary + (double)i * delta);
            }
            logSpace[numOfSlices] = Math.pow(10.0, highBoundary);
            return logSpace;
        }
    }

    public static class Point
    implements Comparable<Point> {
        public int x;
        public int y;

        public Point(int new_x, int new_y) {
            this.x = new_x;
            this.y = new_y;
        }

        public String toString() {
            return "x: " + this.x + " y: " + this.y;
        }

        @Override
        public int compareTo(Point point) {
            int v1 = Integer.compare(this.x, point.x);
            if (v1 != 0) {
                return v1;
            }
            return Integer.compare(this.y, point.y);
        }
    }
}

