/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.shapecontext;

import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.imageanalysis.features.local.shapecontext.ShapeContext;
import net.semanticmetadata.lire.imageanalysis.features.local.shapecontext.ShapeContextExtractor;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class ShapemeHistogram
implements LocalFeature {
    int[] histogram;

    @Override
    public String getFeatureName() {
        return ShapeContext.class.getSimpleName();
    }

    @Override
    public String getFieldName() {
        return "ShapeContext";
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        return SerializationUtils.toByteArray(this.histogram);
    }

    @Override
    public void setByteArrayRepresentation(byte[] bytes) {
        this.histogram = SerializationUtils.toIntArray(bytes);
    }

    @Override
    public void setByteArrayRepresentation(byte[] bytes, int i, int i1) {
        this.histogram = SerializationUtils.toIntArray(bytes);
    }

    @Override
    public double getDistance(LireFeature lireFeature) {
        if (!(lireFeature instanceof ShapemeHistogram)) {
            throw new RuntimeException("not implemented");
        }
        return MetricsUtils.distL1(((ShapemeHistogram)lireFeature).histogram, this.histogram);
    }

    @Override
    public double[] getFeatureVector() {
        double[] tmpHist = new double[this.histogram.length];
        for (int i = 0; i < this.histogram.length; ++i) {
            tmpHist[i] = this.histogram[i];
        }
        return tmpHist;
    }

    @Override
    public double getX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getY() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?> getClassOfExtractor() {
        return ShapeContextExtractor.class;
    }
}

