/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.sift;

import java.util.Random;
import net.semanticmetadata.lire.imageanalysis.features.local.sift.FloatArray2D;

public class Filter {
    public static final int flipInRange(int a, int mod) {
        int p = 2 * mod;
        if (a < 0) {
            a = p + a % p;
        }
        if (a >= p) {
            a %= p;
        }
        if (a >= mod) {
            a = mod - a % mod - 1;
        }
        return a;
    }

    public static final int ldu(int v) {
        int c = 0;
        do {
            ++c;
        } while ((v >>= 1) > 1);
        return c;
    }

    public static float[] createGaussianKernel1D(float sigma, boolean normalize) {
        float[] gaussianKernel;
        int size = 3;
        if (sigma <= 0.0f) {
            gaussianKernel = new float[3];
            gaussianKernel[1] = 1.0f;
        } else {
            size = Math.max(3, 2 * (int)((double)(3.0f * sigma) + 0.5) + 1);
            float two_sq_sigma = 2.0f * sigma * sigma;
            gaussianKernel = new float[size];
            for (int x = size / 2; x >= 0; --x) {
                float val;
                gaussianKernel[size / 2 - x] = val = (float)Math.exp(-((float)(x * x)) / two_sq_sigma);
                gaussianKernel[size / 2 + x] = val;
            }
        }
        if (normalize) {
            float sum = 0.0f;
            for (float value : gaussianKernel) {
                sum += value;
            }
            int i = 0;
            while (i < gaussianKernel.length) {
                int n = i++;
                gaussianKernel[n] = gaussianKernel[n] / sum;
            }
        }
        return gaussianKernel;
    }

    public static FloatArray2D createGaussianKernel2D(float sigma, boolean normalize) {
        FloatArray2D gaussianKernel;
        int size = 3;
        if (sigma <= 0.0f) {
            gaussianKernel = new FloatArray2D(3, 3);
            gaussianKernel.data[4] = 1.0f;
        } else {
            size = Math.max(3, 2 * (int)((double)(3.0f * sigma) + 0.5) + 1);
            float two_sq_sigma = 2.0f * sigma * sigma;
            gaussianKernel = new FloatArray2D(size, size);
            for (int y = size / 2; y >= 0; --y) {
                for (int x = size / 2; x >= 0; --x) {
                    float val = (float)Math.exp(-((float)(y * y + x * x)) / two_sq_sigma);
                    gaussianKernel.set(val, size / 2 - x, size / 2 - y);
                    gaussianKernel.set(val, size / 2 - x, size / 2 + y);
                    gaussianKernel.set(val, size / 2 + x, size / 2 - y);
                    gaussianKernel.set(val, size / 2 + x, size / 2 + y);
                }
            }
        }
        if (normalize) {
            float sum = 0.0f;
            for (float value : gaussianKernel.data) {
                sum += value;
            }
            int i = 0;
            while (i < gaussianKernel.data.length) {
                int n = i++;
                gaussianKernel.data[n] = gaussianKernel.data[n] / sum;
            }
        }
        return gaussianKernel;
    }

    public static FloatArray2D create_gaussian_kernel_2D_offset(float sigma, float offset_x, float offset_y, boolean normalize) {
        FloatArray2D gaussian_kernel;
        int size = 3;
        if (sigma == 0.0f) {
            gaussian_kernel = new FloatArray2D(3, 3);
            gaussian_kernel.data[4] = 1.0f;
        } else {
            size = Math.max(3, 2 * Math.round(3.0f * sigma) + 1);
            float two_sq_sigma = 2.0f * sigma * sigma;
            gaussian_kernel = new FloatArray2D(size, size);
            for (int x = size - 1; x >= 0; --x) {
                float fx = x - size / 2;
                for (int y = size - 1; y >= 0; --y) {
                    float fy = y - size / 2;
                    float val = (float)Math.exp(-(Math.pow(fx - offset_x, 2.0) + Math.pow(fy - offset_y, 2.0)) / (double)two_sq_sigma);
                    gaussian_kernel.set(val, x, y);
                }
            }
        }
        if (normalize) {
            float sum = 0.0f;
            for (float value : gaussian_kernel.data) {
                sum += value;
            }
            int i = 0;
            while (i < gaussian_kernel.data.length) {
                int n = i++;
                gaussian_kernel.data[n] = gaussian_kernel.data[n] / sum;
            }
        }
        return gaussian_kernel;
    }

    public static FloatArray2D computeIncreasingGaussianX(FloatArray2D input, float stDevStart, float stDevEnd) {
        FloatArray2D output = new FloatArray2D(input.width, input.height);
        int width = input.width;
        float changeFilterSize = (stDevEnd - stDevStart) / (float)width;
        for (int x = 0; x < input.width; ++x) {
            float sigma = stDevStart + changeFilterSize * (float)x;
            FloatArray2D kernel = Filter.createGaussianKernel2D(sigma, true);
            int filterSize = kernel.width;
            for (int y = 0; y < input.height; ++y) {
                float avg = 0.0f;
                for (int fx = -filterSize / 2; fx <= filterSize / 2; ++fx) {
                    for (int fy = -filterSize / 2; fy <= filterSize / 2; ++fy) {
                        try {
                            avg += input.get(x + fx, y + fy) * kernel.get(fx + filterSize / 2, fy + filterSize / 2);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                output.set(avg, x, y);
            }
        }
        return output;
    }

    public static FloatArray2D computeGaussian(FloatArray2D input, float sigma) {
        FloatArray2D output = new FloatArray2D(input.width, input.height);
        FloatArray2D kernel = Filter.createGaussianKernel2D(sigma, true);
        int filterSize = kernel.width;
        for (int x = 0; x < input.width; ++x) {
            for (int y = 0; y < input.height; ++y) {
                float avg = 0.0f;
                float kernelsum = 0.0f;
                for (int fx = -filterSize / 2; fx <= filterSize / 2; ++fx) {
                    for (int fy = -filterSize / 2; fy <= filterSize / 2; ++fy) {
                        try {
                            avg += input.get(x + fx, y + fy) * kernel.get(fx + filterSize / 2, fy + filterSize / 2);
                            kernelsum += kernel.get(fx + filterSize / 2, fy + filterSize / 2);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                output.set(avg / kernelsum, x, y);
            }
        }
        return output;
    }

    public static FloatArray2D computeGaussianFastMirror(FloatArray2D input, float sigma) {
        float avg;
        int x;
        FloatArray2D output = new FloatArray2D(input.width, input.height);
        float kernelsum = 0.0f;
        float[] kernel = Filter.createGaussianKernel1D(sigma, true);
        int filterSize = kernel.length;
        float[] fArray = kernel;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            double value = fArray[i];
            kernelsum = (float)((double)kernelsum + value);
        }
        for (x = 0; x < input.width; ++x) {
            for (int y = 0; y < input.height; ++y) {
                int f;
                avg = 0.0f;
                if (x - filterSize / 2 >= 0 && x + filterSize / 2 < input.width) {
                    for (f = -filterSize / 2; f <= filterSize / 2; ++f) {
                        avg += input.get(x + f, y) * kernel[f + filterSize / 2];
                    }
                } else {
                    for (f = -filterSize / 2; f <= filterSize / 2; ++f) {
                        avg += input.getMirror(x + f, y) * kernel[f + filterSize / 2];
                    }
                }
                output.set(avg / kernelsum, x, y);
            }
        }
        for (x = 0; x < input.width; ++x) {
            int y;
            float[] temp = new float[input.height];
            for (y = 0; y < input.height; ++y) {
                int f;
                avg = 0.0f;
                if (y - filterSize / 2 >= 0 && y + filterSize / 2 < input.height) {
                    for (f = -filterSize / 2; f <= filterSize / 2; ++f) {
                        avg += output.get(x, y + f) * kernel[f + filterSize / 2];
                    }
                } else {
                    for (f = -filterSize / 2; f <= filterSize / 2; ++f) {
                        avg += output.getMirror(x, y + f) * kernel[f + filterSize / 2];
                    }
                }
                temp[y] = avg / kernelsum;
            }
            for (y = 0; y < input.height; ++y) {
                output.set(temp[y], x, y);
            }
        }
        return output;
    }

    public static FloatArray2D distortSamplingX(FloatArray2D input) {
        FloatArray2D output = new FloatArray2D(input.width, input.height);
        int filterSize = 3;
        Random rnd = new Random(353245632L);
        for (int x = 0; x < input.width; ++x) {
            float val3;
            float val2;
            float val1;
            FloatArray2D kernel = new FloatArray2D(3, 1);
            float random = (rnd.nextFloat() - 0.5f) * 2.0f;
            if (random < 0.0f) {
                val1 = -random;
                val2 = 1.0f + random;
                val3 = 0.0f;
            } else {
                val3 = random;
                val2 = 1.0f - random;
                val1 = 0.0f;
            }
            kernel.set(val1, 0, 0);
            kernel.set(val2, 1, 0);
            kernel.set(val3, 2, 0);
            for (int y = 0; y < input.height; ++y) {
                float avg = 0.0f;
                for (int fx = -filterSize / 2; fx <= filterSize / 2; ++fx) {
                    try {
                        avg += input.get(x + fx, y) * kernel.get(fx + filterSize / 2, 0);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                output.set(avg, x, y);
            }
        }
        return output;
    }

    public static FloatArray2D distortSamplingY(FloatArray2D input) {
        FloatArray2D output = new FloatArray2D(input.width, input.height);
        int filterSize = 3;
        Random rnd = new Random(7893469L);
        for (int y = 0; y < input.height; ++y) {
            float val3;
            float val2;
            float val1;
            FloatArray2D kernel = new FloatArray2D(1, 3);
            float random = (rnd.nextFloat() - 0.5f) * 2.0f;
            if (random < 0.0f) {
                val1 = -random;
                val2 = 1.0f + random;
                val3 = 0.0f;
            } else {
                val3 = random;
                val2 = 1.0f - random;
                val1 = 0.0f;
            }
            kernel.set(val1, 0, 0);
            kernel.set(val2, 0, 1);
            kernel.set(val3, 0, 2);
            for (int x = 0; x < input.width; ++x) {
                float avg = 0.0f;
                for (int fy = -filterSize / 2; fy <= filterSize / 2; ++fy) {
                    try {
                        avg += input.get(x, y + fy) * kernel.get(0, fy + filterSize / 2);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                output.set(avg, x, y);
            }
        }
        return output;
    }

    public static FloatArray2D computeLaPlaceFilter3(FloatArray2D input) {
        FloatArray2D output = new FloatArray2D(input.width, input.height);
        for (int y = 1; y < input.height - 1; ++y) {
            for (int x = 1; x < input.width - 1; ++x) {
                float x1 = input.get(x - 1, y);
                float x2 = input.get(x, y);
                float x3 = input.get(x + 1, y);
                float derivX = x1 - 2.0f * x2 + x3;
                float y1 = input.get(x, y - 1);
                float y2 = input.get(x, y);
                float y3 = input.get(x, y + 1);
                float derivY = y1 - 2.0f * y2 + y3;
                output.set((float)Math.sqrt(Math.pow(derivX, 2.0) + Math.pow(derivY, 2.0)), x, y);
            }
        }
        return output;
    }

    public static FloatArray2D computeLaPlaceFilter5(FloatArray2D input) {
        FloatArray2D output = new FloatArray2D(input.width, input.height);
        for (int y = 2; y < input.height - 2; ++y) {
            for (int x = 2; x < input.width - 2; ++x) {
                float x1 = input.get(x - 2, y);
                float x3 = input.get(x, y);
                float x5 = input.get(x + 2, y);
                float derivX = x1 - 2.0f * x3 + x5;
                float y1 = input.get(x, y - 2);
                float y3 = input.get(x, y);
                float y5 = input.get(x, y + 2);
                float derivY = y1 - 2.0f * y3 + y5;
                output.set((float)Math.sqrt(Math.pow(derivX, 2.0) + Math.pow(derivY, 2.0)), x, y);
            }
        }
        return output;
    }

    public static FloatArray2D[] createGradients(FloatArray2D array) {
        FloatArray2D[] gradients = new FloatArray2D[]{new FloatArray2D(array.width, array.height), new FloatArray2D(array.width, array.height)};
        for (int y = 0; y < array.height; ++y) {
            int[] ro = new int[]{array.width * Math.max(0, y - 1), array.width * y, array.width * Math.min(y + 1, array.height - 1)};
            for (int x = 0; x < array.width; ++x) {
                float der_x = (array.data[ro[1] + Math.min(x + 1, array.width - 1)] - array.data[ro[1] + Math.max(0, x - 1)]) / 2.0f;
                float der_y = (array.data[ro[2] + x] - array.data[ro[0] + x]) / 2.0f;
                gradients[0].data[ro[1] + x] = (float)Math.sqrt(Math.pow(der_x, 2.0) + Math.pow(der_y, 2.0));
                gradients[1].data[ro[1] + x] = (float)Math.atan2(der_y, der_x);
            }
        }
        return gradients;
    }

    public static final void enhance(FloatArray2D src, float scale) {
        int i;
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        for (i = 0; i < src.data.length; ++i) {
            if (src.data[i] < min) {
                min = src.data[i];
                continue;
            }
            if (!(src.data[i] > max)) continue;
            max = src.data[i];
        }
        scale /= max - min;
        for (i = 0; i < src.data.length; ++i) {
            src.data[i] = scale * (src.data[i] - min);
        }
    }

    public static FloatArray2D convolveSeparable(FloatArray2D input, float[] h, float[] v) {
        int x;
        FloatArray2D output = new FloatArray2D(input.width, input.height);
        FloatArray2D temp = new FloatArray2D(input.width, input.height);
        int hl = h.length / 2;
        int vl = v.length / 2;
        int xl = input.width - h.length + 1;
        int yl = input.height - v.length + 1;
        int[] xb = new int[h.length + hl - 1];
        int[] xa = new int[h.length + hl - 1];
        for (int i = 0; i < xb.length; ++i) {
            xb[i] = Filter.flipInRange(i - hl, input.width);
            xa[i] = Filter.flipInRange(i + xl, input.width);
        }
        int[] yb = new int[v.length + vl - 1];
        int[] ya = new int[v.length + vl - 1];
        for (int i = 0; i < yb.length; ++i) {
            yb[i] = input.width * Filter.flipInRange(i - vl, input.height);
            ya[i] = input.width * Filter.flipInRange(i + yl, input.height);
        }
        xl += hl;
        yl += vl;
        int rl = input.height * input.width;
        for (int r = 0; r < rl; r += input.width) {
            int xk;
            for (x = hl; x < xl; ++x) {
                int c = x - hl;
                float val = 0.0f;
                for (xk = 0; xk < h.length; ++xk) {
                    val += h[xk] * input.data[r + c + xk];
                }
                temp.data[r + x] = val;
            }
            for (x = 0; x < hl; ++x) {
                float valb = 0.0f;
                float vala = 0.0f;
                for (xk = 0; xk < h.length; ++xk) {
                    valb += h[xk] * input.data[r + xb[x + xk]];
                    vala += h[xk] * input.data[r + xa[x + xk]];
                }
                temp.data[r + x] = valb;
                temp.data[r + x + xl] = vala;
            }
        }
        rl = yl * temp.width;
        int vlc = vl * temp.width;
        for (x = 0; x < temp.width; ++x) {
            int yk;
            for (int r = vlc; r < rl; r += temp.width) {
                float val = 0.0f;
                int c = r - vlc;
                int rk = 0;
                for (yk = 0; yk < v.length; ++yk) {
                    val += v[yk] * temp.data[c + rk + x];
                    rk += temp.width;
                }
                output.data[r + x] = val;
            }
            for (int y = 0; y < vl; ++y) {
                int r = y * temp.width;
                float valb = 0.0f;
                float vala = 0.0f;
                for (yk = 0; yk < v.length; ++yk) {
                    valb += h[yk] * temp.data[yb[y + yk] + x];
                    vala += h[yk] * temp.data[ya[y + yk] + x];
                }
                output.data[r + x] = valb;
                output.data[r + rl + x] = vala;
            }
        }
        return output;
    }
}

