/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.sift;

import java.util.Vector;
import net.semanticmetadata.lire.imageanalysis.features.local.sift.FloatArray2D;
import net.semanticmetadata.lire.imageanalysis.features.local.sift.FloatArray2DScaleOctave;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;

public class FloatArray2DScaleOctaveDoGDetector {
    private static final float MIN_CONTRAST = 0.025f;
    private static final float MAX_CURVATURE = 10.0f;
    private static final float MAX_CURVATURE_RATIO = 12.1f;
    private FloatArray2DScaleOctave octave = null;
    private Vector<float[]> candidates = null;

    public Vector<float[]> getCandidates() {
        return this.candidates;
    }

    public void run(FloatArray2DScaleOctave o) {
        this.octave = o;
        this.candidates = new Vector();
        this.detectCandidates();
    }

    private void detectCandidates() {
        FloatArray2D[] d = this.octave.getD();
        for (int i = d.length - 2; i >= 1; --i) {
            int ia = i - 1;
            int ib = i + 1;
            for (int y = d[i].height - 2; y >= 1; --y) {
                int r = y * d[i].width;
                int ra = r - d[i].width;
                int rb = r + d[i].width;
                block4: for (int x = d[i].width - 2; x >= 1; --x) {
                    float det;
                    float trace;
                    float oi;
                    float oy;
                    float ox;
                    float dxy;
                    float dyy;
                    float dxx;
                    float di;
                    float dy;
                    float dx;
                    float e222;
                    float e122;
                    float e022;
                    float e212;
                    float e112;
                    float e012;
                    float e202;
                    float e102;
                    float e002;
                    float e221;
                    float e121;
                    float e021;
                    float e211;
                    float e011;
                    float e201;
                    float e101;
                    float e001;
                    float e220;
                    float e120;
                    float e020;
                    float e210;
                    float e110;
                    float e010;
                    float e200;
                    float e100;
                    boolean isMin;
                    int ic = i;
                    int iac = ia;
                    int ibc = ib;
                    int yc = y;
                    int rc = r;
                    int rac = ra;
                    int rbc = rb;
                    int xc = x;
                    int xa = xc - 1;
                    int xb = xc + 1;
                    float e000 = d[iac].data[rac + xa];
                    float e111 = d[ic].data[r + xc];
                    boolean isMax = e000 < e111;
                    boolean bl = isMin = e000 > e111;
                    if (!isMax && !isMin || !(isMax &= (e100 = d[iac].data[rac + xc]) < e111) && !(isMin &= e100 > e111) || !(isMax &= (e200 = d[iac].data[rac + xb]) < e111) && !(isMin &= e200 > e111) || !(isMax &= (e010 = d[iac].data[rc + xa]) < e111) && !(isMin &= e010 > e111) || !(isMax &= (e110 = d[iac].data[rc + xc]) < e111) && !(isMin &= e110 > e111) || !(isMax &= (e210 = d[iac].data[rc + xb]) < e111) && !(isMin &= e210 > e111) || !(isMax &= (e020 = d[iac].data[rbc + xa]) < e111) && !(isMin &= e020 > e111) || !(isMax &= (e120 = d[iac].data[rbc + xc]) < e111) && !(isMin &= e120 > e111) || !(isMax &= (e220 = d[iac].data[rbc + xb]) < e111) && !(isMin &= e220 > e111) || !(isMax &= (e001 = d[ic].data[rac + xa]) < e111) && !(isMin &= e001 > e111) || !(isMax &= (e101 = d[ic].data[rac + xc]) < e111) && !(isMin &= e101 > e111) || !(isMax &= (e201 = d[ic].data[rac + xb]) < e111) && !(isMin &= e201 > e111) || !(isMax &= (e011 = d[ic].data[rc + xa]) < e111) && !(isMin &= e011 > e111) || !(isMax &= (e211 = d[ic].data[rc + xb]) < e111) && !(isMin &= e211 > e111) || !(isMax &= (e021 = d[ic].data[rbc + xa]) < e111) && !(isMin &= e021 > e111) || !(isMax &= (e121 = d[ic].data[rbc + xc]) < e111) && !(isMin &= e121 > e111) || !(isMax &= (e221 = d[ic].data[rbc + xb]) < e111) && !(isMin &= e221 > e111) || !(isMax &= (e002 = d[ibc].data[rac + xa]) < e111) && !(isMin &= e002 > e111) || !(isMax &= (e102 = d[ibc].data[rac + xc]) < e111) && !(isMin &= e102 > e111) || !(isMax &= (e202 = d[ibc].data[rac + xb]) < e111) && !(isMin &= e202 > e111) || !(isMax &= (e012 = d[ibc].data[rc + xa]) < e111) && !(isMin &= e012 > e111) || !(isMax &= (e112 = d[ibc].data[rc + xc]) < e111) && !(isMin &= e112 > e111) || !(isMax &= (e212 = d[ibc].data[rc + xb]) < e111) && !(isMin &= e212 > e111) || !(isMax &= (e022 = d[ibc].data[rbc + xa]) < e111) && !(isMin &= e022 > e111) || !(isMax &= (e122 = d[ibc].data[rbc + xc]) < e111) && !(isMin &= e122 > e111) || !(isMax &= (e222 = d[ibc].data[rbc + xb]) < e111) && !(isMin &= e222 > e111)) continue;
                    boolean isLocalized = false;
                    boolean isLocalizable = true;
                    float od = Float.MAX_VALUE;
                    float fx = 0.0f;
                    float fy = 0.0f;
                    float fi = 0.0f;
                    int t = 5;
                    do {
                        RealMatrix H_inv;
                        --t;
                        dx = (e211 - e011) / 2.0f;
                        dy = (e121 - e101) / 2.0f;
                        di = (e112 - e110) / 2.0f;
                        float e111_2 = 2.0f * e111;
                        dxx = e011 - e111_2 + e211;
                        dyy = e101 - e111_2 + e121;
                        float dii = e110 - e111_2 + e112;
                        dxy = (e221 - e021 - e201 + e001) / 4.0f;
                        float dxi = (e212 - e012 - e210 + e010) / 4.0f;
                        float dyi = (e122 - e102 - e120 + e100) / 4.0f;
                        Array2DRowRealMatrix H = new Array2DRowRealMatrix((double[][])new double[][]{{dxx, dxy, dxi}, {dxy, dyy, dyi}, {dxi, dyi, dii}});
                        try {
                            H_inv = new LUDecomposition((RealMatrix)H).getSolver().getInverse();
                        }
                        catch (RuntimeException e) {
                            continue block4;
                        }
                        double[][] h_inv = H_inv.getData();
                        ox = -((float)h_inv[0][0]) * dx - (float)h_inv[0][1] * dy - (float)h_inv[0][0] * di;
                        oy = -((float)h_inv[1][0]) * dx - (float)h_inv[1][1] * dy - (float)h_inv[1][0] * di;
                        oi = -((float)h_inv[2][0]) * dx - (float)h_inv[2][1] * dy - (float)h_inv[2][0] * di;
                        float odc = ox * ox + oy * oy + oi * oi;
                        if (odc < 2.0f) {
                            if (((double)Math.abs(ox) > 0.5 || (double)Math.abs(oy) > 0.5 || (double)Math.abs(oi) > 0.5) && odc < od) {
                                od = odc;
                                xc = Math.round((float)xc + ox);
                                yc = Math.round((float)yc + oy);
                                ic = Math.round((float)ic + oi);
                                if (xc < 1 || yc < 1 || ic < 1 || xc > d[0].width - 2 || yc > d[0].height - 2 || ic > d.length - 2) {
                                    isLocalizable = false;
                                    continue;
                                }
                                xa = xc - 1;
                                xb = xc + 1;
                                rc = yc * d[ic].width;
                                rac = rc - d[ic].width;
                                rbc = rc + d[ic].width;
                                iac = ic - 1;
                                ibc = ic + 1;
                                e000 = d[iac].data[rac + xa];
                                e100 = d[iac].data[rac + xc];
                                e200 = d[iac].data[rac + xb];
                                e010 = d[iac].data[rc + xa];
                                e110 = d[iac].data[rc + xc];
                                e210 = d[iac].data[rc + xb];
                                e020 = d[iac].data[rbc + xa];
                                e120 = d[iac].data[rbc + xc];
                                e220 = d[iac].data[rbc + xb];
                                e001 = d[ic].data[rac + xa];
                                e101 = d[ic].data[rac + xc];
                                e201 = d[ic].data[rac + xb];
                                e011 = d[ic].data[rc + xa];
                                e111 = d[ic].data[rc + xc];
                                e211 = d[ic].data[rc + xb];
                                e021 = d[ic].data[rbc + xa];
                                e121 = d[ic].data[rbc + xc];
                                e221 = d[ic].data[rbc + xb];
                                e002 = d[ibc].data[rac + xa];
                                e102 = d[ibc].data[rac + xc];
                                e202 = d[ibc].data[rac + xb];
                                e012 = d[ibc].data[rc + xa];
                                e112 = d[ibc].data[rc + xc];
                                e212 = d[ibc].data[rc + xb];
                                e022 = d[ibc].data[rbc + xa];
                                e122 = d[ibc].data[rbc + xc];
                                e222 = d[ibc].data[rbc + xb];
                                continue;
                            }
                            fx = (float)xc + ox;
                            fy = (float)yc + oy;
                            fi = (float)ic + oi;
                            if (fx < 0.0f || fy < 0.0f || fi < 0.0f || fx > (float)(d[0].width - 1) || fy > (float)(d[0].height - 1) || fi > (float)(d.length - 1)) {
                                isLocalizable = false;
                                continue;
                            }
                            isLocalized = true;
                            continue;
                        }
                        isLocalizable = false;
                    } while (!isLocalized && isLocalizable && t >= 0);
                    if (!isLocalized || Math.abs(e111 + 0.5f * (dx * ox + dy * oy + di * oi)) < 0.025f || (trace = dxx + dyy) * trace / (det = dxx * dyy - dxy * dxy) > 12.1f) continue;
                    this.candidates.addElement(new float[]{fx, fy, fi});
                }
            }
        }
    }
}

