/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.sift;

import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.Random;
import net.semanticmetadata.lire.imageanalysis.features.local.sift.PointMatch;

public abstract class Model {
    public static final int MIN_SET_SIZE = 0;
    static final Random rnd = new Random(69997L);
    public double error = Double.MAX_VALUE;

    public abstract boolean fit(PointMatch[] var1);

    public abstract float[] apply(float[] var1);

    public abstract void applyInPlace(float[] var1);

    public abstract float[] applyInverse(float[] var1);

    public abstract void applyInverseInPlace(float[] var1);

    public boolean test(Collection<PointMatch> candidates, Collection<PointMatch> inliers, double epsilon, double min_inlier_ratio) {
        inliers.clear();
        for (PointMatch m : candidates) {
            m.apply(this);
            if (!((double)m.getDistance() < epsilon)) continue;
            inliers.add(m);
        }
        float ir = (float)inliers.size() / (float)candidates.size();
        this.error = 1.0 - (double)ir;
        if (this.error > 1.0) {
            this.error = 1.0;
        }
        if (this.error < 0.0) {
            this.error = 0.0;
        }
        return (double)ir > min_inlier_ratio;
    }

    public boolean betterThan(Model m) {
        if (this.error < 0.0) {
            return false;
        }
        return this.error < m.error;
    }

    public abstract void shake(Collection<PointMatch> var1, float var2, float[] var3);

    public abstract void minimize(Collection<PointMatch> var1);

    public abstract AffineTransform getAffine();

    public abstract String toString();

    public abstract Model clone();
}

