/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.sift;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeatureExtractor;
import net.semanticmetadata.lire.imageanalysis.features.local.sift.Filter;
import net.semanticmetadata.lire.imageanalysis.features.local.sift.FloatArray2D;
import net.semanticmetadata.lire.imageanalysis.features.local.sift.FloatArray2DSIFT;
import net.semanticmetadata.lire.imageanalysis.features.local.sift.Found;
import net.semanticmetadata.lire.imageanalysis.features.local.sift.ImageArrayConverter;
import net.semanticmetadata.lire.imageanalysis.features.local.sift.SiftFeature;

public class SiftExtractor
implements LocalFeatureExtractor {
    int steps = 3;
    float initial_sigma = 1.6f;
    double bg = 0.0;
    int fdsize = 4;
    int fdbins = 8;
    int min_size = 64;
    int max_size = 1024;
    float min_epsilon = 2.0f;
    float max_epsilon = 100.0f;
    float min_inlier_ratio = 0.05f;
    float scale = 1.0f;
    List<SiftFeature> features = null;

    private void align(BufferedImage img1, BufferedImage img2) {
        try {
            List<SiftFeature> fs1 = this.computeSiftFeatures(img1);
            List<SiftFeature> fs2 = this.computeSiftFeatures(img2);
            LinkedList<Found> res = new LinkedList<Found>();
            for (int i = 0; i < fs1.size(); ++i) {
                SiftFeature f1 = fs1.get(i);
                for (int j = i + 1; j < fs2.size(); ++j) {
                    SiftFeature f2 = fs2.get(j);
                    float d = f2.descriptorDistance(f1);
                    res.add(new Found(f1, f2, d));
                    Collections.sort(res);
                    if (res.size() <= 5) continue;
                    res.removeLast();
                }
            }
            Graphics2D g1 = (Graphics2D)img1.getGraphics();
            g1.setColor(Color.red);
            Graphics2D g2 = (Graphics2D)img2.getGraphics();
            g2.setColor(Color.red);
            for (Found found : res) {
                System.out.print("f1 = " + found.f1);
                System.out.print(" / f2 = " + found.f2);
                System.out.println(" / d = " + found.d);
                SiftExtractor.drawSquare(g1, new double[]{found.f1.location[0] / this.scale, found.f1.location[1] / this.scale}, (double)this.fdsize * 1.0 * (double)found.f1.scale / (double)this.scale, found.f1.orientation);
                SiftExtractor.drawSquare(g2, new double[]{found.f2.location[0] / this.scale, found.f2.location[1] / this.scale}, (double)this.fdsize * 1.0 * (double)found.f2.scale / (double)this.scale, found.f2.orientation);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        SiftExtractor e = new SiftExtractor();
        e.align(ImageIO.read(new File("c:/temp/image001.png")), ImageIO.read(new File("c:/temp/image002.png")));
    }

    @Override
    public void extract(BufferedImage image) {
        try {
            this.features = this.computeSiftFeatures(image);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<? extends LocalFeature> getFeatures() {
        return this.features;
    }

    @Override
    public Class<? extends LocalFeature> getClassOfFeatures() {
        return SiftFeature.class;
    }

    public List<SiftFeature> computeSiftFeatures(BufferedImage img) throws IOException {
        LinkedList<SiftFeature> fs2 = new LinkedList<SiftFeature>();
        FloatArray2DSIFT sift = new FloatArray2DSIFT(this.fdsize, this.fdbins);
        FloatArray2D fa = ImageArrayConverter.ImageToFloatArray2D(img);
        Filter.enhance(fa, 1.0f);
        sift.init(fa, this.steps, this.initial_sigma, this.min_size, this.max_size);
        fs2.addAll(sift.run(this.max_size));
        Collections.sort(fs2);
        return fs2;
    }

    static void drawSquare(Graphics2D ip, double[] o, double scale, double orient) {
        double sin = Math.sin(orient);
        double cos = Math.cos(orient);
        int[] x = new int[6];
        int[] y = new int[6];
        x[0] = (int)(o[0] + (sin - cos) * (scale /= 2.0));
        y[0] = (int)(o[1] - (sin + cos) * scale);
        x[1] = (int)o[0];
        y[1] = (int)o[1];
        x[2] = (int)(o[0] + (sin + cos) * scale);
        y[2] = (int)(o[1] + (sin - cos) * scale);
        x[3] = (int)(o[0] - (sin - cos) * scale);
        y[3] = (int)(o[1] + (sin + cos) * scale);
        x[4] = (int)(o[0] - (sin + cos) * scale);
        y[4] = (int)(o[1] - (sin - cos) * scale);
        x[5] = x[0];
        y[5] = y[0];
        ip.drawPolygon(new Polygon(x, y, x.length));
    }
}

