/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.sift;

import java.io.Serializable;
import java.util.logging.Logger;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeatureExtractor;
import net.semanticmetadata.lire.imageanalysis.features.local.sift.SiftExtractor;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class SiftFeature
implements Comparable<SiftFeature>,
Serializable,
LocalFeature {
    private static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    public float scale;
    public float orientation;
    public float[] location;
    double[] descriptor;

    public SiftFeature() {
    }

    public SiftFeature(float s, float o, float[] l, float[] d) {
        this.scale = s;
        this.orientation = o;
        this.location = l;
        this.descriptor = SerializationUtils.toDoubleArray(d);
    }

    @Override
    public int compareTo(SiftFeature f) {
        return this.scale < f.scale ? 1 : (this.scale == f.scale ? 0 : -1);
    }

    public void toRootSIFT() {
        int i;
        double max = 0.0;
        for (i = 0; i < this.descriptor.length; ++i) {
            max = Math.max(max, Math.abs(this.descriptor[i]));
        }
        for (i = 0; i < this.descriptor.length; ++i) {
            this.descriptor[i] = Math.sqrt(Math.abs(this.descriptor[i]) / max);
        }
    }

    public float descriptorDistance(SiftFeature f) {
        if (!(f instanceof SiftFeature)) {
            return -1.0f;
        }
        return (float)MetricsUtils.distL2(this.descriptor, f.descriptor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.descriptor.length; ++i) {
            sb.append(this.descriptor[i]);
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    public double getDistance(LireFeature feature) {
        if (feature instanceof SiftFeature) {
            return this.descriptorDistance((SiftFeature)feature);
        }
        return -1.0;
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        int j;
        byte[] result = new byte[this.descriptor.length * 4 + 16];
        byte[] tmp = SerializationUtils.toBytes(this.scale);
        for (j = 0; j < 4; ++j) {
            result[j] = tmp[j];
        }
        tmp = SerializationUtils.toBytes(this.orientation);
        for (j = 0; j < 4; ++j) {
            result[4 + j] = tmp[j];
        }
        tmp = SerializationUtils.toBytes(this.location[0]);
        for (j = 0; j < 4; ++j) {
            result[8 + j] = tmp[j];
        }
        tmp = SerializationUtils.toBytes(this.location[1]);
        for (j = 0; j < 4; ++j) {
            result[12 + j] = tmp[j];
        }
        for (int i = 16; i < result.length; i += 4) {
            tmp = SerializationUtils.toBytes(this.descriptor[(i - 16) / 4]);
            for (int j2 = 0; j2 < 4; ++j2) {
                result[i + j2] = tmp[j2];
            }
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        byte[] tmp = new byte[4];
        this.descriptor = new double[in.length / 4 - 4];
        this.location = new float[2];
        System.arraycopy(in, 0, tmp, 0, 4);
        this.scale = SerializationUtils.toFloat(tmp);
        System.arraycopy(in, 4, tmp, 0, 4);
        this.orientation = SerializationUtils.toFloat(tmp);
        System.arraycopy(in, 8, tmp, 0, 4);
        this.location[0] = SerializationUtils.toFloat(tmp);
        System.arraycopy(in, 12, tmp, 0, 4);
        this.location[1] = SerializationUtils.toFloat(tmp);
        for (int i = 0; i < this.descriptor.length; ++i) {
            System.arraycopy(in, 16 + i * 4, tmp, 0, 4);
            this.descriptor[i] = SerializationUtils.toFloat(tmp);
        }
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        byte[] tmp = new byte[4];
        this.descriptor = new double[length / 4 - 4];
        this.location = new float[2];
        System.arraycopy(in, offset, tmp, 0, 4);
        this.scale = SerializationUtils.toFloat(tmp);
        System.arraycopy(in, offset + 4, tmp, 0, 4);
        this.orientation = SerializationUtils.toFloat(tmp);
        System.arraycopy(in, offset + 8, tmp, 0, 4);
        this.location[0] = SerializationUtils.toFloat(tmp);
        System.arraycopy(in, offset + 12, tmp, 0, 4);
        this.location[1] = SerializationUtils.toFloat(tmp);
        for (int i = 0; i < this.descriptor.length; ++i) {
            System.arraycopy(in, offset + 16 + i * 4, tmp, 0, 4);
            this.descriptor[i] = SerializationUtils.toFloat(tmp);
        }
    }

    @Override
    public double[] getFeatureVector() {
        double[] result = new double[this.descriptor.length];
        for (int i = 0; i < this.descriptor.length; ++i) {
            result[i] = this.descriptor[i];
        }
        return result;
    }

    @Override
    public String getFeatureName() {
        return "SIFT";
    }

    @Override
    public String getFieldName() {
        return "SIFT";
    }

    @Override
    public double getX() {
        return this.location[0];
    }

    @Override
    public double getY() {
        return this.location[1];
    }

    @Override
    public double getSize() {
        return this.scale;
    }

    public Class<? extends LocalFeatureExtractor> getClassOfExtractor() {
        return SiftExtractor.class;
    }
}

