/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.sift;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.semanticmetadata.lire.imageanalysis.features.local.sift.Model;
import net.semanticmetadata.lire.imageanalysis.features.local.sift.PointMatch;
import net.semanticmetadata.lire.imageanalysis.features.local.sift.TRModel2D;

public class TModel2D
extends Model {
    public static final int MIN_SET_SIZE = 1;
    private final AffineTransform affine = new AffineTransform();

    @Override
    public AffineTransform getAffine() {
        return this.affine;
    }

    @Override
    public float[] apply(float[] point) {
        float[] transformed = new float[2];
        this.affine.transform(point, 0, transformed, 0, 1);
        return transformed;
    }

    @Override
    public void applyInPlace(float[] point) {
        this.affine.transform(point, 0, point, 0, 1);
    }

    @Override
    public float[] applyInverse(float[] point) {
        double[] double_point = new double[]{point[0], point[1]};
        double[] transformed = new double[2];
        try {
            this.affine.inverseTransform(double_point, 0, transformed, 0, 1);
        }
        catch (Exception e) {
            System.err.println("Noninvertible transformation.");
        }
        return new float[]{(float)transformed[0], (float)transformed[1]};
    }

    @Override
    public void applyInverseInPlace(float[] point) {
        float[] temp_point = this.applyInverse(point);
        point[0] = temp_point[0];
        point[1] = temp_point[1];
    }

    @Override
    public boolean fit(PointMatch[] min_matches) {
        PointMatch m1 = min_matches[0];
        float[] m1_p1 = m1.getP1().getL();
        float[] m1_p2 = m1.getP2().getL();
        float tx = m1_p1[0] - m1_p2[0];
        float ty = m1_p1[1] - m1_p2[1];
        this.affine.setToIdentity();
        this.affine.translate(tx, ty);
        return true;
    }

    @Override
    public String toString() {
        return "[3,3](" + this.affine + ") " + this.error;
    }

    @Override
    public void minimize(Collection<PointMatch> matches) {
        float xo1 = 0.0f;
        float yo1 = 0.0f;
        float xo2 = 0.0f;
        float yo2 = 0.0f;
        int length = matches.size();
        for (PointMatch m : matches) {
            float[] m_p1 = m.getP1().getL();
            float[] m_p2 = m.getP2().getW();
            xo1 += m_p1[0];
            yo1 += m_p1[1];
            xo2 += m_p2[0];
            yo2 += m_p2[1];
        }
        float dx = (xo1 /= (float)length) - (xo2 /= (float)length);
        float dy = (yo1 /= (float)length) - (yo2 /= (float)length);
        this.affine.setToIdentity();
        this.affine.translate(-dx, -dy);
    }

    @Override
    public final void shake(Collection<PointMatch> matches, float scale, float[] center) {
        double xd = 0.0;
        double yd = 0.0;
        int num_matches = matches.size();
        if (num_matches > 0) {
            for (PointMatch m : matches) {
                float[] m_p1 = m.getP1().getW();
                float[] m_p2 = m.getP2().getW();
                xd += (double)Math.abs(m_p1[0] - m_p2[0]);
                yd += (double)Math.abs(m_p1[1] - m_p2[1]);
            }
            xd /= (double)matches.size();
            yd /= (double)matches.size();
        }
        this.affine.translate(rnd.nextGaussian() * (double)((float)xd) * (double)scale, rnd.nextGaussian() * (double)((float)yd));
    }

    public static TModel2D estimateModel(List<PointMatch> candidates, Collection<PointMatch> inliers, int iterations, float epsilon, float min_inliers) {
        inliers.clear();
        if (candidates.size() < 1) {
            System.err.println(candidates.size() + " correspondences are not enough to estimate a model, at least " + 1 + " correspondences required.");
            return null;
        }
        TModel2D model = new TModel2D();
        for (int i = 0; i < iterations; ++i) {
            PointMatch[] min_matches = new PointMatch[]{candidates.get((int)(rnd.nextDouble() * (double)candidates.size()))};
            TModel2D m = new TModel2D();
            ArrayList<PointMatch> temp_inliers = new ArrayList<PointMatch>();
            m.fit(min_matches);
            int num_inliers = 0;
            boolean is_good = m.test(candidates, temp_inliers, epsilon, min_inliers);
            while (is_good && num_inliers < temp_inliers.size()) {
                num_inliers = temp_inliers.size();
                m.minimize(temp_inliers);
                is_good = m.test(candidates, temp_inliers, epsilon, min_inliers);
            }
            if (!is_good || !m.betterThan(model) || temp_inliers.size() < 3) continue;
            model = m.clone();
            inliers.clear();
            inliers.addAll(temp_inliers);
        }
        if (inliers.size() == 0) {
            return null;
        }
        return model;
    }

    public static TModel2D estimateBestModel(List<PointMatch> candidates, Collection<PointMatch> inliers, float min_epsilon, float max_epsilon, float min_inlier_ratio) {
        inliers.clear();
        TModel2D model = null;
        float epsilon = 0.0f;
        if (candidates.size() > 1) {
            int highest_num_inliers = 0;
            int convergence_count = 0;
            TModel2D m = null;
            do {
                ArrayList<PointMatch> temp_inliers;
                if ((m = TModel2D.estimateModel(candidates, temp_inliers = new ArrayList<PointMatch>(), 1000, epsilon += min_epsilon, min_inlier_ratio)) == null) continue;
                int num_inliers = temp_inliers.size();
                if (num_inliers <= highest_num_inliers) {
                    ++convergence_count;
                    continue;
                }
                model = m.clone();
                inliers.clear();
                inliers.addAll(temp_inliers);
                convergence_count = 0;
                highest_num_inliers = num_inliers;
            } while ((m == null || convergence_count < 4) && epsilon < max_epsilon);
        }
        if (model == null) {
            // empty if block
        }
        return model;
    }

    @Override
    public TModel2D clone() {
        TModel2D tm = new TModel2D();
        tm.affine.setTransform(this.affine);
        tm.error = this.error;
        return tm;
    }

    public TRModel2D toTRModel2D() {
        TRModel2D trm = new TRModel2D();
        trm.getAffine().setTransform(this.affine);
        trm.error = this.error;
        return trm;
    }
}

