/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.sift;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.semanticmetadata.lire.imageanalysis.features.local.sift.Model;
import net.semanticmetadata.lire.imageanalysis.features.local.sift.PointMatch;

public class TRModel2D
extends Model {
    public static final int MIN_SET_SIZE = 2;
    private final AffineTransform affine = new AffineTransform();

    @Override
    public AffineTransform getAffine() {
        return this.affine;
    }

    @Override
    public float[] apply(float[] point) {
        float[] transformed = new float[2];
        this.affine.transform(point, 0, transformed, 0, 1);
        return transformed;
    }

    @Override
    public void applyInPlace(float[] point) {
        this.affine.transform(point, 0, point, 0, 1);
    }

    @Override
    public float[] applyInverse(float[] point) {
        double[] double_point = new double[]{point[0], point[1]};
        double[] transformed = new double[2];
        try {
            this.affine.inverseTransform(double_point, 0, transformed, 0, 1);
        }
        catch (Exception e) {
            System.err.println("Noninvertible transformation.");
        }
        return new float[]{(float)transformed[0], (float)transformed[1]};
    }

    @Override
    public void applyInverseInPlace(float[] point) {
        float[] temp_point = this.applyInverse(point);
        point[0] = temp_point[0];
        point[1] = temp_point[1];
    }

    @Override
    public boolean fit(PointMatch[] min_matches) {
        PointMatch m1 = min_matches[0];
        PointMatch m2 = min_matches[1];
        float[] m1_p1 = m1.getP1().getL();
        float[] m2_p1 = m2.getP1().getL();
        float[] m1_p2 = m1.getP2().getW();
        float[] m2_p2 = m2.getP2().getW();
        float x1 = m2_p1[0] - m1_p1[0];
        float y1 = m2_p1[1] - m1_p1[1];
        float x2 = m2_p2[0] - m1_p2[0];
        float y2 = m2_p2[1] - m1_p2[1];
        float l1 = (float)Math.sqrt(x1 * x1 + y1 * y1);
        float l2 = (float)Math.sqrt(x2 * x2 + y2 * y2);
        float cos = (x1 /= l1) * (x2 /= l2) + (y1 /= l1) * (y2 /= l2);
        float sin = x1 * y2 - y1 * x2;
        float tx = m1_p2[0] - cos * m1_p1[0] + sin * m1_p1[1];
        float ty = m1_p2[1] - sin * m1_p1[0] - cos * m1_p1[1];
        this.affine.setTransform(cos, sin, -sin, cos, tx, ty);
        return true;
    }

    @Override
    public String toString() {
        return "[3,3](" + this.affine + ") " + this.error;
    }

    @Override
    public void minimize(Collection<PointMatch> matches) {
        float xo1 = 0.0f;
        float yo1 = 0.0f;
        float xo2 = 0.0f;
        float yo2 = 0.0f;
        int length = matches.size();
        if (0 == length) {
            return;
        }
        for (PointMatch m : matches) {
            float[] m_p1 = m.getP1().getL();
            float[] m_p2 = m.getP2().getW();
            xo1 += m_p1[0];
            yo1 += m_p1[1];
            xo2 += m_p2[0];
            yo2 += m_p2[1];
        }
        float dx = (xo1 /= (float)length) - (xo2 /= (float)length);
        float dy = (yo1 /= (float)length) - (yo2 /= (float)length);
        float sum1 = 0.0f;
        float sum2 = 0.0f;
        for (PointMatch m : matches) {
            float[] m_p1 = m.getP1().getL();
            float[] m_p2 = m.getP2().getW();
            float x1 = m_p1[0] - xo1;
            float y1 = m_p1[1] - yo1;
            float x2 = m_p2[0] - xo2 + dx;
            float y2 = m_p2[1] - yo2 + dy;
            sum1 += x1 * y2 - y1 * x2;
            sum2 += x1 * x2 + y1 * y2;
        }
        float angle = (float)Math.atan2(-sum1, sum2);
        this.affine.setToIdentity();
        this.affine.rotate(-angle, xo2, yo2);
        this.affine.translate(-dx, -dy);
    }

    @Override
    public final void shake(Collection<PointMatch> matches, float scale, float[] center) {
        double xd = 0.0;
        double yd = 0.0;
        double rd = 0.0;
        int num_matches = matches.size();
        if (num_matches > 0) {
            for (PointMatch m : matches) {
                float[] m_p1 = m.getP1().getW();
                float[] m_p2 = m.getP2().getW();
                xd += (double)Math.abs(m_p1[0] - m_p2[0]);
                yd += (double)Math.abs(m_p1[1] - m_p2[1]);
                float x1 = m_p1[0] - center[0];
                float y1 = m_p1[1] - center[1];
                float x2 = m_p2[0] - center[0];
                float y2 = m_p2[1] - center[1];
                float l1 = (float)Math.sqrt(x1 * x1 + y1 * y1);
                float l2 = (float)Math.sqrt(x2 * x2 + y2 * y2);
                float cos = (x1 /= l1) * (x2 /= l2) + (y1 /= l1) * (y2 /= l2);
                float sin = y1 * x2 - x1 * y2;
                rd += Math.abs(Math.atan2(sin, cos));
            }
            xd /= (double)matches.size();
            yd /= (double)matches.size();
            rd /= (double)matches.size();
        }
        this.affine.rotate(rnd.nextGaussian() * (double)((float)rd) * (double)scale, center[0], center[1]);
    }

    public static TRModel2D estimateModel(List<PointMatch> candidates, Collection<PointMatch> inliers, int iterations, float epsilon, float min_inlier_ratio) {
        inliers.clear();
        if (candidates.size() < 2) {
            System.err.println(candidates.size() + " correspondence candidates are not enough to estimate a model, at least " + 2 + " required.");
            return null;
        }
        TRModel2D model = new TRModel2D();
        for (int i = 0; i < iterations; ++i) {
            PointMatch[] min_matches = new PointMatch[2];
            int[] keys = new int[2];
            for (int j = 0; j < 2; ++j) {
                int key;
                boolean in_set = false;
                block2: do {
                    key = (int)(rnd.nextDouble() * (double)candidates.size());
                    in_set = false;
                    for (int k = 0; k < j; ++k) {
                        if (key != keys[k]) continue;
                        in_set = true;
                        continue block2;
                    }
                } while (in_set);
                keys[j] = key;
                min_matches[j] = candidates.get(key);
            }
            TRModel2D m = new TRModel2D();
            ArrayList<PointMatch> temp_inliers = new ArrayList<PointMatch>();
            m.fit(min_matches);
            int num_inliers = 0;
            boolean is_good = m.test(candidates, temp_inliers, epsilon, min_inlier_ratio);
            while (is_good && num_inliers < temp_inliers.size()) {
                num_inliers = temp_inliers.size();
                m.minimize(temp_inliers);
                is_good = m.test(candidates, temp_inliers, epsilon, min_inlier_ratio);
            }
            if (!is_good || !m.betterThan(model) || temp_inliers.size() < 6) continue;
            model = m.clone();
            inliers.clear();
            inliers.addAll(temp_inliers);
        }
        if (inliers.size() == 0) {
            return null;
        }
        return model;
    }

    public static TRModel2D estimateBestModel(List<PointMatch> candidates, Collection<PointMatch> inliers, float min_epsilon, float max_epsilon, float min_inlier_ratio) {
        inliers.clear();
        TRModel2D model = null;
        float epsilon = 0.0f;
        if (candidates.size() > 2) {
            int highest_num_inliers = 0;
            int convergence_count = 0;
            TRModel2D m = null;
            do {
                ArrayList<PointMatch> temp_inliers;
                if ((m = TRModel2D.estimateModel(candidates, temp_inliers = new ArrayList<PointMatch>(), 1000, epsilon += min_epsilon, min_inlier_ratio)) == null) continue;
                int num_inliers = temp_inliers.size();
                if (num_inliers <= highest_num_inliers) {
                    ++convergence_count;
                    continue;
                }
                model = m.clone();
                inliers.clear();
                inliers.addAll(temp_inliers);
                convergence_count = 0;
                highest_num_inliers = num_inliers;
            } while ((m == null || convergence_count < 4) && epsilon < max_epsilon);
        }
        if (model == null) {
            // empty if block
        }
        return model;
    }

    @Override
    public TRModel2D clone() {
        TRModel2D trm = new TRModel2D();
        trm.affine.setTransform(this.affine);
        trm.error = this.error;
        return trm;
    }

    public void preConcatenate(TRModel2D model) {
        this.affine.preConcatenate(model.affine);
    }

    public void concatenate(TRModel2D model) {
        this.affine.concatenate(model.affine);
    }
}

