/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.simple;

import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeatureExtractor;
import net.semanticmetadata.lire.imageanalysis.features.local.opencvfeatures.CvSiftExtractor;
import net.semanticmetadata.lire.imageanalysis.features.local.opencvfeatures.CvSiftFeature;
import net.semanticmetadata.lire.imageanalysis.features.local.opencvfeatures.CvSurfExtractor;
import net.semanticmetadata.lire.imageanalysis.features.local.opencvfeatures.CvSurfFeature;
import net.semanticmetadata.lire.imageanalysis.features.local.simple.SimpleFeature;
import net.semanticmetadata.lire.utils.ImageUtils;

public class SimpleExtractor
implements LocalFeatureExtractor {
    private static final String Detector_CVSURF = "detCVSURF";
    private static final String Detector_CVSIFT = "detCVSIFT";
    private static final String Detector_RANDOM = "detRnd";
    private static final String Detector_GAUSSRANDOM = "detGRnd";
    private final int[] sizeLookUp = new int[]{40, 64, 92, 120};
    private String fieldName;
    private String featureName;
    private Class<? extends GlobalFeature> globalFeatureClass;
    private GlobalFeature globalFeature;
    private KeypointDetector kpdetector;
    private int samplePoints = 600;
    private CvSurfExtractor cvSurfExtractor;
    private CvSiftExtractor cvSiftExtractor;
    LinkedList<SimpleFeature> listOfFeatures;

    public SimpleExtractor(GlobalFeature globalFeature, KeypointDetector detector) {
        this.init(globalFeature, detector);
    }

    public SimpleExtractor(GlobalFeature globalFeature, KeypointDetector detector, int numberOfKeypoints) {
        this.samplePoints = numberOfKeypoints;
        this.init(globalFeature, detector);
    }

    private void init(GlobalFeature globalFeature, KeypointDetector detector) {
        this.globalFeature = globalFeature;
        this.globalFeatureClass = globalFeature.getClass();
        this.kpdetector = detector;
        this.fieldName = "SIMPLE" + SimpleExtractor.getDetector(this.kpdetector) + this.globalFeature.getFieldName();
        if (this.kpdetector == KeypointDetector.CVSURF) {
            this.cvSurfExtractor = new CvSurfExtractor();
            this.featureName = "SIMPLE using " + globalFeature.getFeatureName() + " and the CVSURF Detector";
        } else if (this.kpdetector == KeypointDetector.CVSIFT) {
            this.cvSiftExtractor = new CvSiftExtractor();
            this.featureName = "SIMPLE using " + globalFeature.getFeatureName() + " and the CVSIFT Detector";
        } else if (this.kpdetector == KeypointDetector.Random) {
            this.featureName = "SIMPLE using " + globalFeature.getFeatureName() + " and a Random keypoint Detector";
        } else if (this.kpdetector == KeypointDetector.GaussRandom) {
            this.featureName = "SIMPLE using " + globalFeature.getFeatureName() + " and a GaussRandom keypoint Detector";
        } else {
            throw new UnsupportedOperationException("Something was wrong in setting the desired detector");
        }
    }

    @Override
    public List<? extends LocalFeature> getFeatures() {
        return this.listOfFeatures;
    }

    @Override
    public Class<? extends LocalFeature> getClassOfFeatures() {
        return SimpleFeature.class;
    }

    public Class<? extends GlobalFeature> getGlobalFeatureClass() {
        return this.globalFeatureClass;
    }

    public KeypointDetector getKpdetector() {
        return this.kpdetector;
    }

    @Override
    public void extract(BufferedImage image) {
        if (this.kpdetector == KeypointDetector.CVSURF) {
            this.useCVSURF(image);
        } else if (this.kpdetector == KeypointDetector.CVSIFT) {
            this.useCVSIFT(image);
        } else if (this.kpdetector == KeypointDetector.Random) {
            this.useRandom(image);
        } else if (this.kpdetector == KeypointDetector.GaussRandom) {
            this.useGaussRandom(image);
        } else {
            throw new UnsupportedOperationException("Something was wrong in setting the desired detector");
        }
    }

    private void useCVSURF(BufferedImage image) {
        this.listOfFeatures = new LinkedList();
        LinkedList<CvSurfFeature> surfKeypoints = this.cvSurfExtractor.computeSurfKeypoints(image);
        for (CvSurfFeature keypoint2 : surfKeypoints) {
            this.globalFeature.extract(ImageUtils.cropImage(image, (int)(keypoint2.getX() - (double)((int)keypoint2.getSize() / 2)), (int)(keypoint2.getY() - (double)((int)keypoint2.getSize() / 2)), (int)keypoint2.getSize(), (int)keypoint2.getSize()));
            this.listOfFeatures.add(new SimpleFeature(this.globalFeature.getFeatureVector(), keypoint2.getX(), keypoint2.getY(), keypoint2.getSize(), this.fieldName, this.featureName, this.globalFeatureClass));
        }
    }

    private void useCVSIFT(BufferedImage image) {
        this.listOfFeatures = new LinkedList();
        LinkedList<CvSiftFeature> cvSiftFeatures = this.cvSiftExtractor.computeSiftKeypoints(image);
        for (CvSiftFeature cvSiftFeature : cvSiftFeatures) {
            this.globalFeature.extract(ImageUtils.cropImage(image, (int)(cvSiftFeature.getX() - (double)((int)cvSiftFeature.getSize() / 2)), (int)(cvSiftFeature.getY() - (double)((int)cvSiftFeature.getSize() / 2)), (int)cvSiftFeature.getSize(), (int)cvSiftFeature.getSize()));
            this.listOfFeatures.add(new SimpleFeature(this.globalFeature.getFeatureVector(), cvSiftFeature.getX(), cvSiftFeature.getY(), cvSiftFeature.getSize(), this.fieldName, this.featureName, this.globalFeatureClass));
        }
    }

    private void useRandom(BufferedImage image) {
        this.listOfFeatures = new LinkedList();
        int[] myKeypoint = new int[3];
        Random r = new Random();
        for (int i = 0; i < this.samplePoints; ++i) {
            this.createNextRandomPoint(myKeypoint, image.getWidth(), image.getHeight(), r);
            this.globalFeature.extract(ImageUtils.cropImage(image, myKeypoint[0], myKeypoint[1], myKeypoint[2], myKeypoint[2]));
            this.listOfFeatures.add(new SimpleFeature(this.globalFeature.getFeatureVector(), myKeypoint[0], myKeypoint[1], myKeypoint[2], this.fieldName, this.featureName, this.globalFeatureClass));
        }
    }

    private void useGaussRandom(BufferedImage image) {
        this.listOfFeatures = new LinkedList();
        LinkedList<keypoint> keypointsList = this.createGaussRndPts(image.getWidth(), image.getHeight(), this.samplePoints);
        for (keypoint kpoint : keypointsList) {
            this.globalFeature.extract(ImageUtils.cropImage(image, kpoint.X - kpoint.Size / 2, kpoint.Y - kpoint.Size / 2, kpoint.Size, kpoint.Size));
            this.listOfFeatures.add(new SimpleFeature(this.globalFeature.getFeatureVector(), kpoint.getX() - kpoint.getSize() / 2, kpoint.getY() - kpoint.getSize() / 2, kpoint.getSize(), this.fieldName, this.featureName, this.globalFeatureClass));
        }
    }

    private void createNextRandomPoint(int[] myKeypoint, int width, int height, Random random) {
        myKeypoint[2] = this.sizeLookUp[random.nextInt(4)];
        if (myKeypoint[2] >= width || myKeypoint[2] >= height) {
            myKeypoint[2] = this.sizeLookUp[0];
        }
        myKeypoint[0] = random.nextInt(width - myKeypoint[2]);
        myKeypoint[1] = random.nextInt(height - myKeypoint[2]);
    }

    private LinkedList<keypoint> createGaussRndPts(int width, int height, int samples) {
        Random ran = new Random();
        double seedWidth = width / 4 - 10;
        double seedHeight = height / 4 - 10;
        double meanWidth = width / 2;
        double meanHeight = height / 2;
        LinkedList<keypoint> keypointsList = new LinkedList<keypoint>();
        for (int i = 0; i < samples; ++i) {
            int y;
            int x;
            int size = this.sizeLookUp[ran.nextInt(4)];
            int sizeLimit = size / 2;
            int widthLimit = width - sizeLimit;
            int heightLimit = height - sizeLimit;
            while ((x = (int)(ran.nextGaussian() * seedWidth + meanWidth)) <= sizeLimit || x >= widthLimit) {
            }
            while ((y = (int)(ran.nextGaussian() * seedHeight + meanHeight)) <= sizeLimit || y >= heightLimit) {
            }
            keypoint key = new keypoint(x, y, size);
            keypointsList.add(key);
        }
        return keypointsList;
    }

    public static String getDetector(KeypointDetector detector) {
        if (detector == KeypointDetector.CVSURF) {
            return Detector_CVSURF;
        }
        if (detector == KeypointDetector.CVSIFT) {
            return Detector_CVSIFT;
        }
        if (detector == KeypointDetector.Random) {
            return Detector_RANDOM;
        }
        if (detector == KeypointDetector.GaussRandom) {
            return Detector_GAUSSRANDOM;
        }
        throw new UnsupportedOperationException("Something was wrong in returning the used detector");
    }

    public static KeypointDetector getDetector(String detector) {
        if (detector.equals(Detector_CVSURF)) {
            return KeypointDetector.CVSURF;
        }
        if (detector.equals(Detector_CVSIFT)) {
            return KeypointDetector.CVSIFT;
        }
        if (detector.equals(Detector_RANDOM)) {
            return KeypointDetector.Random;
        }
        if (detector.equals(Detector_GAUSSRANDOM)) {
            return KeypointDetector.GaussRandom;
        }
        throw new UnsupportedOperationException("Something was wrong in returning the used detector");
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    private class keypoint {
        private int X;
        private int Y;
        private int Size;

        public keypoint(int x, int y, int size) {
            this.X = x;
            this.Y = y;
            this.Size = size;
        }

        public int getSize() {
            return this.Size;
        }

        public int getX() {
            return this.X;
        }

        public int getY() {
            return this.Y;
        }
    }

    public static enum KeypointDetector {
        CVSURF,
        CVSIFT,
        Random,
        GaussRandom;

    }
}

