/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.simple;

import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class SimpleFeature
implements LocalFeature {
    double[] data = null;
    private double X = -1.0;
    private double Y = -1.0;
    private double size = -1.0;
    private String featureName = "GenericSimpleFeature";
    private String fieldName = "GenericSF";
    private Class<? extends GlobalFeature> ExtractorClass;

    public SimpleFeature() {
    }

    public SimpleFeature(double[] data, double x, double y, double size, String fieldName, String featureName, Class<? extends GlobalFeature> ExtractorClass) {
        this.data = data;
        this.X = x;
        this.Y = y;
        this.size = size;
        this.featureName = featureName;
        this.fieldName = fieldName;
        this.ExtractorClass = ExtractorClass;
    }

    @Override
    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        if (this.data == null) {
            throw new UnsupportedOperationException("You need to set the histogram first.");
        }
        return SerializationUtils.toByteArray(this.data);
    }

    @Override
    public void setByteArrayRepresentation(byte[] featureData) {
        this.setByteArrayRepresentation(featureData, 0, featureData.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] featureData, int offset, int length) {
        this.data = SerializationUtils.toDoubleArray(featureData, offset, length);
    }

    @Override
    public double[] getFeatureVector() {
        return this.data;
    }

    @Override
    public double getDistance(LireFeature feature) {
        assert (feature.getFeatureVector().length == this.data.length);
        return MetricsUtils.distL2(feature.getFeatureVector(), this.data);
    }

    @Override
    public double getX() {
        return this.X;
    }

    @Override
    public double getY() {
        return this.Y;
    }

    @Override
    public double getSize() {
        return this.size;
    }

    public Class<? extends GlobalFeature> getClassOfExtractor() {
        return this.ExtractorClass;
    }
}

