/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.local.surf;

import com.stromberglabs.jopensurf.SURFInterestPoint;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.imageanalysis.features.local.surf.SurfExtractor;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class SurfFeature
implements LocalFeature {
    private double X = -1.0;
    private double Y = -1.0;
    private double size = -1.0;
    private double[] feature = null;

    public SurfFeature(SURFInterestPoint surfInterestPoint) {
        this.X = surfInterestPoint.getX();
        this.Y = surfInterestPoint.getY();
        this.size = surfInterestPoint.getScale();
        this.feature = SerializationUtils.toDoubleArray(surfInterestPoint.getDescriptor());
    }

    public SurfFeature() {
    }

    @Override
    public double getDistance(LireFeature f) {
        if (!(f instanceof SurfFeature)) {
            return -1.0;
        }
        return MetricsUtils.distL2(this.feature, ((SurfFeature)f).feature);
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        return SerializationUtils.toByteArray(this.feature);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.feature = SerializationUtils.toDoubleArray(in);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        this.feature = SerializationUtils.toDoubleArray(in, offset, length);
    }

    @Override
    public double[] getFeatureVector() {
        return this.feature;
    }

    @Override
    public String getFeatureName() {
        return "SURF";
    }

    @Override
    public String getFieldName() {
        return "SURF";
    }

    @Override
    public double getX() {
        return this.X;
    }

    @Override
    public double getY() {
        return this.Y;
    }

    @Override
    public double getSize() {
        return this.size;
    }

    @Override
    public Class<?> getClassOfExtractor() {
        return SurfExtractor.class;
    }
}

