/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.indexers.hashing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class LocalitySensitiveHashing {
    private static String name = "lshHashFunctions.obj";
    private static int dimensions = 250;
    public static int numFunctionBundles = 50;
    public static double binLength = 10.0;
    private static double[][] hashA = null;
    private static double[] hashB = null;
    private static double dilation = 1.0;

    public static void generateHashFunctions() throws IOException {
        File hashFile = new File(name);
        if (!hashFile.exists()) {
            int c;
            ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(hashFile)));
            oos.writeInt(dimensions);
            oos.writeInt(numFunctionBundles);
            for (c = 0; c < numFunctionBundles; ++c) {
                oos.writeFloat((float)(Math.random() * binLength));
            }
            for (c = 0; c < numFunctionBundles; ++c) {
                for (int j = 0; j < dimensions; ++j) {
                    oos.writeFloat((float)(LocalitySensitiveHashing.drawNumber() * dilation));
                }
            }
            oos.close();
        } else {
            System.err.println("Hashes could not be written: " + name + " already exists");
        }
    }

    public static void generateHashFunctions(String name) throws IOException {
        File hashFile = new File(name);
        if (!hashFile.exists()) {
            int c;
            ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(hashFile)));
            oos.writeInt(dimensions);
            oos.writeInt(numFunctionBundles);
            for (c = 0; c < numFunctionBundles; ++c) {
                oos.writeFloat((float)(Math.random() * binLength));
            }
            for (c = 0; c < numFunctionBundles; ++c) {
                for (int j = 0; j < dimensions; ++j) {
                    oos.writeFloat((float)(LocalitySensitiveHashing.drawNumber() * dilation));
                }
            }
            oos.close();
        } else {
            System.err.println("Hashes could not be written: " + name + " already exists");
        }
    }

    public static double[][] readHashFunctions() throws IOException {
        return LocalitySensitiveHashing.readHashFunctions(new FileInputStream(name));
    }

    public static double[][] readHashFunctions(InputStream in) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(in));
        dimensions = ois.readInt();
        numFunctionBundles = ois.readInt();
        double[] tmpB = new double[numFunctionBundles];
        for (int k = 0; k < numFunctionBundles; ++k) {
            tmpB[k] = ois.readFloat();
        }
        hashB = tmpB;
        double[][] hashFunctions = new double[numFunctionBundles][dimensions];
        for (int i = 0; i < hashFunctions.length; ++i) {
            double[] functionBundle = hashFunctions[i];
            for (int j = 0; j < functionBundle.length; ++j) {
                functionBundle[j] = ois.readFloat();
            }
        }
        hashA = hashFunctions;
        return hashFunctions;
    }

    public static int[] generateHashes(double[] histogram) {
        int[] result = new int[numFunctionBundles];
        for (int k = 0; k < numFunctionBundles; ++k) {
            double product = 0.0;
            for (int i = 0; i < histogram.length; ++i) {
                product += histogram[i] * hashA[k][i];
            }
            result[k] = (int)Math.floor((product + hashB[k]) / binLength);
        }
        return result;
    }

    private static double drawNumber() {
        double v;
        double u;
        double s;
        while ((s = (u = Math.random() * 2.0 - 1.0) * u + (v = Math.random() * 2.0 - 1.0) * v) == 0.0 || s >= 1.0) {
        }
        return u * Math.sqrt(-2.0 * Math.log(s) / s);
    }

    public static void main(String[] args) {
        try {
            LocalitySensitiveHashing.generateHashFunctions();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

