/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.indexers.hashing;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.global.CEDD;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;

public class MetricSpaces {
    static HashMap<String, ArrayList<GlobalFeature>> referencePoints = new HashMap();
    static HashMap<String, Parameters> parameters = new HashMap();

    public static void main(String[] args) {
        int numberOfReferencePoints = 500;
        int lenghtOfPostingList = 10;
        File inFile = null;
        File outFile = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-i")) {
                if (i + 1 < args.length) {
                    File f = new File(args[i + 1]);
                    if (!f.exists() || f.isDirectory()) {
                        MetricSpaces.printHelp();
                        System.err.println("Input file does not exist or is a directory.");
                        System.exit(1);
                        continue;
                    }
                    inFile = f;
                    continue;
                }
                MetricSpaces.printHelp();
                System.err.println("There is something wrong with your input file. Please check the parameters.");
                continue;
            }
            if (arg.startsWith("-p")) {
                if (i + 1 < args.length) {
                    String[] p = args[i + 1].split(",");
                    if (p.length < 2) {
                        System.err.println("There are too few parameters: -p " + args[i + 1]);
                        MetricSpaces.printHelp();
                        continue;
                    }
                    try {
                        numberOfReferencePoints = Integer.parseInt(p[0]);
                        lenghtOfPostingList = Integer.parseInt(p[1]);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("One of your parameters does not seem to be a number.");
                        e.printStackTrace();
                        MetricSpaces.printHelp();
                    }
                    continue;
                }
                System.err.println("There is something wrong with the parameters.");
                MetricSpaces.printHelp();
                continue;
            }
            if (!arg.startsWith("-h")) continue;
            MetricSpaces.printHelp();
        }
        if (inFile == null) {
            System.err.println("You did not give an input file.");
            MetricSpaces.printHelp();
            System.exit(1);
        }
        outFile = new File(FilenameUtils.removeExtension((String)inFile.getAbsolutePath()) + ".dat");
        System.out.printf("MetricSpaces operating on file %s with\n%d number of reference points and %d elements in the posting list.\n", inFile.getAbsolutePath(), numberOfReferencePoints, lenghtOfPostingList);
        if (outFile.exists()) {
            System.out.printf("NOTE: output file %s will be overwritten.\n", outFile.getAbsolutePath());
        } else {
            System.out.printf("Output will be saved in %s\n", outFile.getAbsolutePath());
        }
        try {
            try {
                MetricSpaces.indexReferencePoints(CEDD.class, numberOfReferencePoints, lenghtOfPostingList, inFile, outFile);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void indexReferencePoints(Class globalFeatureClass, int numberOfReferencePoints, int lenghtOfPostingList, File inFile, File outFile) throws IOException, IllegalAccessException, InstantiationException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(inFile));
        BufferedWriter bw = new BufferedWriter(new FileWriter(outFile));
        LinkedList<String> lines = new LinkedList<String>();
        System.out.println("Reading input file.");
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#") || line.trim().length() <= 1) continue;
            lines.add(line);
        }
        br.close();
        System.out.printf("Read %,d lines from the input file. Now selecting reference points.\n", lines.size());
        Collections.shuffle(lines);
        GlobalFeature feature = (GlobalFeature)globalFeatureClass.newInstance();
        bw.write(feature.getClass().getName() + "\n");
        bw.write(numberOfReferencePoints + "," + lenghtOfPostingList + "\n");
        System.out.print("Indexing ");
        int i = 0;
        Iterator iterator = lines.iterator();
        while (iterator.hasNext() && i < numberOfReferencePoints) {
            String file = (String)iterator.next();
            try {
                FileInputStream fis = new FileInputStream(file);
                feature.extract(ImageIO.read(fis));
                fis.close();
                bw.write(Base64.encodeBase64String((byte[])feature.getByteArrayRepresentation()) + "\n");
                if (++i % 100 != 0) continue;
                System.out.print('.');
            }
            catch (Exception e) {
                System.out.printf("Having problem \"%s\" with file %s\n", e.getMessage(), file);
            }
        }
        System.out.println();
        bw.close();
    }

    public static Parameters loadReferencePoints(File referencePoints) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        BufferedReader br = new BufferedReader(new FileReader(referencePoints));
        String feature = br.readLine().trim();
        Class<?> featureClass = Class.forName(feature);
        String[] params = br.readLine().trim().split(",");
        Parameters p = new Parameters();
        p.numberOfReferencePoints = Integer.parseInt(params[0]);
        p.lenghtOfPostingList = Integer.parseInt(params[1]);
        p.featureClass = featureClass;
        parameters.put(feature, p);
        ArrayList<GlobalFeature> ro = new ArrayList<GlobalFeature>(p.numberOfReferencePoints);
        String line = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#") || line.length() <= 1) continue;
            GlobalFeature f = (GlobalFeature)featureClass.newInstance();
            f.setByteArrayRepresentation(Base64.decodeBase64((String)line));
            ro.add(f);
        }
        MetricSpaces.referencePoints.put(feature, ro);
        br.close();
        return p;
    }

    public static boolean supportsFeature(GlobalFeature feature) {
        return referencePoints.get(feature.getClass().getName()) != null;
    }

    public static String generateHashString(GlobalFeature feature) {
        return MetricSpaces.generateHashString(feature, MetricSpaces.parameters.get((Object)feature.getClass().getName()).lenghtOfPostingList);
    }

    public static String generateHashString(GlobalFeature feature, int queryLength) {
        ArrayList<GlobalFeature> l = referencePoints.get(feature.getClass().getName());
        if (l == null) {
            return null;
        }
        int lenghtOfPostingList = Math.min(queryLength, MetricSpaces.parameters.get((Object)feature.getClass().getName()).lenghtOfPostingList);
        if (lenghtOfPostingList < 1) {
            lenghtOfPostingList = MetricSpaces.parameters.get((Object)feature.getClass().getName()).lenghtOfPostingList;
        }
        TreeSet<Result> results = new TreeSet<Result>();
        double maxDistance = Double.MAX_VALUE;
        int count = 0;
        for (GlobalFeature f : l) {
            double distance = f.getDistance(feature);
            if (results.size() < lenghtOfPostingList) {
                results.add(new Result(distance, count));
                maxDistance = l.get(((Result)results.last()).index).getDistance(feature);
            } else if (distance < maxDistance) {
                results.add(new Result(distance, count));
                maxDistance = distance;
                if (results.size() > lenghtOfPostingList) {
                    results.pollLast();
                }
            }
            ++count;
        }
        StringBuilder sb = new StringBuilder(lenghtOfPostingList * lenghtOfPostingList);
        for (Result result : results) {
            for (int i = 0; i < lenghtOfPostingList; ++i) {
                sb.append(String.format("R%05d ", result.index));
            }
            --lenghtOfPostingList;
        }
        return sb.toString();
    }

    public static String generateBoostedQuery(GlobalFeature feature, int queryLength) {
        ArrayList<GlobalFeature> l = referencePoints.get(feature.getClass().getName());
        if (l == null) {
            return null;
        }
        int lenghtOfPostingList = Math.min(queryLength, MetricSpaces.parameters.get((Object)feature.getClass().getName()).lenghtOfPostingList);
        if (lenghtOfPostingList < 1) {
            lenghtOfPostingList = MetricSpaces.parameters.get((Object)feature.getClass().getName()).lenghtOfPostingList;
        }
        TreeSet<Result> results = new TreeSet<Result>();
        double maxDistance = Double.MAX_VALUE;
        int count = 0;
        for (GlobalFeature f : l) {
            double distance = f.getDistance(feature);
            if (results.size() < lenghtOfPostingList) {
                results.add(new Result(distance, count));
                maxDistance = l.get(((Result)results.last()).index).getDistance(feature);
            } else if (distance < maxDistance) {
                results.add(new Result(distance, count));
                maxDistance = distance;
                if (results.size() > lenghtOfPostingList) {
                    results.pollLast();
                }
            }
            ++count;
        }
        StringBuilder sb = new StringBuilder(lenghtOfPostingList * 11);
        double max = lenghtOfPostingList;
        for (Result result : results) {
            sb.append(String.format("R%05d^%1.2f ", result.index, (double)lenghtOfPostingList / max));
            --lenghtOfPostingList;
        }
        return sb.toString();
    }

    private static void printHelp() {
        System.out.println("Help for the MetricSpaces class\n===============================\n\nRun the main method to create a compatible file to be used \nfor indexing and hashing. This text is shown with the \n-h option.\n\n$> MetricSpaces -i <input-file> -p <parameters>\n\n<input-file> ... gives the image data set to sample from, \n                 one per line, lines starting with # are \n\t\t\t\t ignored.\n<parameters> ... number of reference points and length of \n\t\t\t\t the posting list, eg. \"-p 1000,50\"\n\t\t\t\t \n\nExample usage:\n--------------\n\n$> MetricSpaces -i mylist.txt -p 500,25");
    }

    public static class Result
    implements Comparable<Result> {
        public int index;
        public double distance;

        public Result(double distance, int count) {
            this.distance = distance;
            this.index = count;
        }

        @Override
        public int compareTo(Result o) {
            return (int)Math.signum(this.distance - o.distance);
        }
    }

    public static class Parameters {
        public int numberOfReferencePoints;
        public int lenghtOfPostingList;
        public Class featureClass;
    }
}

