/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.indexers.parallel;

import net.semanticmetadata.lire.imageanalysis.features.Extractor;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeatureExtractor;
import net.semanticmetadata.lire.imageanalysis.features.local.simple.SimpleExtractor;

public class ExtractorItem {
    private Class<? extends Extractor> extractorClass;
    private Extractor extractorInstance;
    private LireFeature featureInstance;
    private SimpleExtractor.KeypointDetector keypointDetector;
    private String fieldName;
    private boolean global = false;
    private boolean local = false;
    private boolean isSimpleExtractorItem = false;
    private int numKeypoints = -1;

    public ExtractorItem(Class<? extends Extractor> extractorClass) {
        if (extractorClass == null) {
            throw new UnsupportedOperationException("extractorClass cannot be null");
        }
        this.extractorClass = extractorClass;
        try {
            this.extractorInstance = extractorClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (GlobalFeature.class.isAssignableFrom(extractorClass)) {
            this.global = true;
            this.fieldName = ((GlobalFeature)this.extractorInstance).getFieldName();
            this.featureInstance = (GlobalFeature)this.extractorInstance;
        } else if (LocalFeatureExtractor.class.isAssignableFrom(extractorClass)) {
            this.local = true;
            try {
                this.featureInstance = ((LocalFeatureExtractor)this.extractorInstance).getClassOfFeatures().newInstance();
                this.fieldName = this.featureInstance.getFieldName();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            throw new UnsupportedOperationException("Error");
        }
        this.keypointDetector = null;
    }

    public ExtractorItem(Class<? extends GlobalFeature> globalFeatureClass, SimpleExtractor.KeypointDetector keypointDetector) {
        if (globalFeatureClass == null || keypointDetector == null) {
            throw new UnsupportedOperationException("globalFeature or detector cannot be null");
        }
        this.extractorClass = globalFeatureClass;
        try {
            this.extractorInstance = new SimpleExtractor(globalFeatureClass.newInstance(), keypointDetector);
            this.featureInstance = ((SimpleExtractor)this.extractorInstance).getClassOfFeatures().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.fieldName = ((SimpleExtractor)this.extractorInstance).getFieldName();
        this.keypointDetector = keypointDetector;
        this.isSimpleExtractorItem = true;
    }

    public ExtractorItem(Class<? extends GlobalFeature> globalFeatureClass, SimpleExtractor.KeypointDetector keypointDetector, int numKeypoints) {
        if (globalFeatureClass == null || keypointDetector == null) {
            throw new UnsupportedOperationException("globalFeature or detector cannot be null");
        }
        this.extractorClass = globalFeatureClass;
        try {
            this.extractorInstance = new SimpleExtractor(globalFeatureClass.newInstance(), keypointDetector, numKeypoints);
            this.numKeypoints = numKeypoints;
            this.featureInstance = ((SimpleExtractor)this.extractorInstance).getClassOfFeatures().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.fieldName = ((SimpleExtractor)this.extractorInstance).getFieldName();
        this.keypointDetector = keypointDetector;
        this.isSimpleExtractorItem = true;
    }

    public Class<? extends Extractor> getExtractorClass() {
        return this.extractorClass;
    }

    public Extractor getExtractorInstance() {
        return this.extractorInstance;
    }

    public LireFeature getFeatureInstance() {
        return this.featureInstance;
    }

    public SimpleExtractor.KeypointDetector getKeypointDetector() {
        return this.keypointDetector;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isSimple() {
        return this.isSimpleExtractorItem;
    }

    public ExtractorItem clone() {
        ExtractorItem clone = this.isSimpleExtractorItem ? (this.numKeypoints > 0 ? new ExtractorItem(this.extractorClass, this.keypointDetector, this.numKeypoints) : new ExtractorItem(this.extractorClass, this.keypointDetector)) : new ExtractorItem(this.extractorClass);
        return clone;
    }
}

