/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.indexers.parallel;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ProgressMonitor;
import net.semanticmetadata.lire.aggregators.AbstractAggregator;
import net.semanticmetadata.lire.aggregators.BOVW;
import net.semanticmetadata.lire.builders.AbstractLocalDocumentBuilder;
import net.semanticmetadata.lire.builders.DocumentBuilder;
import net.semanticmetadata.lire.builders.GlobalDocumentBuilder;
import net.semanticmetadata.lire.builders.LocalDocumentBuilder;
import net.semanticmetadata.lire.builders.SimpleDocumentBuilder;
import net.semanticmetadata.lire.classifiers.Cluster;
import net.semanticmetadata.lire.classifiers.KMeans;
import net.semanticmetadata.lire.classifiers.ParallelKMeans;
import net.semanticmetadata.lire.imageanalysis.features.Extractor;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeatureExtractor;
import net.semanticmetadata.lire.imageanalysis.features.global.CEDD;
import net.semanticmetadata.lire.imageanalysis.features.global.FCTH;
import net.semanticmetadata.lire.imageanalysis.features.global.JCD;
import net.semanticmetadata.lire.imageanalysis.features.local.simple.SimpleExtractor;
import net.semanticmetadata.lire.indexers.parallel.ExtractorItem;
import net.semanticmetadata.lire.indexers.parallel.ImagePreprocessor;
import net.semanticmetadata.lire.indexers.parallel.WorkItem;
import net.semanticmetadata.lire.utils.FileUtils;
import net.semanticmetadata.lire.utils.LuceneUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;

public class ParallelIndexer
implements Runnable {
    private boolean useDocValues = false;
    private Logger log = Logger.getLogger(this.getClass().getName());
    private ProgressMonitor pm = null;
    private DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance();
    private int numOfThreads = 16;
    private int monitoringInterval = 30;
    private int overallCount = -1;
    private int numImages = -1;
    private boolean overWrite = true;
    private boolean useParallelClustering = true;
    private boolean indexingFinished = false;
    private boolean lockLists = false;
    private boolean sampling = false;
    private boolean appending = false;
    private boolean globalHashing = false;
    private GlobalDocumentBuilder.HashingMode globalHashingMode = GlobalDocumentBuilder.HashingMode.BitSampling;
    private IndexWriter writer;
    private String imageDirectory;
    private String indexPath;
    private File imageList = null;
    private List<String> allImages;
    private List<String> sampleImages;
    private int numOfDocsForCodebooks = 300;
    private int[] numOfClusters = new int[]{512};
    private TreeSet<Integer> numOfClustersSet = new TreeSet();
    private HashSet<ExtractorItem> GlobalExtractors = new HashSet(10);
    private HashMap<ExtractorItem, LinkedList<Cluster[]>> LocalExtractorsAndCodebooks = new HashMap(10);
    private HashMap<ExtractorItem, LinkedList<Cluster[]>> SimpleExtractorsAndCodebooks = new HashMap(10);
    private Class<? extends DocumentBuilder> customDocumentBuilder = null;
    private boolean customDocBuilderFlag = false;
    private ConcurrentHashMap<String, List<? extends LocalFeature>> conSampleMap;
    private Class<? extends AbstractAggregator> aggregator = BOVW.class;
    private HashMap<String, Document> allDocuments;
    private ImagePreprocessor imagePreprocessor;
    private int queueCapacity = 200;
    private LinkedBlockingQueue<WorkItem> queue = new LinkedBlockingQueue(this.queueCapacity);

    public static void main(String[] args) {
        String indexPath = null;
        String imageDirectory = null;
        File imageList = null;
        int numThreads = 10;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-i")) {
                if (i + 1 >= args.length) continue;
                indexPath = args[i + 1];
                continue;
            }
            if (arg.startsWith("-n")) {
                if (i + 1 >= args.length) continue;
                try {
                    numThreads = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException e) {
                    System.err.println("Could not read number of threads: " + args[i + 1] + "\nUsing default value " + numThreads);
                }
                continue;
            }
            if (arg.startsWith("-l")) {
                imageDirectory = null;
                if (i + 1 >= args.length || (imageList = new File(args[i + 1])).exists()) continue;
                System.err.println(args[i + 1] + " does not exits!");
                ParallelIndexer.printHelp();
                System.exit(-1);
                continue;
            }
            if (!arg.startsWith("-d") || i + 1 >= args.length) continue;
            imageDirectory = args[i + 1];
        }
        if (indexPath == null) {
            ParallelIndexer.printHelp();
            System.exit(-1);
        } else if (!(imageList != null || imageDirectory != null && new File(imageDirectory).exists())) {
            ParallelIndexer.printHelp();
            System.exit(-1);
        }
        ParallelIndexer p = imageList != null ? new ParallelIndexer(numThreads, indexPath, imageList) : new ParallelIndexer(numThreads, indexPath, imageDirectory);
        p.addExtractor(CEDD.class);
        p.addExtractor(FCTH.class);
        p.addExtractor(JCD.class);
        p.run();
    }

    private static void printHelp() {
        System.out.println("Usage:\n\n$> ParallelIndexer -i <index> <-d <image-directory> | -l <image-list>> [-n <number of threads>]\n\nindex             ... The directory of the index. Will be appended or created if not existing.\nimages-directory  ... The directory the images are found in. It's traversed recursively.\nimage-list        ... A list of images in a file, one per line. Use instead of images-directory.\nnumber of threads ... The number of threads used for extracting features, e.g. # of CPU cores.");
    }

    public ParallelIndexer(int numOfThreads, String indexPath, String imageDirectory) {
        this.numOfThreads = numOfThreads;
        this.indexPath = indexPath;
        this.imageDirectory = imageDirectory;
    }

    public ParallelIndexer(int numOfThreads, String indexPath, String imageDirectory, int numOfClusters, int numOfDocsForCodebooks) {
        this.numOfThreads = numOfThreads;
        this.indexPath = indexPath;
        this.imageDirectory = imageDirectory;
        this.numOfClusters = new int[]{numOfClusters};
        this.numOfDocsForCodebooks = numOfDocsForCodebooks;
    }

    public ParallelIndexer(int numOfThreads, String indexPath, String imageDirectory, int numOfClusters, int numOfDocsForCodebooks, Class<? extends AbstractAggregator> aggregator) {
        this.numOfThreads = numOfThreads;
        this.indexPath = indexPath;
        this.imageDirectory = imageDirectory;
        this.numOfClusters = new int[]{numOfClusters};
        this.numOfDocsForCodebooks = numOfDocsForCodebooks;
        this.aggregator = aggregator;
    }

    public ParallelIndexer(int numOfThreads, String indexPath, String imageDirectory, int[] numOfClusters, int numOfDocsForCodebooks) {
        this.numOfThreads = numOfThreads;
        this.indexPath = indexPath;
        this.imageDirectory = imageDirectory;
        this.numOfClusters = numOfClusters;
        this.numOfDocsForCodebooks = numOfDocsForCodebooks;
    }

    public ParallelIndexer(int numOfThreads, String indexPath, String imageDirectory, int[] numOfClusters, int numOfDocsForCodebooks, Class<? extends AbstractAggregator> aggregator) {
        this.numOfThreads = numOfThreads;
        this.indexPath = indexPath;
        this.imageDirectory = imageDirectory;
        this.numOfClusters = numOfClusters;
        this.numOfDocsForCodebooks = numOfDocsForCodebooks;
        this.aggregator = aggregator;
    }

    public ParallelIndexer(int numOfThreads, String indexPath, String imageDirectory, boolean overWrite) {
        this.numOfThreads = numOfThreads;
        this.indexPath = indexPath;
        this.imageDirectory = imageDirectory;
        this.overWrite = overWrite;
        if (overWrite || !new File(indexPath).exists()) {
            throw new UnsupportedOperationException("Error in trying to append index...");
        }
        this.appending = true;
        this.loadPropertiesFile(indexPath + ".config/");
        this.lockLists = true;
    }

    public ParallelIndexer(int numOfThreads, String indexPath, String imageDirectory, String fromIndexPath) {
        this.numOfThreads = numOfThreads;
        this.indexPath = indexPath;
        this.imageDirectory = imageDirectory;
        if (!new File(fromIndexPath).exists()) {
            throw new UnsupportedOperationException("Error in trying to find index...");
        }
        new File(indexPath + ".config/").mkdirs();
        this.loadPropertiesFile(fromIndexPath + ".config/");
        this.lockLists = true;
    }

    public ParallelIndexer(int numOfThreads, String indexPath, File imageList) {
        this.numOfThreads = numOfThreads;
        this.indexPath = indexPath;
        this.imageList = imageList;
    }

    public ParallelIndexer(int numOfThreads, String indexPath, File imageList, GlobalDocumentBuilder.HashingMode hashingMode) {
        this.numOfThreads = numOfThreads;
        this.indexPath = indexPath;
        this.imageList = imageList;
        this.globalHashing = hashingMode != GlobalDocumentBuilder.HashingMode.None;
        this.globalHashingMode = hashingMode;
    }

    public ParallelIndexer(int numOfThreads, String indexPath, File imageList, GlobalDocumentBuilder.HashingMode hashingMode, boolean useDocValues) {
        this.numOfThreads = numOfThreads;
        this.indexPath = indexPath;
        this.imageList = imageList;
        this.globalHashing = hashingMode != GlobalDocumentBuilder.HashingMode.None;
        this.globalHashingMode = hashingMode;
        this.useDocValues = useDocValues;
    }

    public ParallelIndexer(int numOfThreads, String indexPath, File imageList, GlobalDocumentBuilder.HashingMode hashingMode, boolean useDocValues, int queueSize) {
        this.numOfThreads = numOfThreads;
        this.indexPath = indexPath;
        this.imageList = imageList;
        this.globalHashing = hashingMode != GlobalDocumentBuilder.HashingMode.None;
        this.globalHashingMode = hashingMode;
        this.useDocValues = useDocValues;
        this.queueCapacity = queueSize;
        this.queue = new LinkedBlockingQueue(queueSize);
    }

    public ParallelIndexer(int numOfThreads, String indexPath, File imageList, int numOfClusters, int numOfDocsForCodebooks) {
        this.numOfThreads = numOfThreads;
        this.indexPath = indexPath;
        this.imageList = imageList;
        this.numOfClusters = new int[]{numOfClusters};
        this.numOfDocsForCodebooks = numOfDocsForCodebooks;
    }

    public ParallelIndexer(int numOfThreads, String indexPath, File imageList, int numOfClusters, int numOfDocsForCodebooks, Class<? extends AbstractAggregator> aggregator) {
        this.numOfThreads = numOfThreads;
        this.indexPath = indexPath;
        this.imageList = imageList;
        this.numOfClusters = new int[]{numOfClusters};
        this.numOfDocsForCodebooks = numOfDocsForCodebooks;
        this.aggregator = aggregator;
    }

    public ParallelIndexer(int numOfThreads, String indexPath, File imageList, int[] numOfClusters, int numOfDocsForCodebooks) {
        this.numOfThreads = numOfThreads;
        this.indexPath = indexPath;
        this.imageList = imageList;
        this.numOfClusters = numOfClusters;
        this.numOfDocsForCodebooks = numOfDocsForCodebooks;
    }

    public ParallelIndexer(int numOfThreads, String indexPath, File imageList, int[] numOfClusters, int numOfDocsForCodebooks, Class<? extends AbstractAggregator> aggregator) {
        this.numOfThreads = numOfThreads;
        this.indexPath = indexPath;
        this.imageList = imageList;
        this.numOfClusters = numOfClusters;
        this.numOfDocsForCodebooks = numOfDocsForCodebooks;
        this.aggregator = aggregator;
    }

    public ParallelIndexer(int numOfThreads, String indexPath, File imageList, boolean overWrite) {
        this.numOfThreads = numOfThreads;
        this.indexPath = indexPath;
        this.imageList = imageList;
        this.overWrite = overWrite;
        if (overWrite || !new File(indexPath).exists()) {
            throw new UnsupportedOperationException("Error in trying to append index...");
        }
        this.appending = true;
        this.loadPropertiesFile(indexPath + ".config/");
        this.lockLists = true;
    }

    public ParallelIndexer(int numOfThreads, String indexPath, File imageList, String fromIndexPath) {
        this.numOfThreads = numOfThreads;
        this.indexPath = indexPath;
        this.imageList = imageList;
        if (!new File(fromIndexPath).exists()) {
            throw new UnsupportedOperationException("Error in trying to find index...");
        }
        new File(indexPath + ".config/").mkdirs();
        this.loadPropertiesFile(fromIndexPath + ".config/");
        this.lockLists = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addExtractor(Class<? extends Extractor> extractorClass) {
        if (this.lockLists) {
            throw new UnsupportedOperationException("Cannot add extractors!");
        }
        ExtractorItem extractorItem = new ExtractorItem(extractorClass);
        boolean flag = true;
        if (extractorItem.isGlobal()) {
            for (ExtractorItem next : this.GlobalExtractors) {
                if (!next.getExtractorClass().equals(extractorClass)) continue;
                flag = false;
            }
            if (!flag) throw new UnsupportedOperationException(extractorClass.getSimpleName() + " already exists!!");
            this.GlobalExtractors.add(extractorItem);
            return;
        } else {
            if (!extractorItem.isLocal()) throw new UnsupportedOperationException("Error");
            for (Map.Entry<ExtractorItem, LinkedList<Cluster[]>> next : this.LocalExtractorsAndCodebooks.entrySet()) {
                if (!next.getKey().getExtractorClass().equals(extractorClass)) continue;
                flag = false;
            }
            if (!flag) throw new UnsupportedOperationException(extractorClass.getSimpleName() + " already exists!!");
            this.LocalExtractorsAndCodebooks.put(extractorItem, new LinkedList());
            this.sampling = true;
        }
    }

    public void addExtractor(Class<? extends GlobalFeature> globalFeatureClass, SimpleExtractor.KeypointDetector detector) {
        if (this.lockLists) {
            throw new UnsupportedOperationException("Cannot add extractors!");
        }
        boolean flag = true;
        for (Map.Entry<ExtractorItem, LinkedList<Cluster[]>> next : this.SimpleExtractorsAndCodebooks.entrySet()) {
            if (!next.getKey().getExtractorClass().equals(globalFeatureClass) || next.getKey().getKeypointDetector() != detector) continue;
            flag = false;
        }
        if (!flag) {
            throw new UnsupportedOperationException(globalFeatureClass.getSimpleName() + " with " + detector.name() + " already exists!!");
        }
        this.SimpleExtractorsAndCodebooks.put(new ExtractorItem(globalFeatureClass, detector), new LinkedList());
        this.sampling = true;
    }

    public void addExtractor(Class<? extends GlobalFeature> globalFeatureClass, SimpleExtractor.KeypointDetector detector, int numKeyPoints) {
        if (this.lockLists) {
            throw new UnsupportedOperationException("Cannot add extractors!");
        }
        boolean flag = true;
        for (Map.Entry<ExtractorItem, LinkedList<Cluster[]>> next : this.SimpleExtractorsAndCodebooks.entrySet()) {
            if (!next.getKey().getExtractorClass().equals(globalFeatureClass) || next.getKey().getKeypointDetector() != detector) continue;
            flag = false;
        }
        if (!flag) {
            throw new UnsupportedOperationException(globalFeatureClass.getSimpleName() + " with " + detector.name() + " already exists!!");
        }
        this.SimpleExtractorsAndCodebooks.put(new ExtractorItem(globalFeatureClass, detector, numKeyPoints), new LinkedList());
        this.sampling = true;
    }

    public void addExtractor(Class<? extends LocalFeatureExtractor> localFeatureExtractorClass, Cluster[] codebook) {
        LinkedList<Cluster[]> tmpList = new LinkedList<Cluster[]>();
        tmpList.add(codebook);
        this.addExtractor(localFeatureExtractorClass, tmpList);
    }

    public void addExtractor(Class<? extends GlobalFeature> globalFeatureClass, SimpleExtractor.KeypointDetector detector, Cluster[] codebook) {
        LinkedList<Cluster[]> tmpList = new LinkedList<Cluster[]>();
        tmpList.add(codebook);
        this.addExtractor(globalFeatureClass, detector, tmpList);
    }

    public void addExtractor(Class<? extends LocalFeatureExtractor> localFeatureExtractorClass, LinkedList<Cluster[]> codebooks) {
        if (this.lockLists) {
            throw new UnsupportedOperationException("Cannot add extractors!");
        }
        new File(this.indexPath + ".config/").mkdirs();
        ExtractorItem extractorItem = new ExtractorItem(localFeatureExtractorClass);
        boolean flag = true;
        for (Map.Entry<ExtractorItem, LinkedList<Cluster[]>> next : this.LocalExtractorsAndCodebooks.entrySet()) {
            if (!next.getKey().getExtractorClass().equals(localFeatureExtractorClass)) continue;
            flag = false;
        }
        if (flag) {
            for (Cluster[] codebook : codebooks) {
                boolean flagForSize = false;
                for (int next : this.numOfClusters) {
                    if (codebook.length != next) continue;
                    flagForSize = true;
                }
                if (flagForSize) continue;
                System.err.println("Codebook of " + codebook.length + " clusters will be removed as such number of clusters is not selected!!");
                codebooks.remove(codebook);
            }
            if (!this.appending) {
                for (Cluster[] codebook : codebooks) {
                    try {
                        Cluster.writeClusters(codebook, this.indexPath + ".config/" + extractorItem.getFeatureInstance().getFieldName() + codebook.length);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.LocalExtractorsAndCodebooks.put(extractorItem, codebooks);
            for (Object numOfCluster : (Object)this.numOfClusters) {
                boolean found = false;
                for (Cluster[] codebook : codebooks) {
                    if (codebook.length != numOfCluster) continue;
                    found = true;
                }
                if (found) continue;
                this.sampling = true;
            }
        } else {
            throw new UnsupportedOperationException(localFeatureExtractorClass.getSimpleName() + " already exists!!");
        }
    }

    public void addExtractor(Class<? extends GlobalFeature> globalFeatureClass, SimpleExtractor.KeypointDetector detector, LinkedList<Cluster[]> codebooks) {
        if (this.lockLists) {
            throw new UnsupportedOperationException("Cannot add extractors!");
        }
        new File(this.indexPath + ".config/").mkdirs();
        ExtractorItem extractorItem = new ExtractorItem(globalFeatureClass, detector);
        boolean flag = true;
        for (Map.Entry<ExtractorItem, LinkedList<Cluster[]>> next : this.SimpleExtractorsAndCodebooks.entrySet()) {
            if (!next.getKey().getExtractorClass().equals(globalFeatureClass) || next.getKey().getKeypointDetector() != detector) continue;
            flag = false;
        }
        if (flag) {
            for (Cluster[] codebook : codebooks) {
                boolean flagForSize = false;
                for (int next : this.numOfClusters) {
                    if (codebook.length != next) continue;
                    flagForSize = true;
                }
                if (flagForSize) continue;
                System.err.println("Codebook of " + codebook.length + " clusters will be removed as such number of clusters is not selected!!");
                codebooks.remove(codebook);
            }
            if (!this.appending) {
                for (Cluster[] codebook : codebooks) {
                    try {
                        Cluster.writeClusters(codebook, this.indexPath + ".config/" + ((SimpleExtractor)extractorItem.getExtractorInstance()).getFieldName() + codebook.length);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.SimpleExtractorsAndCodebooks.put(extractorItem, codebooks);
            for (Object numOfCluster : (Object)this.numOfClusters) {
                boolean found = false;
                for (Cluster[] codebook : codebooks) {
                    if (codebook.length != numOfCluster) continue;
                    found = true;
                }
                if (found) continue;
                this.sampling = true;
            }
        } else {
            throw new UnsupportedOperationException(globalFeatureClass.getSimpleName() + " with " + detector.name() + " already exists!!");
        }
    }

    public void setCustomDocumentBuilder(Class<? extends DocumentBuilder> customDocumentBuilder) {
        this.customDocumentBuilder = customDocumentBuilder;
        this.customDocBuilderFlag = true;
    }

    @Override
    public void run() {
        this.lockLists = true;
        try {
            long start = System.currentTimeMillis();
            this.writer = LuceneUtils.createIndexWriter(this.indexPath, this.overWrite, LuceneUtils.AnalyzerType.WhitespaceAnalyzer);
            if (this.imageList == null) {
                this.allImages = FileUtils.readFileLines(new File(this.imageDirectory), true);
            } else {
                String line;
                this.allImages = new LinkedList<String>();
                BufferedReader br = new BufferedReader(new FileReader(this.imageList));
                while ((line = br.readLine()) != null) {
                    if (line.trim().length() <= 3) continue;
                    this.allImages.add(line.trim());
                }
            }
            if (this.allImages.size() <= 0) {
                throw new UnsupportedOperationException("No images were found!!");
            }
            for (Object numOfCluster : (BufferedReader)this.numOfClusters) {
                this.numOfClustersSet.add((int)numOfCluster);
            }
            if ((this.LocalExtractorsAndCodebooks.size() > 0 || this.SimpleExtractorsAndCodebooks.size() > 0) && this.numOfClustersSet.size() <= 0) {
                throw new UnsupportedOperationException("Need to set number of clusters for Local Extractors!!");
            }
            this.printSetUp();
            new File(this.indexPath + ".config/").mkdirs();
            if (this.sampling) {
                if (this.customDocBuilderFlag) {
                    throw new UnsupportedOperationException("Cannot use sampling and set custom document builder at the same time!!");
                }
                System.out.println("Sampling and Creating Codebooks....");
                this.numImages = this.allImages.size();
                int capacity = Math.min(this.numOfDocsForCodebooks, this.numImages);
                if (capacity < 0) {
                    capacity = this.numImages / 2;
                }
                this.allDocuments = new HashMap(capacity);
                this.sampleImages = this.selectVocabularyDocs(this.numImages, capacity);
                this.numImages = this.sampleImages.size();
                this.conSampleMap = new ConcurrentHashMap(this.numImages);
                this.sample(this.LocalExtractorsAndCodebooks);
                this.sample(this.SimpleExtractorsAndCodebooks);
                this.conSampleMap.clear();
                this.conSampleMap = null;
                if (this.GlobalExtractors.size() > 0) {
                    this.fillSampleWithGlobals();
                }
                this.flushDocuments();
                this.allDocuments.clear();
                this.allDocuments = null;
                System.out.println("Indexing rest images....");
            } else {
                System.out.println("No need for sampling and generating codebooks.....");
            }
            this.numImages = this.allImages.size();
            this.index();
            System.out.printf("Total time of indexing: %s.\n", this.convertTime(System.currentTimeMillis() - start));
            LuceneUtils.commitWriter(this.writer);
            LuceneUtils.optimizeWriter(this.writer);
            LuceneUtils.closeWriter(this.writer);
            if (!this.appending) {
                this.writePropertiesFile();
                System.out.println("Properties saved!");
            }
            this.indexingFinished = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void flushDocuments() {
        System.out.println("Flushing documents....");
        long start = System.currentTimeMillis();
        try {
            for (Map.Entry<String, Document> documentEntry : this.allDocuments.entrySet()) {
                this.writer.addDocument((Iterable)documentEntry.getValue());
            }
            LuceneUtils.commitWriter(this.writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.printf("Time of flushing: %s.\n", this.convertTime(System.currentTimeMillis() - start));
    }

    private void index() {
        System.out.printf("Indexing %d images\n", this.numImages);
        long start = System.currentTimeMillis();
        try {
            Thread p = new Thread((Runnable)new Producer(this.allImages), "Producer");
            p.start();
            LinkedList<Thread> threads = new LinkedList<Thread>();
            for (int i = 0; i < this.numOfThreads; ++i) {
                Thread c = new Thread((Runnable)new Consumer(), String.format("Consumer-%02d", i + 1));
                c.start();
                threads.add(c);
            }
            Monitoring monitoring = new Monitoring();
            Thread m = new Thread((Runnable)monitoring, "IndexingMonitor");
            m.start();
            for (Thread thread : threads) {
                thread.join();
            }
            monitoring.killMonitoring();
            long end = System.currentTimeMillis() - start;
            System.out.printf("Analyzed %d images in %s ~ %3.2f ms each.\n", this.overallCount, this.convertTime(end), Float.valueOf(this.overallCount > 0 ? (float)end / (float)this.overallCount : -1.0f));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void fillSampleWithGlobals() {
        System.out.println("Filling GlobalFeatures....");
        System.out.printf("Indexing %d images\n", this.sampleImages.size());
        long start = System.currentTimeMillis();
        try {
            Thread p = new Thread(new Producer(this.sampleImages));
            p.start();
            LinkedList<Thread> threads = new LinkedList<Thread>();
            for (int i = 0; i < this.numOfThreads; ++i) {
                Thread c = new Thread(new ConsumerForGlobalSample());
                c.start();
                threads.add(c);
            }
            Monitoring monitoring = new Monitoring();
            Thread m = new Thread(monitoring);
            m.start();
            for (Thread thread : threads) {
                thread.join();
            }
            monitoring.killMonitoring();
            long end = System.currentTimeMillis() - start;
            System.out.printf("Analyzed %d images in %s ~ %3.2f ms each.\n", this.overallCount, this.convertTime(end), Float.valueOf(this.overallCount > 0 ? (float)end / (float)this.overallCount : -1.0f));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void sample(HashMap<ExtractorItem, LinkedList<Cluster[]>> mapWithClassesAndCodebooks) {
        LinkedList<Thread> threads = new LinkedList<Thread>();
        try {
            for (ExtractorItem extractorItem : mapWithClassesAndCodebooks.keySet()) {
                Thread c;
                String toPrint;
                String codebookTitle;
                Extractor myExtractor = extractorItem.getExtractorInstance();
                this.conSampleMap.clear();
                threads.clear();
                if (extractorItem.isSimple()) {
                    codebookTitle = ((SimpleExtractor)myExtractor).getFieldName();
                    toPrint = ((SimpleExtractor)myExtractor).getFeatureName() + " and " + this.aggregator.getSimpleName();
                } else if (extractorItem.isLocal()) {
                    codebookTitle = extractorItem.getFeatureInstance().getFieldName();
                    toPrint = extractorItem.getFeatureInstance().getFeatureName() + " and " + this.aggregator.getSimpleName();
                } else {
                    throw new UnsupportedOperationException("Something is wrong!! (ParallelLocalIndexer.sampling)");
                }
                System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                System.out.println("Feature: " + toPrint);
                Thread p = new Thread(new Producer(this.sampleImages));
                p.start();
                long start = System.currentTimeMillis();
                for (int i = 0; i < this.numOfThreads; ++i) {
                    ExtractorForLocalSample extractorForLocalSample = new ExtractorForLocalSample(extractorItem);
                    c = new Thread(extractorForLocalSample);
                    threads.add(c);
                    c.start();
                }
                Monitoring monitoring = new Monitoring();
                Thread m = new Thread(monitoring);
                m.start();
                for (Thread thread : threads) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                monitoring.killMonitoring();
                long end = System.currentTimeMillis() - start;
                System.out.printf("Analyzed %d images in %s ~ %3.2f ms each.\n", this.overallCount, this.convertTime(end), Float.valueOf(this.overallCount > 0 ? (float)end / (float)this.overallCount : -1.0f));
                for (Integer numOfClusters : this.numOfClustersSet) {
                    System.out.println("Number of clusters: " + numOfClusters);
                    boolean flag = true;
                    for (int j = 0; j < mapWithClassesAndCodebooks.get(extractorItem).size(); ++j) {
                        if (mapWithClassesAndCodebooks.get(extractorItem).get(j).length != numOfClusters) continue;
                        System.out.println("Codebook of " + numOfClusters + " clusters found, no need to generate!");
                        flag = false;
                    }
                    if (!flag) continue;
                    start = System.currentTimeMillis();
                    Cluster[] codebook = this.codebookGenerator(this.conSampleMap, numOfClusters);
                    Cluster.writeClusters(codebook, this.indexPath + ".config/" + codebookTitle + numOfClusters);
                    mapWithClassesAndCodebooks.get(extractorItem).add(codebook);
                    System.out.printf("Time of codebook generation: %s.\n", this.convertTime(System.currentTimeMillis() - start));
                }
                threads.clear();
                p = new Thread(new ProducerForLocalSample(this.conSampleMap));
                p.start();
                start = System.currentTimeMillis();
                for (int i = 0; i < this.numOfThreads; ++i) {
                    c = new Thread(new ConsumerForLocalSample(extractorItem, mapWithClassesAndCodebooks.get(extractorItem)));
                    threads.add(c);
                    c.start();
                }
                monitoring = new Monitoring();
                m = new Thread(monitoring);
                m.start();
                for (Thread thread : threads) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                monitoring.killMonitoring();
                end = System.currentTimeMillis() - start;
                System.out.printf("Analyzed %d images in %s ~ %3.2f ms each.\n", this.overallCount, this.convertTime(end), Float.valueOf(this.overallCount > 0 ? (float)end / (float)this.overallCount : -1.0f));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double getPercentageDone() {
        return (double)this.overallCount / (double)this.numImages;
    }

    public ImagePreprocessor getImagePreprocessor() {
        return this.imagePreprocessor;
    }

    public void setImagePreprocessor(ImagePreprocessor imagePreprocessor) {
        this.imagePreprocessor = imagePreprocessor;
    }

    private LinkedList<String> selectVocabularyDocs(int maxDocs, int capacity) {
        LinkedList<String> tmpImages = new LinkedList<String>();
        if (this.numOfDocsForCodebooks >= maxDocs) {
            for (int i = 0; i < maxDocs; ++i) {
                String tmpStr = this.allImages.get(i);
                Document doc = new Document();
                doc.add((IndexableField)new StringField("ImageIdentifier", tmpStr, Field.Store.YES));
                this.allDocuments.put(tmpStr, doc);
                tmpImages.add(tmpStr);
            }
            this.allImages.clear();
        } else {
            for (int i = 0; i < capacity; ++i) {
                int tmpIndex = (int)Math.floor(Math.random() * (double)this.allImages.size());
                String tmpStr = this.allImages.get(tmpIndex);
                Document doc = new Document();
                doc.add((IndexableField)new StringField("ImageIdentifier", tmpStr, Field.Store.YES));
                this.allDocuments.put(tmpStr, doc);
                tmpImages.add(tmpStr);
                this.allImages.remove(tmpIndex);
            }
        }
        return tmpImages;
    }

    private Cluster[] codebookGenerator(ConcurrentHashMap<String, List<? extends LocalFeature>> sampleMap, int numClusters) {
        KMeans k = this.useParallelClustering ? new ParallelKMeans(numClusters) : new KMeans(numClusters);
        for (Map.Entry<String, List<? extends LocalFeature>> stringListEntry : sampleMap.entrySet()) {
            List<? extends LocalFeature> tempList = stringListEntry.getValue();
            for (LocalFeature localFeature : tempList) {
                k.addFeature(localFeature.getFeatureVector());
            }
        }
        if (this.pm != null) {
            this.pm.setProgress(5);
            this.pm.setNote("Starting clustering");
        }
        if (k.getFeatureCount() < numClusters) {
            throw new UnsupportedOperationException("Only " + k.getFeatureCount() + " features found to cluster in " + numClusters + ". Try to use less clusters or more images.");
        }
        System.out.println("Number of local features: " + this.df.format(k.getFeatureCount()));
        System.out.println("Starting clustering ...");
        k.init();
        System.out.println("Step.");
        long start = System.currentTimeMillis();
        double lastStress = k.clusteringStep();
        if (this.pm != null) {
            this.pm.setProgress(8);
            this.pm.setNote("Step 1 finished");
        }
        System.out.println(this.convertTime(System.currentTimeMillis() - start) + " -> Next step.");
        start = System.currentTimeMillis();
        double newStress = k.clusteringStep();
        if (this.pm != null) {
            this.pm.setProgress(11);
            this.pm.setNote("Step 2 finished");
        }
        double threshold = Math.max(20.0, (double)k.getFeatureCount() / 1000.0);
        System.out.println("Threshold = " + this.df.format(threshold));
        for (int cStep = 3; Math.abs(newStress - lastStress) > threshold && cStep < 12; ++cStep) {
            System.out.println(this.convertTime(System.currentTimeMillis() - start) + " -> Next step. Stress difference ~ |" + (int)newStress + " - " + (int)lastStress + "| = " + this.df.format(Math.abs(newStress - lastStress)));
            start = System.currentTimeMillis();
            lastStress = newStress;
            newStress = k.clusteringStep();
            if (this.pm == null) continue;
            this.pm.setProgress(cStep * 3 + 5);
            this.pm.setNote("Step " + cStep + " finished");
        }
        return k.getClusters();
    }

    private String convertTime(long time) {
        double h = (double)time / 3600000.0;
        double m = (h - Math.floor(h)) * 60.0;
        double s = (m - Math.floor(m)) * 60.0;
        return String.format("%s%02d:%02d", (int)h > 0 ? String.format("%02d:", (int)h) : "", (int)m, (int)s);
    }

    private void writePropertiesFile() {
        try {
            int i;
            Properties props = new Properties();
            props.setProperty("0", "info");
            props.setProperty("0.info.0", this.customDocumentBuilder != null ? this.customDocumentBuilder.getCanonicalName() : "null");
            props.setProperty("0.info.1", this.aggregator.getCanonicalName());
            int counter = 2;
            for (Integer n : this.numOfClustersSet) {
                props.setProperty("0.info." + String.valueOf(counter), String.valueOf(n));
                ++counter;
            }
            counter = 1;
            for (Map.Entry entry : this.LocalExtractorsAndCodebooks.entrySet()) {
                props.setProperty(String.valueOf(counter), "local");
                props.setProperty(String.valueOf(counter) + ".extractor", ((ExtractorItem)entry.getKey()).getExtractorClass().getCanonicalName());
                for (i = 0; i < ((LinkedList)entry.getValue()).size(); ++i) {
                    props.setProperty(String.valueOf(counter) + ".codebook." + String.valueOf(i + 1), ((ExtractorItem)entry.getKey()).getFeatureInstance().getFieldName() + ((Cluster[])((LinkedList)entry.getValue()).get(i)).length);
                }
                ++counter;
            }
            for (Map.Entry entry : this.SimpleExtractorsAndCodebooks.entrySet()) {
                props.setProperty(String.valueOf(counter), "simple");
                props.setProperty(String.valueOf(counter) + ".extractor", ((ExtractorItem)entry.getKey()).getExtractorClass().getCanonicalName());
                props.setProperty(String.valueOf(counter) + ".detector", SimpleExtractor.getDetector(((ExtractorItem)entry.getKey()).getKeypointDetector()));
                for (i = 0; i < ((LinkedList)entry.getValue()).size(); ++i) {
                    props.setProperty(String.valueOf(counter) + ".codebook." + String.valueOf(i + 1), ((ExtractorItem)entry.getKey()).getFieldName() + ((Cluster[])((LinkedList)entry.getValue()).get(i)).length);
                }
                ++counter;
            }
            for (ExtractorItem extractorItem : this.GlobalExtractors) {
                props.setProperty(String.valueOf(counter), "global");
                props.setProperty(String.valueOf(counter) + ".extractor", extractorItem.getExtractorClass().getCanonicalName());
                ++counter;
            }
            FileOutputStream fos = new FileOutputStream(this.indexPath + ".config/properties.xml");
            props.storeToXML(fos, "AllExtractors");
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadPropertiesFile(String path) {
        try {
            Properties prop = new Properties();
            FileInputStream fis = new FileInputStream(path + "/properties.xml");
            prop.loadFromXML(fis);
            int overAllcounter = 0;
            while (prop.getProperty(String.valueOf(overAllcounter)) != null) {
                LinkedList<Cluster[]> tmpListOfCodebooks;
                int counter;
                Class<?> tmpGlobalClass;
                String extractorType = prop.getProperty(String.valueOf(overAllcounter));
                if (extractorType.equals("global")) {
                    tmpGlobalClass = Class.forName(prop.getProperty(String.valueOf(overAllcounter) + ".extractor"));
                    this.addExtractor(tmpGlobalClass);
                } else if (extractorType.equals("local")) {
                    counter = 1;
                    tmpListOfCodebooks = new LinkedList<Cluster[]>();
                    while (prop.getProperty(String.valueOf(overAllcounter) + ".codebook." + String.valueOf(counter)) != null) {
                        tmpListOfCodebooks.add(Cluster.readClusters(path + prop.getProperty(String.valueOf(overAllcounter) + ".codebook." + String.valueOf(counter))));
                        ++counter;
                    }
                    Class<?> tmpLocalClass = Class.forName(prop.getProperty(String.valueOf(overAllcounter) + ".extractor"));
                    this.addExtractor(tmpLocalClass, tmpListOfCodebooks);
                } else if (extractorType.equals("simple")) {
                    counter = 1;
                    tmpListOfCodebooks = new LinkedList();
                    while (prop.getProperty(String.valueOf(overAllcounter) + ".codebook." + String.valueOf(counter)) != null) {
                        tmpListOfCodebooks.add(Cluster.readClusters(path + prop.getProperty(String.valueOf(overAllcounter) + ".codebook." + String.valueOf(counter))));
                        ++counter;
                    }
                    tmpGlobalClass = Class.forName(prop.getProperty(String.valueOf(overAllcounter) + ".extractor"));
                    SimpleExtractor.KeypointDetector detector = SimpleExtractor.getDetector(prop.getProperty(String.valueOf(overAllcounter) + ".detector"));
                    this.addExtractor(tmpGlobalClass, detector, tmpListOfCodebooks);
                } else if (extractorType.equals("info")) {
                    String tmpCustomBuilder = prop.getProperty(String.valueOf(overAllcounter) + ".info.0");
                    if (!tmpCustomBuilder.equals("null")) {
                        this.customDocumentBuilder = Class.forName(tmpCustomBuilder);
                    }
                    this.aggregator = Class.forName(prop.getProperty(String.valueOf(overAllcounter) + ".info.1"));
                    counter = 2;
                    LinkedList<Integer> tmpListOfNumOfClusters = new LinkedList<Integer>();
                    while (prop.getProperty(String.valueOf(overAllcounter) + ".info." + String.valueOf(counter)) != null) {
                        tmpListOfNumOfClusters.add(Integer.valueOf(prop.getProperty(String.valueOf(overAllcounter) + ".info." + String.valueOf(counter))));
                        ++counter;
                    }
                    counter = 0;
                    this.numOfClusters = new int[tmpListOfNumOfClusters.size()];
                    for (Integer e : tmpListOfNumOfClusters) {
                        this.numOfClusters[counter++] = e;
                    }
                } else {
                    throw new UnsupportedOperationException("loadPropertiesFile");
                }
                ++overAllcounter;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void printSetUp() {
        int i;
        Iterator iteratorList;
        System.out.println("===================================================================================");
        System.out.println("SetUp:");
        if ((this.LocalExtractorsAndCodebooks.size() > 0 || this.SimpleExtractorsAndCodebooks.size() > 0) && this.numOfClustersSet.size() > 0) {
            System.out.println("Aggregator: " + this.aggregator.getSimpleName());
            System.out.println("numOfDocsForCodebooks: " + this.numOfDocsForCodebooks);
            System.out.print("Set of codebooks: ");
            Iterator<Object> iterator = this.numOfClustersSet.iterator();
            System.out.print(iterator.next());
            for (int i2 = 1; i2 < this.numOfClustersSet.size(); ++i2) {
                System.out.print(", " + iterator.next());
            }
            System.out.println();
        }
        if (this.GlobalExtractors.size() > 0) {
            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            System.out.println("Set of GlobalFeatures: ");
            for (ExtractorItem GlobalExtractor : this.GlobalExtractors) {
                System.out.println(GlobalExtractor.getExtractorClass().getSimpleName());
            }
        }
        if (this.LocalExtractorsAndCodebooks.size() > 0) {
            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            System.out.println("Set of LocalFeaturesExtractors: ");
            for (Map.Entry<ExtractorItem, LinkedList<Cluster[]>> extractorItemLinkedListEntry : this.LocalExtractorsAndCodebooks.entrySet()) {
                System.out.println(extractorItemLinkedListEntry.getKey().getExtractorClass().getSimpleName());
                if (extractorItemLinkedListEntry.getValue().size() <= 0) continue;
                System.out.print(" ~ Existing codebooks: ");
                iteratorList = extractorItemLinkedListEntry.getValue().iterator();
                System.out.print(((Cluster[])iteratorList.next()).length);
                for (i = 1; i < extractorItemLinkedListEntry.getValue().size(); ++i) {
                    System.out.print(", " + ((Cluster[])iteratorList.next()).length);
                }
                System.out.println();
            }
        }
        if (this.SimpleExtractorsAndCodebooks.size() > 0) {
            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            System.out.println("Set of SIMPLE Features: ");
            for (Map.Entry<ExtractorItem, LinkedList<Cluster[]>> extractorItemLinkedListEntry : this.SimpleExtractorsAndCodebooks.entrySet()) {
                System.out.println(extractorItemLinkedListEntry.getKey().getExtractorClass().getSimpleName() + " ~ " + SimpleExtractor.getDetector(extractorItemLinkedListEntry.getKey().getKeypointDetector()));
                if (extractorItemLinkedListEntry.getValue().size() <= 0) continue;
                System.out.print(" ~ Existing codebooks: ");
                iteratorList = extractorItemLinkedListEntry.getValue().iterator();
                System.out.print(((Cluster[])iteratorList.next()).length);
                for (i = 1; i < extractorItemLinkedListEntry.getValue().size(); ++i) {
                    System.out.print(", " + ((Cluster[])iteratorList.next()).length);
                }
                System.out.println();
            }
        }
        System.out.println("===================================================================================");
    }

    public boolean hasEnded() {
        return this.indexingFinished;
    }

    class Monitoring
    implements Runnable {
        private boolean killMonitor = false;

        @Override
        public void run() {
            long gap = 1000 * ParallelIndexer.this.monitoringInterval;
            long start = System.currentTimeMillis();
            try {
                Thread.sleep(gap);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (!this.killMonitor) {
                try {
                    long end = System.currentTimeMillis() - start;
                    System.out.printf("Analyzed %d images in %s ~ %3.2f ms each. (queue size is %d)\n", ParallelIndexer.this.overallCount, ParallelIndexer.this.convertTime(end), Float.valueOf(ParallelIndexer.this.overallCount > 0 ? (float)end / (float)ParallelIndexer.this.overallCount : -1.0f), ParallelIndexer.this.queue.size());
                    Thread.sleep(gap);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void killMonitoring() {
            this.killMonitor = true;
        }
    }

    class Consumer
    implements Runnable {
        private LocalDocumentBuilder localDocumentBuilder;
        private SimpleDocumentBuilder simpleDocumentBuilder;
        private GlobalDocumentBuilder globalDocumentBuilder;
        private DocumentBuilder localCustomDocumentBuilder;
        private boolean locallyEnded;

        public Consumer() {
            this.localDocumentBuilder = new LocalDocumentBuilder(ParallelIndexer.this.aggregator);
            this.simpleDocumentBuilder = new SimpleDocumentBuilder(ParallelIndexer.this.aggregator);
            this.globalDocumentBuilder = new GlobalDocumentBuilder(ParallelIndexer.this.globalHashing, ParallelIndexer.this.globalHashingMode, ParallelIndexer.this.useDocValues);
            for (Map.Entry listEntry : ParallelIndexer.this.LocalExtractorsAndCodebooks.entrySet()) {
                this.localDocumentBuilder.addExtractor(((ExtractorItem)listEntry.getKey()).clone(), (LinkedList<Cluster[]>)((LinkedList)listEntry.getValue()));
            }
            for (Map.Entry listEntry : ParallelIndexer.this.SimpleExtractorsAndCodebooks.entrySet()) {
                this.simpleDocumentBuilder.addExtractor(((ExtractorItem)listEntry.getKey()).clone(), (LinkedList)listEntry.getValue());
            }
            for (ExtractorItem globalExtractor : ParallelIndexer.this.GlobalExtractors) {
                this.globalDocumentBuilder.addExtractor(globalExtractor.clone());
            }
            try {
                this.localCustomDocumentBuilder = ParallelIndexer.this.customDocumentBuilder != null ? (DocumentBuilder)ParallelIndexer.this.customDocumentBuilder.newInstance() : new GlobalDocumentBuilder(false);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
            this.locallyEnded = false;
        }

        @Override
        public void run() {
            while (!this.locallyEnded) {
                try {
                    Field[] fields;
                    WorkItem tmp;
                    if (ParallelIndexer.this.queue.peek() == null) {
                        Thread.sleep((long)((Math.random() / 2.0 + 0.5) * 10000.0));
                    }
                    if ((tmp = (WorkItem)ParallelIndexer.this.queue.take()).getFileName() == null) {
                        this.locallyEnded = true;
                    } else {
                        ParallelIndexer.this.overallCount++;
                    }
                    if (this.locallyEnded) continue;
                    BufferedImage image = ImageIO.read(new ByteArrayInputStream(tmp.getBuffer()));
                    if (ParallelIndexer.this.imagePreprocessor != null) {
                        image = ParallelIndexer.this.imagePreprocessor.process(image);
                    }
                    Document doc = this.localCustomDocumentBuilder.createDocument(image, tmp.getFileName());
                    for (Field field : fields = this.globalDocumentBuilder.createDescriptorFields(image)) {
                        doc.add((IndexableField)field);
                    }
                    for (Field field : fields = this.localDocumentBuilder.createDescriptorFields(image)) {
                        doc.add((IndexableField)field);
                    }
                    for (Field field : fields = this.simpleDocumentBuilder.createDescriptorFields(image)) {
                        doc.add((IndexableField)field);
                    }
                    ParallelIndexer.this.writer.addDocument((Iterable)doc);
                }
                catch (IOException | InterruptedException e) {
                    ParallelIndexer.this.log.severe(e.getMessage());
                }
                catch (Exception e) {
                    ParallelIndexer.this.log.severe(e.getMessage());
                }
            }
        }
    }

    class ConsumerForGlobalSample
    implements Runnable {
        private GlobalDocumentBuilder globalDocumentBuilder;
        private boolean locallyEnded;

        public ConsumerForGlobalSample() {
            this.globalDocumentBuilder = new GlobalDocumentBuilder(ParallelIndexer.this.globalHashing, ParallelIndexer.this.globalHashingMode, ParallelIndexer.this.useDocValues);
            for (ExtractorItem globalExtractor : ParallelIndexer.this.GlobalExtractors) {
                this.globalDocumentBuilder.addExtractor(globalExtractor.clone());
            }
            this.locallyEnded = false;
        }

        @Override
        public void run() {
            while (!this.locallyEnded) {
                try {
                    WorkItem tmp = (WorkItem)ParallelIndexer.this.queue.take();
                    if (tmp.getFileName() == null) {
                        this.locallyEnded = true;
                    } else {
                        ParallelIndexer.this.overallCount++;
                    }
                    if (this.locallyEnded) continue;
                    BufferedImage image = ImageIO.read(new ByteArrayInputStream(tmp.getBuffer()));
                    if (ParallelIndexer.this.imagePreprocessor != null) {
                        image = ParallelIndexer.this.imagePreprocessor.process(image);
                    }
                    Field[] fields = this.globalDocumentBuilder.createDescriptorFields(image);
                    Document doc = (Document)ParallelIndexer.this.allDocuments.get(tmp.getFileName());
                    for (Field field : fields) {
                        doc.add((IndexableField)field);
                    }
                }
                catch (IOException | InterruptedException e) {
                    ParallelIndexer.this.log.severe(e.getMessage());
                }
            }
        }
    }

    class ConsumerForLocalSample
    implements Runnable {
        private AbstractLocalDocumentBuilder documentBuilder;
        private ExtractorItem localExtractorItem;
        private LinkedList<Cluster[]> clusters;
        private boolean locallyEnded;

        public ConsumerForLocalSample(ExtractorItem extractorItem, LinkedList<Cluster[]> clusters) {
            ExtractorItem tmpExtractorItem = extractorItem.clone();
            if (extractorItem.isLocal()) {
                this.documentBuilder = new LocalDocumentBuilder(tmpExtractorItem, clusters, (Class<? extends AbstractAggregator>)ParallelIndexer.this.aggregator);
            } else if (extractorItem.isSimple()) {
                this.documentBuilder = new SimpleDocumentBuilder(tmpExtractorItem, clusters, (Class<? extends AbstractAggregator>)ParallelIndexer.this.aggregator);
            } else {
                throw new UnsupportedOperationException("Something is wrong!! (ConsumerForLocalSample)");
            }
            this.localExtractorItem = tmpExtractorItem;
            this.clusters = clusters;
            this.locallyEnded = false;
        }

        @Override
        public void run() {
            while (!this.locallyEnded) {
                try {
                    WorkItem tmp = (WorkItem)ParallelIndexer.this.queue.take();
                    if (tmp.getFileName() == null) {
                        this.locallyEnded = true;
                    } else {
                        ParallelIndexer.this.overallCount++;
                    }
                    if (this.locallyEnded) continue;
                    Field[] fields = this.documentBuilder.createLocalDescriptorFields(tmp.getListOfFeatures(), this.localExtractorItem, this.clusters);
                    Document doc = (Document)ParallelIndexer.this.allDocuments.get(tmp.getFileName());
                    for (Field field : fields) {
                        doc.add((IndexableField)field);
                    }
                }
                catch (InterruptedException e) {
                    ParallelIndexer.this.log.severe(e.getMessage());
                }
            }
        }
    }

    class ExtractorForLocalSample
    implements Runnable {
        private AbstractLocalDocumentBuilder documentBuilder;
        private ExtractorItem extractorItem;
        private boolean locallyEnded;

        public ExtractorForLocalSample(ExtractorItem extractorItem) {
            if (extractorItem.isLocal()) {
                this.documentBuilder = new LocalDocumentBuilder();
            } else if (extractorItem.isSimple()) {
                this.documentBuilder = new SimpleDocumentBuilder();
            } else {
                throw new UnsupportedOperationException("Something is wrong!! (ExtractorForLocalSample)");
            }
            this.extractorItem = extractorItem.clone();
            this.locallyEnded = false;
        }

        @Override
        public void run() {
            while (!this.locallyEnded) {
                try {
                    WorkItem tmp = (WorkItem)ParallelIndexer.this.queue.take();
                    if (tmp.getFileName() == null) {
                        this.locallyEnded = true;
                    } else {
                        ParallelIndexer.this.overallCount++;
                    }
                    if (this.locallyEnded) continue;
                    ByteArrayInputStream b = new ByteArrayInputStream(tmp.getBuffer());
                    BufferedImage image = ImageIO.read(b);
                    if (ParallelIndexer.this.imagePreprocessor != null) {
                        image = ParallelIndexer.this.imagePreprocessor.process(image);
                    }
                    ParallelIndexer.this.conSampleMap.put(tmp.getFileName(), this.documentBuilder.extractLocalFeatures(image, (LocalFeatureExtractor)this.extractorItem.getExtractorInstance()).getFeatures());
                }
                catch (IOException | InterruptedException e) {
                    ParallelIndexer.this.log.severe(e.getMessage());
                }
            }
        }
    }

    class ProducerForLocalSample
    implements Runnable {
        private ConcurrentHashMap<String, List<? extends LocalFeature>> localSampleList;

        public ProducerForLocalSample(ConcurrentHashMap<String, List<? extends LocalFeature>> localSampleList) {
            this.localSampleList = localSampleList;
            ParallelIndexer.this.overallCount = 0;
            ParallelIndexer.this.queue.clear();
        }

        @Override
        public void run() {
            for (Map.Entry<String, List<? extends LocalFeature>> listEntry : this.localSampleList.entrySet()) {
                try {
                    ParallelIndexer.this.queue.put(new WorkItem(listEntry.getKey(), listEntry.getValue()));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            String path = null;
            List<? extends LocalFeature> listOfFeatures = null;
            for (int i = 0; i < ParallelIndexer.this.numOfThreads * 3; ++i) {
                try {
                    ParallelIndexer.this.queue.put(new WorkItem(path, listOfFeatures));
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class Producer
    implements Runnable {
        private List<String> localList;

        public Producer(List<String> localList) {
            this.localList = localList;
            ParallelIndexer.this.overallCount = 0;
            ParallelIndexer.this.queue.clear();
        }

        @Override
        public void run() {
            for (String path : this.localList) {
                File next = new File(path);
                try {
                    int fileSize = (int)next.length();
                    byte[] buffer = new byte[fileSize];
                    FileInputStream fis = new FileInputStream(next);
                    FileChannel channel = fis.getChannel();
                    MappedByteBuffer map = channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileSize);
                    map.load();
                    map.get(buffer);
                    ParallelIndexer.this.queue.put(new WorkItem(path, buffer));
                    channel.close();
                    fis.close();
                }
                catch (Exception e) {
                    System.err.println("Could not open " + path + ". " + e.getMessage());
                }
            }
            String path = null;
            byte[] buffer = null;
            for (int i = 0; i < ParallelIndexer.this.numOfThreads * 3; ++i) {
                try {
                    ParallelIndexer.this.queue.put(new WorkItem(path, buffer));
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

