/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.indexers.tools;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import javax.imageio.ImageIO;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class Extractor
implements Runnable {
    public static final String[] features = new String[]{"net.semanticmetadata.lire.imageanalysis.features.global.CEDD", "net.semanticmetadata.lire.imageanalysis.features.global.FCTH", "net.semanticmetadata.lire.imageanalysis.features.global.OpponentHistogram", "net.semanticmetadata.lire.imageanalysis.features.global.JointHistogram", "net.semanticmetadata.lire.imageanalysis.features.global.AutoColorCorrelogram", "net.semanticmetadata.lire.imageanalysis.features.global.ColorLayout", "net.semanticmetadata.lire.imageanalysis.features.global.EdgeHistogram", "net.semanticmetadata.lire.imageanalysis.features.global.Gabor", "net.semanticmetadata.lire.imageanalysis.features.global.JCD", "net.semanticmetadata.lire.imageanalysis.features.global.JpegCoefficientHistogram", "net.semanticmetadata.lire.imageanalysis.features.global.ScalableColor", "net.semanticmetadata.lire.imageanalysis.features.global.SimpleColorHistogram", "net.semanticmetadata.lire.imageanalysis.features.global.Tamura", "net.semanticmetadata.lire.imageanalysis.features.global.LuminanceLayout", "net.semanticmetadata.lire.imageanalysis.features.global.PHOG", "net.semanticmetadata.lire.imageanalysis.features.global.LocalBinaryPatterns"};
    public static final String[] featureFieldNames = new String[]{"CEDD", "FCTH", "OppHist", "JointHist", "ACC", "CLD", "EHD", "Gabor", "JCD", "JpegCoeffs", "SCD", "ColorHist", "TAMURA", "LuminLayout", "PHOG", "LBP"};
    static HashMap<String, Integer> feature2index = new HashMap(features.length);
    LinkedList<GlobalFeature> listOfFeatures = new LinkedList();
    File fileList = null;
    File outFile = null;

    public void addFeature(GlobalFeature feature) {
        this.listOfFeatures.add(feature);
    }

    public void setFileList(File fileList) {
        this.fileList = fileList;
    }

    public void setOutFile(File outFile) {
        this.outFile = outFile;
    }

    public static void main(String[] args) throws IOException {
        Extractor e = new Extractor();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-i")) {
                if (i + 1 < args.length) {
                    e.setFileList(new File(args[i + 1]));
                    continue;
                }
                Extractor.printHelp();
                continue;
            }
            if (arg.startsWith("-o")) {
                if (i + 1 < args.length) {
                    e.setOutFile(new File(args[i + 1]));
                    continue;
                }
                Extractor.printHelp();
                continue;
            }
            if (arg.startsWith("-h")) {
                Extractor.printHelp();
                continue;
            }
            if (!arg.startsWith("-c")) continue;
            Properties p = new Properties();
            p.load(new FileInputStream(new File(args[i + 1])));
            Enumeration<?> enumeration = p.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (!key.toLowerCase().startsWith("feature.")) continue;
                try {
                    e.addFeature((GlobalFeature)Class.forName(p.getProperty(key)).newInstance());
                }
                catch (Exception e1) {
                    System.err.println("Could not add feature named " + p.getProperty(key));
                    e1.printStackTrace();
                }
            }
        }
        if (!e.isConfigured()) {
            Extractor.printHelp();
        } else {
            e.run();
        }
    }

    private boolean isConfigured() {
        boolean configured = true;
        if (this.fileList == null || !this.fileList.exists()) {
            configured = false;
        } else if (this.outFile == null) {
            try {
                this.outFile = new File(this.fileList.getCanonicalPath() + ".data");
                System.out.println("Setting out file to " + this.outFile.getCanonicalFile());
            }
            catch (IOException e) {
                configured = false;
            }
        } else if (this.outFile.exists()) {
            System.err.println(this.outFile.getName() + " already exists. Please delete or choose another outfile.");
            configured = false;
        }
        if (this.listOfFeatures.size() < 1) {
            configured = false;
        }
        return configured;
    }

    private static void printHelp() {
        System.out.println("Help for the Extractor class.\n=============================\nThis help text is shown if you start the Extractor with the '-h' option.\n\n1. Usage\n========\n$> Extractor -i <infile> [-o <outfile>] -c <configfile>\n\nNote: if you don't specify an outfile just \".data\" is appended to the infile for output.\n\n2. Config File\n==============\nThe config file is a simple java Properties file. It basically gives the \nemployed features as a list of properties, just like:\n\nfeature.1=CEDD\nfeature.2=FCTH\n\n... and so on. ");
    }

    @Override
    public void run() {
        if (this.fileList == null || !this.fileList.exists()) {
            System.err.println("No text file with a list of images given.");
            return;
        }
        if (this.listOfFeatures.size() == 0) {
            System.err.println("No features to extract given.");
            return;
        }
        byte[] myBuffer = new byte[0xA00000];
        int bufferCount = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.fileList));
            FileOutputStream dos = new FileOutputStream(this.outFile);
            String file = null;
            String outFilePath = this.outFile.getCanonicalPath();
            long ms = System.currentTimeMillis();
            int count = 0;
            while ((file = br.readLine()) != null) {
                File input = new File(file);
                String relFile = input.getCanonicalPath();
                try {
                    BufferedImage img = ImageIO.read(input);
                    byte[] tmpBytes = relFile.getBytes();
                    System.arraycopy(SerializationUtils.toBytes(tmpBytes.length), 0, myBuffer, 0, 4);
                    System.arraycopy(tmpBytes, 0, myBuffer, bufferCount += 4, tmpBytes.length);
                    bufferCount += tmpBytes.length;
                    for (GlobalFeature feature : this.listOfFeatures) {
                        feature.extract(img);
                        myBuffer[bufferCount] = (byte)feature2index.get(feature.getClass().getName()).intValue();
                        tmpBytes = feature.getByteArrayRepresentation();
                        System.arraycopy(SerializationUtils.toBytes(tmpBytes.length), 0, myBuffer, ++bufferCount, 4);
                        System.arraycopy(tmpBytes, 0, myBuffer, bufferCount += 4, tmpBytes.length);
                        bufferCount += tmpBytes.length;
                    }
                    ((OutputStream)dos).write(myBuffer, 0, bufferCount);
                    ((OutputStream)dos).write(-1);
                    bufferCount = 0;
                    ++count;
                }
                catch (Exception e) {
                    System.err.println("Error processing image " + relFile + ": " + e.getMessage());
                    e.printStackTrace();
                }
                if (count % 100 != 0 || count <= 0) continue;
                System.out.println(count + " files processed, " + (System.currentTimeMillis() - ms) / (long)count + " ms per file.");
            }
            dos.flush();
            ((OutputStream)dos).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        for (int i = 0; i < features.length; ++i) {
            feature2index.put(features[i], i);
        }
    }
}

