/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.indexers.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.global.PHOG;
import net.semanticmetadata.lire.indexers.hashing.BitSampling;
import net.semanticmetadata.lire.indexers.tools.Indexor;
import net.semanticmetadata.lire.utils.SerializationUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;

public class HashingIndexor
extends Indexor {
    protected Class featureClass = PHOG.class;

    public static void main(String[] args) throws IOException, IllegalAccessException, InstantiationException {
        HashingIndexor indexor = new HashingIndexor();
        BitSampling.readHashFunctions();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-i") || arg.startsWith("--input-file")) {
                if (i + 1 < args.length) {
                    indexor.addInputFile(new File(args[i + 1]));
                    continue;
                }
                HashingIndexor.printHelp();
                continue;
            }
            if (arg.startsWith("-l") || arg.startsWith("--index")) {
                if (i + 1 < args.length) {
                    indexor.setIndexPath(args[i + 1]);
                    continue;
                }
                HashingIndexor.printHelp();
                continue;
            }
            if (arg.startsWith("-f") || arg.startsWith("--feature")) {
                if (i + 1 < args.length) {
                    try {
                        indexor.setFeatureClass(Class.forName(args[i + 1]));
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("Could not find feature class named " + args[i + 1]);
                        HashingIndexor.printHelp();
                    }
                    continue;
                }
                HashingIndexor.printHelp();
                continue;
            }
            if (arg.startsWith("-h")) {
                HashingIndexor.printHelp();
                continue;
            }
            if (arg.startsWith("-s")) {
                verbose = false;
                continue;
            }
            if (!arg.startsWith("-c")) continue;
            if (i + 1 < args.length) {
                String file;
                BufferedReader br = new BufferedReader(new FileReader(new File(args[i + 1])));
                while ((file = br.readLine()) != null) {
                    if (file.trim().length() <= 2) continue;
                    File f = new File(file);
                    if (f.exists()) {
                        indexor.addInputFile(f);
                        continue;
                    }
                    System.err.println("Did not find file " + f.getName());
                }
                continue;
            }
            HashingIndexor.printHelp();
        }
        if (!indexor.isConfigured()) {
            HashingIndexor.printHelp();
        } else {
            indexor.run();
        }
    }

    public void setFeatureClass(Class featureClass) {
        this.featureClass = featureClass;
    }

    @Override
    protected void addToDocument(GlobalFeature feature, Document document, String featureFieldName) {
        if (feature.getClass().getCanonicalName().equals(this.featureClass.getCanonicalName())) {
            int[] hashes = BitSampling.generateHashes(feature.getFeatureVector());
            document.add((IndexableField)new TextField(featureFieldName + "_hash", SerializationUtils.arrayToString(hashes), Field.Store.YES));
            document.add((IndexableField)new StoredField(featureFieldName, feature.getByteArrayRepresentation()));
        }
    }
}

