/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.indexers.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.indexers.tools.Extractor;
import net.semanticmetadata.lire.utils.LuceneUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;

public class Indexor {
    protected LinkedList<File> inputFiles = new LinkedList();
    protected String indexPath = null;
    protected static boolean verbose = true;
    protected int count;

    public static void main(String[] args) throws IOException, IllegalAccessException, InstantiationException {
        Indexor indexor = new Indexor();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-i") || arg.startsWith("--input-file")) {
                if (i + 1 < args.length) {
                    indexor.addInputFile(new File(args[i + 1]));
                    continue;
                }
                Indexor.printHelp();
                continue;
            }
            if (arg.startsWith("-l") || arg.startsWith("--index")) {
                if (i + 1 < args.length) {
                    indexor.setIndexPath(args[i + 1]);
                    continue;
                }
                Indexor.printHelp();
                continue;
            }
            if (arg.startsWith("-h")) {
                Indexor.printHelp();
                continue;
            }
            if (arg.startsWith("-s")) {
                verbose = false;
                continue;
            }
            if (!arg.startsWith("-c")) continue;
            if (i + 1 < args.length) {
                String file;
                BufferedReader br = new BufferedReader(new FileReader(new File(args[i + 1])));
                while ((file = br.readLine()) != null) {
                    if (file.trim().length() <= 2) continue;
                    File f = new File(file);
                    if (f.exists()) {
                        indexor.addInputFile(f);
                        continue;
                    }
                    System.err.println("Did not find file " + f.getCanonicalPath());
                }
                continue;
            }
            Indexor.printHelp();
        }
        if (!indexor.isConfigured()) {
            Indexor.printHelp();
        } else {
            indexor.run();
        }
    }

    protected boolean isConfigured() {
        boolean isConfigured = true;
        if (this.inputFiles.size() > 0) {
            for (File next : this.inputFiles) {
                if (next.exists()) continue;
                isConfigured = false;
                System.err.println("Input file " + next.getPath() + " does not exist.");
            }
        }
        return isConfigured;
    }

    protected static void printHelp() {
        System.out.println("Help for the Indexor class.\n===========================\nThis help text is shown if you start the Indexor with the '-h' option.\n\nUsage\n=====\n$> Indexor -i <input-file> -l <index-directory>\n\nor \n\n$> Indexor -c <file-list> -l <index-directory>\n\nwith \n\n<input-file> ... \t\ta single output file of Extractor.\n<index-directory> ...\tthe index to write the data to (it's appended).\n<file-list> ...\t\t\ta file containing data files one per line.\n");
    }

    public void run() {
        try {
            IndexWriter indexWriter = LuceneUtils.createIndexWriter(this.indexPath, false, LuceneUtils.AnalyzerType.WhitespaceAnalyzer);
            for (File inputFile : this.inputFiles) {
                if (verbose) {
                    System.out.println("Processing " + inputFile.getPath() + ".");
                }
                this.readFile(indexWriter, inputFile);
                if (!verbose) continue;
                System.out.println("Indexing finished.");
            }
            LuceneUtils.commitWriter(indexWriter);
            LuceneUtils.closeWriter(indexWriter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readFile(IndexWriter indexWriter, File inputFile) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        int tmp;
        FileInputStream in = new FileInputStream(inputFile);
        byte[] tempInt = new byte[4];
        this.count = 0;
        byte[] temp = new byte[102400];
        while ((tmp = ((InputStream)in).read(tempInt, 0, 4)) > 0) {
            Document d = new Document();
            tmp = SerializationUtils.toInt(tempInt);
            ((InputStream)in).read(temp, 0, tmp);
            String filename = new String(temp, 0, tmp);
            d.add((IndexableField)new StringField("ImageIdentifier", filename, Field.Store.YES));
            while (((InputStream)in).read(tempInt, 0, 1) > 0 && tempInt[0] != -1) {
                byte tmpFeature = tempInt[0];
                GlobalFeature f = (GlobalFeature)Class.forName(Extractor.features[tmpFeature]).newInstance();
                ((InputStream)in).read(tempInt, 0, 4);
                tmp = SerializationUtils.toInt(tempInt);
                ((InputStream)in).read(temp, 0, tmp);
                f.setByteArrayRepresentation(temp, 0, tmp);
                this.addToDocument(f, d, Extractor.featureFieldNames[tmpFeature]);
            }
            indexWriter.addDocument((Iterable)d);
            ++this.count;
            if (!verbose) continue;
            if (this.count % 100 == 0) {
                System.out.print('.');
            }
            if (this.count % 1000 != 0) continue;
            System.out.println(" " + this.count);
        }
        if (verbose) {
            System.out.println(" " + this.count);
        }
        ((InputStream)in).close();
    }

    protected void addToDocument(GlobalFeature feature, Document document, String featureFieldName) {
        document.add((IndexableField)new StoredField(featureFieldName, feature.getByteArrayRepresentation()));
    }

    public void addInputFile(File inputFile) {
        this.inputFiles.add(inputFile);
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }
}

