/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.indexers.tools;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import javax.imageio.ImageIO;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.indexers.parallel.WorkItem;
import net.semanticmetadata.lire.utils.ImageUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class ParallelExtractor
implements Runnable {
    public static final String[] features = new String[]{"CEDD", "FCTH", "OpponentHistogram", "JointHistogram", "AutoColorCorrelogram", "ColorLayout", "EdgeHistogram", "Gabor", "JCD", "JpegCoefficientHistogram", "ScalableColor", "SimpleColorHistogram", "Tamura", "LuminanceLayout", "PHOG", "LocalBinaryPatterns"};
    public static final String[] featureFieldNames = new String[]{"CEDD", "FCTH", "OppHist", "JointHist", "ACC", "CLD", "EHD", "Gabor", "JCD", "JpegCoeffs", "SCD", "ColorHist", "TAMURA", "LuminLayout", "PHOG", "LBP"};
    static HashMap<String, Integer> feature2index = new HashMap(features.length);
    private static boolean force;
    private static int numberOfThreads;
    LinkedBlockingQueue<WorkItem> images = new LinkedBlockingQueue(200);
    boolean ended = false;
    int overallCount = 0;
    OutputStream dos = null;
    LinkedList<GlobalFeature> listOfFeatures = new LinkedList();
    File fileList = null;
    File outFile = null;
    private int monitoringInterval = 10;
    private int maxSideLength = -1;

    public static void setNumberOfThreads(int numberOfThreads) {
        ParallelExtractor.numberOfThreads = numberOfThreads;
    }

    public static void main(String[] args) throws IOException {
        ParallelExtractor e = new ParallelExtractor();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-i")) {
                if (i + 1 < args.length) {
                    e.setFileList(new File(args[i + 1]));
                    continue;
                }
                System.err.println("Please give a input file after the -i option.");
                ParallelExtractor.printHelp();
                continue;
            }
            if (arg.startsWith("-o")) {
                if (i + 1 < args.length) {
                    e.setOutFile(new File(args[i + 1]));
                    continue;
                }
                System.err.println("Please name an outfile after the -o option.");
                ParallelExtractor.printHelp();
                continue;
            }
            if (arg.startsWith("-m")) {
                if (i + 1 < args.length) {
                    try {
                        int s = Integer.parseInt(args[i + 1]);
                        if (s <= 10) continue;
                        e.setMaxSideLength(s);
                    }
                    catch (NumberFormatException e1) {
                        e1.printStackTrace();
                        ParallelExtractor.printHelp();
                    }
                    continue;
                }
                ParallelExtractor.printHelp();
                continue;
            }
            if (arg.startsWith("-f")) {
                force = true;
                continue;
            }
            if (arg.startsWith("-h")) {
                ParallelExtractor.printHelp();
                continue;
            }
            if (arg.startsWith("-n")) {
                if (i + 1 < args.length) {
                    try {
                        numberOfThreads = Integer.parseInt(args[i + 1]);
                    }
                    catch (Exception e1) {
                        System.err.println("Could not set number of threads to \"" + args[i + 1] + "\".");
                        e1.printStackTrace();
                    }
                    continue;
                }
                ParallelExtractor.printHelp();
                continue;
            }
            if (!arg.startsWith("-c")) continue;
            Properties p = new Properties();
            p.load(new FileInputStream(new File(args[i + 1])));
            Enumeration<?> enumeration = p.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (!key.toLowerCase().startsWith("feature.")) continue;
                try {
                    e.addFeature((GlobalFeature)Class.forName(p.getProperty(key)).newInstance());
                }
                catch (Exception e1) {
                    System.err.println("Could not add feature named " + p.getProperty(key));
                    e1.printStackTrace();
                }
            }
        }
        if (!e.isConfigured()) {
            System.err.println("There is an error in the configuration.");
            ParallelExtractor.printHelp();
        } else {
            e.run();
        }
    }

    private static void printHelp() {
        System.out.println("Help for the ParallelExtractor class.\n=============================\nThis help text is shown if you start the ParallelExtractor with the '-h' option.\n\n1. Usage\n========\n$> ParallelExtractor -i <infile> [-o <outfile>] -c <configfile> [-n <threads>] [-m <max_side_length>]\n\nNote: if you don't specify an outfile just \".data\" is appended to the infile for output.\n\n2. Config File\n==============\nThe config file is a simple java Properties file. It basically gives the \nemployed features as a list of properties, just like:\n\nfeature.1=CEDD\nfeature.2=FCTH\n\n... and so on. ");
    }

    public void addFeature(GlobalFeature feature) {
        this.listOfFeatures.add(feature);
    }

    public void setFileList(File fileList) {
        this.fileList = fileList;
    }

    public void setOutFile(File outFile) {
        this.outFile = outFile;
    }

    public int getMaxSideLength() {
        return this.maxSideLength;
    }

    public void setMaxSideLength(int maxSideLength) {
        this.maxSideLength = maxSideLength;
    }

    private boolean isConfigured() {
        boolean configured = true;
        if (this.fileList == null || !this.fileList.exists()) {
            System.err.println("Input file is either not given or does not exist.");
            configured = false;
        } else if (this.outFile == null) {
            try {
                this.outFile = new File(this.fileList.getCanonicalPath() + ".data");
                System.out.println("Setting out file to " + this.outFile.getCanonicalFile());
            }
            catch (IOException e) {
                configured = false;
            }
        } else if (this.outFile.exists() && !force) {
            System.err.println(this.outFile.getName() + " already exists. Please delete or choose another outfile.");
            configured = false;
        }
        if (this.listOfFeatures.size() < 1) {
            configured = false;
        }
        return configured;
    }

    @Override
    public void run() {
        if (this.fileList == null || !this.fileList.exists()) {
            System.err.println("No text file with a list of images given.");
            return;
        }
        if (this.listOfFeatures.size() == 0) {
            System.err.println("No features to extract given.");
            return;
        }
        try {
            this.dos = new BufferedOutputStream(new FileOutputStream(this.outFile));
            Thread p = new Thread(new Producer());
            p.start();
            LinkedList<Thread> threads = new LinkedList<Thread>();
            long l = System.currentTimeMillis();
            for (int i = 0; i < numberOfThreads; ++i) {
                Thread c = new Thread(new Consumer());
                c.start();
                threads.add(c);
            }
            Thread m = new Thread(new Monitoring());
            m.start();
            Iterator iterator = threads.iterator();
            while (iterator.hasNext()) {
                ((Thread)iterator.next()).join();
            }
            long l1 = System.currentTimeMillis() - l;
            System.out.println("Analyzed " + this.overallCount + " images in " + l1 / 1000L + " seconds, ~" + (this.overallCount > 0 ? Long.valueOf(l1 / (long)this.overallCount) : "inf.") + " ms each.");
            this.dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addFeatures(List features) {
        for (GlobalFeature next : this.listOfFeatures) {
            try {
                features.add(next.getClass().newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        for (int i = 0; i < features.length; ++i) {
            feature2index.put(features[i], i);
        }
        force = false;
        numberOfThreads = 16;
    }

    class Consumer
    implements Runnable {
        WorkItem tmp = null;
        LinkedList<GlobalFeature> features = new LinkedList();
        int count = 0;
        boolean locallyEnded = false;

        Consumer() {
            ParallelExtractor.this.addFeatures(this.features);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] myBuffer = new byte[0xA00000];
            int bufferCount = 0;
            while (!this.locallyEnded) {
                try {
                    if (!this.locallyEnded) {
                        this.tmp = ParallelExtractor.this.images.take();
                        if (this.tmp.getBuffer() == null) {
                            this.locallyEnded = true;
                        } else {
                            ++this.count;
                            ++ParallelExtractor.this.overallCount;
                        }
                    }
                    bufferCount = 0;
                    if (this.locallyEnded) continue;
                    ByteArrayInputStream b = new ByteArrayInputStream(this.tmp.getBuffer());
                    BufferedImage img = ImageIO.read(b);
                    if (ParallelExtractor.this.maxSideLength > 50) {
                        img = ImageUtils.scaleImage(img, ParallelExtractor.this.maxSideLength);
                    }
                    byte[] tmpBytes = this.tmp.getFileName().getBytes();
                    System.arraycopy(SerializationUtils.toBytes(tmpBytes.length), 0, myBuffer, 0, 4);
                    System.arraycopy(tmpBytes, 0, myBuffer, bufferCount += 4, tmpBytes.length);
                    bufferCount += tmpBytes.length;
                    for (GlobalFeature feature : this.features) {
                        feature.extract(img);
                        myBuffer[bufferCount] = (byte)feature2index.get(feature.getClass().getSimpleName()).intValue();
                        tmpBytes = feature.getByteArrayRepresentation();
                        System.arraycopy(SerializationUtils.toBytes(tmpBytes.length), 0, myBuffer, ++bufferCount, 4);
                        System.arraycopy(tmpBytes, 0, myBuffer, bufferCount += 4, tmpBytes.length);
                        bufferCount += tmpBytes.length;
                    }
                    OutputStream outputStream = ParallelExtractor.this.dos;
                    synchronized (outputStream) {
                        ParallelExtractor.this.dos.write(myBuffer, 0, bufferCount);
                        ParallelExtractor.this.dos.write(-1);
                        ParallelExtractor.this.dos.flush();
                    }
                }
                catch (Exception e) {
                    System.err.println("Error processing file " + this.tmp.getFileName());
                    e.printStackTrace();
                }
            }
        }
    }

    class Producer
    implements Runnable {
        Producer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean tmpSize = false;
            try {
                BufferedReader br = new BufferedReader(new FileReader(ParallelExtractor.this.fileList));
                String file = null;
                File next = null;
                while ((file = br.readLine()) != null) {
                    next = new File(file);
                    Object img = null;
                    try {
                        int fileSize = (int)next.length();
                        byte[] buffer = new byte[fileSize];
                        FileInputStream fis = new FileInputStream(next);
                        fis.read(buffer);
                        String path = next.getCanonicalPath();
                        ParallelExtractor.this.images.put(new WorkItem(path, buffer));
                    }
                    catch (Exception e) {
                        System.err.println("Could not read image " + file + ": " + e.getMessage());
                    }
                }
                for (int i = 0; i < numberOfThreads * 2; ++i) {
                    String tmpString = null;
                    byte[] tmpBuffer = null;
                    try {
                        ParallelExtractor.this.images.put(new WorkItem(tmpString, tmpBuffer));
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            LinkedBlockingQueue<WorkItem> linkedBlockingQueue = ParallelExtractor.this.images;
            synchronized (linkedBlockingQueue) {
                ParallelExtractor.this.ended = true;
                ParallelExtractor.this.images.notifyAll();
            }
        }
    }

    class Monitoring
    implements Runnable {
        Monitoring() {
        }

        @Override
        public void run() {
            long ms = System.currentTimeMillis();
            try {
                Thread.sleep(1000 * ParallelExtractor.this.monitoringInterval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (!ParallelExtractor.this.ended) {
                try {
                    long time = System.currentTimeMillis() - ms;
                    System.out.printf("Analyzed %,d images in %,d seconds, %s ms each (%,d images currently in queue).\n", ParallelExtractor.this.overallCount, time / 1000L, ParallelExtractor.this.overallCount > 0 ? Long.valueOf(time / (long)ParallelExtractor.this.overallCount) : "n.a.", ParallelExtractor.this.images.size());
                    Thread.sleep(1000 * ParallelExtractor.this.monitoringInterval);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

