/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.indexers.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.global.CEDD;
import net.semanticmetadata.lire.indexers.tools.Extractor;
import net.semanticmetadata.lire.searchers.SimpleResult;
import net.semanticmetadata.lire.utils.LuceneUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;

public class ProximityHashingIndexor {
    protected LinkedList<File> inputFiles = new LinkedList();
    protected String indexPath = null;
    private boolean overwriteIndex = true;
    protected static boolean verbose = true;
    int run = 0;
    int docCount = 0;
    HashSet<Integer> representativesID;
    ArrayList<GlobalFeature> representatives;
    protected Class featureClass = CEDD.class;
    private TreeSet<SimpleResult> hashingResultScoreDocs = new TreeSet();
    private double maxDistance;
    private double tmpScore;
    int maximumHits = 50;
    private int[] result = new int[this.maximumHits];

    public static void main(String[] args) throws IOException, IllegalAccessException, InstantiationException {
        ProximityHashingIndexor indexor = new ProximityHashingIndexor();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-i") || arg.startsWith("--input-file")) {
                if (i + 1 < args.length) {
                    indexor.addInputFile(new File(args[i + 1]));
                    continue;
                }
                ProximityHashingIndexor.printHelp();
                continue;
            }
            if (arg.startsWith("-l") || arg.startsWith("--index")) {
                if (i + 1 < args.length) {
                    indexor.setIndexPath(args[i + 1]);
                    continue;
                }
                ProximityHashingIndexor.printHelp();
                continue;
            }
            if (arg.startsWith("-h")) {
                ProximityHashingIndexor.printHelp();
                continue;
            }
            if (arg.startsWith("-s")) {
                verbose = false;
                continue;
            }
            if (!arg.startsWith("-c")) continue;
            if (i + 1 < args.length) {
                String file;
                BufferedReader br = new BufferedReader(new FileReader(new File(args[i + 1])));
                while ((file = br.readLine()) != null) {
                    if (file.trim().length() <= 2) continue;
                    File f = new File(file);
                    if (f.exists()) {
                        indexor.addInputFile(f);
                        continue;
                    }
                    System.err.println("Did not find file " + f.getCanonicalPath());
                }
                continue;
            }
            ProximityHashingIndexor.printHelp();
        }
        if (!indexor.isConfigured()) {
            ProximityHashingIndexor.printHelp();
        } else {
            indexor.run();
        }
    }

    protected boolean isConfigured() {
        boolean isConfigured = true;
        if (this.inputFiles.size() > 0) {
            for (File next : this.inputFiles) {
                if (next.exists()) continue;
                isConfigured = false;
                System.err.println("Input file " + next.getPath() + " does not exist.");
            }
        }
        return isConfigured;
    }

    protected static void printHelp() {
        System.out.println("Help for the Indexor class.\n===========================\nThis help text is shown if you start the Indexor with the '-h' option.\n\nUsage\n=====\n$> Indexor -i <input-file> -l <index-directory>\n\nor \n\n$> Indexor -c <file-list> -l <index-directory>\n\nwith \n\n<input-file> ... \t\ta single output file of Extractor.\n<index-directory> ...\tthe index to write the data to (it's appended).\n<file-list> ...\t\t\ta file containing data files one per line.\n");
    }

    public void setFeatureClass(Class featureClass) {
        this.featureClass = featureClass;
    }

    public void run() {
        try {
            IndexWriter indexWriter = LuceneUtils.createIndexWriter(this.indexPath, this.overwriteIndex, LuceneUtils.AnalyzerType.WhitespaceAnalyzer);
            for (File inputFile : this.inputFiles) {
                int numberOfRepresentatives;
                if (verbose) {
                    System.out.println("Processing " + inputFile.getPath() + ".");
                }
                if (verbose) {
                    System.out.println("Counting images.");
                }
                this.run = 0;
                this.readFile(indexWriter, inputFile);
                if (verbose) {
                    System.out.printf("%d images found in the data file.\n", this.docCount);
                }
                if ((double)(numberOfRepresentatives = 1000) > Math.sqrt(this.docCount)) {
                    numberOfRepresentatives = (int)Math.sqrt(this.docCount);
                }
                if (verbose) {
                    System.out.printf("Selecting %d representative images for hashing.\n", numberOfRepresentatives);
                }
                this.representativesID = new HashSet(numberOfRepresentatives);
                while (this.representativesID.size() < numberOfRepresentatives) {
                    this.representativesID.add((int)Math.floor(Math.random() * (double)(this.docCount - 1)));
                }
                this.representatives = new ArrayList(numberOfRepresentatives);
                this.docCount = 0;
                this.run = 1;
                if (verbose) {
                    System.out.println("Now getting representatives from the data file.");
                }
                this.readFile(indexWriter, inputFile);
                this.docCount = 0;
                this.run = 2;
                if (verbose) {
                    System.out.println("Finally we start the indexing process, please wait ...");
                }
                this.readFile(indexWriter, inputFile);
                if (!verbose) continue;
                System.out.println("Indexing finished.");
            }
            LuceneUtils.commitWriter(indexWriter);
            LuceneUtils.closeWriter(indexWriter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readFile(IndexWriter indexWriter, File inputFile) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFile));
        byte[] tempInt = new byte[4];
        boolean count = false;
        byte[] temp = new byte[102400];
        while (in.read(tempInt, 0, 4) > 0) {
            int tmpFeature;
            Document d = new Document();
            int tmp = SerializationUtils.toInt(tempInt);
            in.read(temp, 0, tmp);
            String filename = new String(temp, 0, tmp);
            filename = inputFile.getCanonicalPath().substring(0, inputFile.getCanonicalPath().lastIndexOf(inputFile.getName())) + filename;
            d.add((IndexableField)new StringField("ImageIdentifier", filename, Field.Store.YES));
            while ((tmpFeature = in.read()) < 255) {
                GlobalFeature f = (GlobalFeature)Class.forName(Extractor.features[tmpFeature]).newInstance();
                in.read(tempInt, 0, 4);
                tmp = SerializationUtils.toInt(tempInt);
                in.read(temp, 0, tmp);
                f.setByteArrayRepresentation(temp, 0, tmp);
                this.addToDocument(f, d, Extractor.featureFieldNames[tmpFeature]);
            }
            if (this.run == 2) {
                indexWriter.addDocument((Iterable)d);
            }
            ++this.docCount;
        }
        in.close();
    }

    protected void addToDocument(GlobalFeature feature, Document document, String featureFieldName) {
        if (this.run != 0) {
            if (this.run == 1) {
                if (this.representativesID.contains(this.docCount) && feature.getClass().getCanonicalName().equals(this.featureClass.getCanonicalName())) {
                    this.representatives.add(feature);
                }
            } else if (this.run == 2) {
                if (feature.getClass().getCanonicalName().equals(this.featureClass.getCanonicalName())) {
                    int[] hashes = this.getHashes(feature);
                    document.add((IndexableField)new TextField(featureFieldName + "_hash", this.createDocumentString(hashes, hashes.length), Field.Store.YES));
                    document.add((IndexableField)new TextField(featureFieldName + "_hash_q", this.createDocumentString(hashes, 10), Field.Store.YES));
                }
                document.add((IndexableField)new StoredField(featureFieldName, feature.getByteArrayRepresentation()));
            }
        }
    }

    private String createDocumentString(int[] hashes, int length) {
        StringBuilder sb = new StringBuilder(256);
        for (int i = 0; i < length; ++i) {
            int hash = hashes[i];
            for (int y = 0; y < length - i; ++y) {
                sb.append(" p" + hash);
            }
        }
        return sb.toString().trim();
    }

    private int[] getHashes(GlobalFeature feature) {
        this.hashingResultScoreDocs.clear();
        this.maxDistance = 0.0;
        this.tmpScore = 0.0;
        int rep = 0;
        for (GlobalFeature tmpFeature : this.representatives) {
            this.tmpScore = tmpFeature.getDistance(feature);
            if (this.hashingResultScoreDocs.size() < this.maximumHits) {
                this.hashingResultScoreDocs.add(new SimpleResult(this.tmpScore, rep));
                this.maxDistance = Math.max(this.maxDistance, this.tmpScore);
            } else if (this.tmpScore < this.maxDistance) {
                this.hashingResultScoreDocs.add(new SimpleResult(this.tmpScore, rep));
            }
            while (this.hashingResultScoreDocs.size() > this.maximumHits) {
                this.hashingResultScoreDocs.remove(this.hashingResultScoreDocs.last());
                this.maxDistance = this.hashingResultScoreDocs.last().getDistance();
            }
            ++rep;
        }
        rep = 0;
        for (SimpleResult next : this.hashingResultScoreDocs) {
            this.result[rep] = next.getIndexNumber();
            ++rep;
        }
        return this.result;
    }

    public void addInputFile(File inputFile) {
        this.inputFiles.add(inputFile);
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }
}

