/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.searchers;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.TreeSet;
import java.util.logging.Logger;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.global.OpponentHistogram;
import net.semanticmetadata.lire.searchers.AbstractImageSearcher;
import net.semanticmetadata.lire.searchers.ImageDuplicates;
import net.semanticmetadata.lire.searchers.ImageSearchHits;
import net.semanticmetadata.lire.searchers.SimpleImageSearchHits;
import net.semanticmetadata.lire.searchers.SimpleResult;
import net.semanticmetadata.lire.utils.ImageUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.util.Bits;

public class FastOpponentImageSearcher
extends AbstractImageSearcher {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    private OpponentHistogram cachedInstance = null;
    private int maxHits = 10;
    protected TreeSet<SimpleResult> docs;
    private byte[] tempBinaryValue;
    private double maxDistance;
    private float overallMaxDistance;

    public FastOpponentImageSearcher(int maxHits) {
        this.maxHits = maxHits;
        this.docs = new TreeSet();
        this.cachedInstance = new OpponentHistogram();
    }

    @Override
    public ImageSearchHits search(BufferedImage image, IndexReader reader) throws IOException {
        this.logger.finer("Starting extraction.");
        OpponentHistogram globalFeature = null;
        SimpleImageSearchHits searchHits = null;
        globalFeature = new OpponentHistogram();
        BufferedImage bimg = image;
        if (Math.max(image.getHeight(), image.getWidth()) > 1024) {
            bimg = ImageUtils.scaleImage(image, 1024);
        }
        globalFeature.extract(bimg);
        this.logger.fine("Extraction from image finished");
        double maxDistance = this.findSimilar(reader, globalFeature);
        searchHits = new SimpleImageSearchHits(this.docs, (float)maxDistance);
        return searchHits;
    }

    protected double findSimilar(IndexReader reader, GlobalFeature globalFeature) throws IOException {
        this.maxDistance = -1.0;
        this.docs.clear();
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
        int docs = reader.numDocs();
        byte[] histogram = globalFeature.getByteArrayRepresentation();
        for (int i = 0; i < docs; ++i) {
            if (reader.hasDeletions() && !liveDocs.get(i)) continue;
            Document d = reader.document(i);
            double tmpDistance = this.getDistance(d, histogram);
            assert (tmpDistance >= 0.0);
            if (this.maxDistance < 0.0) {
                this.maxDistance = tmpDistance;
            }
            if (this.docs.size() < this.maxHits) {
                this.docs.add(new SimpleResult(tmpDistance, i));
                if (!(tmpDistance > this.maxDistance)) continue;
                this.maxDistance = tmpDistance;
                continue;
            }
            if (!(tmpDistance < this.maxDistance)) continue;
            this.docs.remove(this.docs.last());
            this.docs.add(new SimpleResult(tmpDistance, i));
            this.maxDistance = this.docs.last().getDistance();
        }
        return this.maxDistance;
    }

    protected double getDistance(Document document, byte[] histogram) {
        if (document.getField("OppHist").binaryValue() != null && document.getField((String)"OppHist").binaryValue().length > 0) {
            return this.cachedInstance.getDistance(histogram, 0, histogram.length, document.getField((String)"OppHist").binaryValue().bytes, document.getField((String)"OppHist").binaryValue().offset, document.getField((String)"OppHist").binaryValue().length);
        }
        this.logger.warning("No feature stored in this document!");
        return 0.0;
    }

    @Override
    public ImageSearchHits search(Document doc, IndexReader reader) throws IOException {
        SimpleImageSearchHits searchHits = null;
        OpponentHistogram globalFeature = new OpponentHistogram();
        if (doc.getField("OppHist").binaryValue() != null && doc.getField((String)"OppHist").binaryValue().length > 0) {
            globalFeature.setByteArrayRepresentation(doc.getField((String)"OppHist").binaryValue().bytes, doc.getField((String)"OppHist").binaryValue().offset, doc.getField((String)"OppHist").binaryValue().length);
        }
        double maxDistance = this.findSimilar(reader, globalFeature);
        searchHits = new SimpleImageSearchHits(this.docs, (float)maxDistance);
        return searchHits;
    }

    @Override
    public ImageDuplicates findDuplicates(IndexReader reader) throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    public String toString() {
        return this.getClass().getName();
    }
}

