/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.searchers;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.TreeSet;
import java.util.logging.Logger;
import net.semanticmetadata.lire.builders.GlobalDocumentBuilder;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.indexers.parallel.ExtractorItem;
import net.semanticmetadata.lire.searchers.AbstractImageSearcher;
import net.semanticmetadata.lire.searchers.ImageDuplicates;
import net.semanticmetadata.lire.searchers.ImageSearchHits;
import net.semanticmetadata.lire.searchers.SimpleImageSearchHits;
import net.semanticmetadata.lire.searchers.SimpleResult;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Bits;

public class GenericDocValuesImageSearcher
extends AbstractImageSearcher {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    protected String fieldName;
    protected LireFeature cachedInstance = null;
    protected ExtractorItem extractorItem;
    protected IndexReader reader = null;
    protected int maxHits = 50;
    protected TreeSet<SimpleResult> docs = new TreeSet();
    protected double maxDistance;
    protected boolean useSimilarityScore = false;
    private BinaryDocValues docValues = null;

    public GenericDocValuesImageSearcher(int maxHits, Class<? extends GlobalFeature> globalFeature, IndexReader reader) {
        this.maxHits = maxHits;
        this.extractorItem = new ExtractorItem(globalFeature);
        this.fieldName = this.extractorItem.getFieldName();
        try {
            this.cachedInstance = (GlobalFeature)this.extractorItem.getExtractorInstance().getClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.reader = reader;
        this.init();
    }

    protected void init() {
        if (this.reader != null) {
            try {
                this.docValues = MultiDocValues.getBinaryValues((IndexReader)this.reader, (String)this.cachedInstance.getFieldName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected double findSimilar(LireFeature lireFeature) throws IOException {
        this.maxDistance = -1.0;
        this.docs.clear();
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)this.reader);
        int docs = this.reader.numDocs();
        for (int i = 0; i < docs; ++i) {
            if (this.reader.hasDeletions() && !liveDocs.get(i)) continue;
            this.cachedInstance.setByteArrayRepresentation(this.docValues.get((int)i).bytes, this.docValues.get((int)i).offset, this.docValues.get((int)i).length);
            double tmpDistance = this.cachedInstance.getDistance(lireFeature);
            assert (tmpDistance >= 0.0);
            if (this.docs.size() < this.maxHits) {
                this.docs.add(new SimpleResult(tmpDistance, i));
                if (!(tmpDistance > this.maxDistance)) continue;
                this.maxDistance = tmpDistance;
                continue;
            }
            if (!(tmpDistance < this.maxDistance)) continue;
            this.docs.remove(this.docs.last());
            this.docs.add(new SimpleResult(tmpDistance, i));
            this.maxDistance = this.docs.last().getDistance();
        }
        return this.maxDistance;
    }

    public ImageSearchHits search(int doc) throws IOException {
        SimpleImageSearchHits searchHits = null;
        LireFeature lireFeature = this.extractorItem.getFeatureInstance();
        lireFeature.setByteArrayRepresentation(this.docValues.get((int)doc).bytes, this.docValues.get((int)doc).offset, this.docValues.get((int)doc).length);
        double maxDistance = this.findSimilar(lireFeature);
        searchHits = !this.useSimilarityScore ? new SimpleImageSearchHits(this.docs, maxDistance) : new SimpleImageSearchHits(this.docs, maxDistance, this.useSimilarityScore);
        return searchHits;
    }

    @Override
    public ImageSearchHits search(Document doc, IndexReader reader) throws IOException {
        IndexSearcher is = new IndexSearcher(reader);
        TermQuery tq = new TermQuery(new Term("ImageIdentifier", doc.getValues("ImageIdentifier")[0]));
        TopDocs topDocs = is.search((Query)tq, 1);
        if (topDocs.totalHits > 0) {
            return this.search(topDocs.scoreDocs[0].doc);
        }
        return null;
    }

    @Override
    public ImageSearchHits search(BufferedImage image, IndexReader reader) throws IOException {
        this.logger.finer("Starting extraction.");
        SimpleImageSearchHits searchHits = null;
        GlobalDocumentBuilder globalDocumentBuilder = new GlobalDocumentBuilder();
        GlobalFeature globalFeature = globalDocumentBuilder.extractGlobalFeature(image, (GlobalFeature)this.extractorItem.getExtractorInstance());
        double maxDistance = this.findSimilar(globalFeature);
        searchHits = !this.useSimilarityScore ? new SimpleImageSearchHits(this.docs, maxDistance) : new SimpleImageSearchHits(this.docs, maxDistance, this.useSimilarityScore);
        return searchHits;
    }

    @Override
    public ImageDuplicates findDuplicates(IndexReader reader) throws IOException {
        throw new UnsupportedOperationException("not implemented yet.");
    }

    public String toString() {
        return "GenericDocValuesImageSearcher using " + this.extractorItem.getExtractorClass().getName();
    }
}

