/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.searchers;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import net.semanticmetadata.lire.aggregators.Aggregator;
import net.semanticmetadata.lire.builders.GlobalDocumentBuilder;
import net.semanticmetadata.lire.builders.LocalDocumentBuilder;
import net.semanticmetadata.lire.builders.SimpleDocumentBuilder;
import net.semanticmetadata.lire.classifiers.Cluster;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeatureExtractor;
import net.semanticmetadata.lire.imageanalysis.features.local.simple.SimpleExtractor;
import net.semanticmetadata.lire.indexers.parallel.ExtractorItem;
import net.semanticmetadata.lire.searchers.AbstractImageSearcher;
import net.semanticmetadata.lire.searchers.ImageDuplicates;
import net.semanticmetadata.lire.searchers.ImageSearchHits;
import net.semanticmetadata.lire.searchers.SimpleImageDuplicates;
import net.semanticmetadata.lire.searchers.SimpleImageSearchHits;
import net.semanticmetadata.lire.searchers.SimpleResult;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.util.Bits;

public class GenericFastImageSearcher
extends AbstractImageSearcher {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    protected String fieldName;
    protected String codebookName;
    protected LireFeature cachedInstance = null;
    protected ExtractorItem extractorItem;
    protected boolean isCaching = false;
    protected LinkedHashMap<Integer, byte[]> featureCache = null;
    protected IndexReader reader = null;
    protected int maxHits = 50;
    protected TreeSet<SimpleResult> docs = new TreeSet();
    protected double maxDistance;
    protected boolean useSimilarityScore = false;
    Aggregator aggregator;
    private String codebooksDir;
    protected LinkedBlockingQueue<Map.Entry<Integer, byte[]>> queue = new LinkedBlockingQueue(100);
    protected int numThreads = 16;

    public GenericFastImageSearcher(int maxHits, Class<? extends GlobalFeature> globalFeature) {
        this.maxHits = maxHits;
        this.extractorItem = new ExtractorItem(globalFeature);
        this.fieldName = this.extractorItem.getFieldName();
        try {
            this.cachedInstance = (GlobalFeature)this.extractorItem.getExtractorInstance().getClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.init();
    }

    public GenericFastImageSearcher(int maxHits, Class<? extends LocalFeatureExtractor> localFeatureExtractor, Aggregator aggregator, int codebookSize, String codebooksDir) {
        this.maxHits = maxHits;
        this.codebooksDir = codebooksDir;
        this.extractorItem = new ExtractorItem(localFeatureExtractor);
        this.fieldName = this.extractorItem.getFieldName() + aggregator.getFieldName() + codebookSize;
        try {
            this.cachedInstance = ((LocalFeatureExtractor)this.extractorItem.getExtractorInstance()).getClassOfFeatures().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.aggregator = aggregator;
        this.init();
    }

    public GenericFastImageSearcher(int maxHits, Class<? extends GlobalFeature> globalFeatureClass, SimpleExtractor.KeypointDetector detector, Aggregator aggregator, int codebookSize, String codebooksDir) {
        this.maxHits = maxHits;
        this.codebooksDir = codebooksDir;
        this.extractorItem = new ExtractorItem(globalFeatureClass, detector);
        this.fieldName = this.extractorItem.getFieldName() + aggregator.getFieldName() + codebookSize;
        try {
            this.cachedInstance = ((SimpleExtractor)this.extractorItem.getExtractorInstance()).getClassOfFeatures().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.aggregator = aggregator;
        this.init();
    }

    public GenericFastImageSearcher(int maxHits, Class<? extends GlobalFeature> globalFeature, boolean isCaching, IndexReader reader) {
        this.maxHits = maxHits;
        this.extractorItem = new ExtractorItem(globalFeature);
        this.fieldName = this.extractorItem.getFieldName();
        try {
            this.cachedInstance = (GlobalFeature)this.extractorItem.getExtractorInstance().getClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.isCaching = isCaching;
        this.reader = reader;
        this.init();
    }

    public GenericFastImageSearcher(int maxHits, Class<? extends LocalFeatureExtractor> localFeatureExtractor, Aggregator aggregator, int codebookSize, boolean isCaching, IndexReader reader, String codebooksDir) {
        this.maxHits = maxHits;
        this.codebooksDir = codebooksDir;
        this.extractorItem = new ExtractorItem(localFeatureExtractor);
        this.fieldName = this.extractorItem.getFieldName() + aggregator.getFieldName() + codebookSize;
        this.codebookName = this.extractorItem.getFieldName() + codebookSize;
        try {
            this.cachedInstance = ((LocalFeatureExtractor)this.extractorItem.getExtractorInstance()).getClassOfFeatures().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.isCaching = isCaching;
        this.reader = reader;
        this.aggregator = aggregator;
        this.init();
    }

    public GenericFastImageSearcher(int maxHits, Class<? extends GlobalFeature> globalFeatureClass, SimpleExtractor.KeypointDetector detector, Aggregator aggregator, int codebookSize, boolean isCaching, IndexReader reader, String codebooksDir) {
        this.maxHits = maxHits;
        this.codebooksDir = codebooksDir;
        this.extractorItem = new ExtractorItem(globalFeatureClass, detector);
        this.fieldName = this.extractorItem.getFieldName() + aggregator.getFieldName() + codebookSize;
        this.codebookName = this.extractorItem.getFieldName() + codebookSize;
        try {
            this.cachedInstance = ((SimpleExtractor)this.extractorItem.getExtractorInstance()).getClassOfFeatures().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.isCaching = isCaching;
        this.reader = reader;
        this.aggregator = aggregator;
        this.init();
    }

    public GenericFastImageSearcher(int maxHits, Class<? extends GlobalFeature> globalFeature, boolean isCaching, IndexReader reader, boolean useSimilarityScore) {
        this.maxHits = maxHits;
        this.extractorItem = new ExtractorItem(globalFeature);
        this.fieldName = this.extractorItem.getFieldName();
        try {
            this.cachedInstance = (GlobalFeature)this.extractorItem.getExtractorInstance().getClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.useSimilarityScore = useSimilarityScore;
        this.isCaching = isCaching;
        this.reader = reader;
        this.init();
    }

    public GenericFastImageSearcher(int maxHits, Class<? extends LocalFeatureExtractor> localFeatureExtractor, Aggregator aggregator, int codebookSize, boolean isCaching, IndexReader reader, boolean useSimilarityScore, String codebooksDir) {
        this.maxHits = maxHits;
        this.codebooksDir = codebooksDir;
        this.extractorItem = new ExtractorItem(localFeatureExtractor);
        this.fieldName = this.extractorItem.getFieldName() + aggregator.getFieldName() + codebookSize;
        this.codebookName = this.extractorItem.getFieldName() + codebookSize;
        try {
            this.cachedInstance = ((LocalFeatureExtractor)this.extractorItem.getExtractorInstance()).getClassOfFeatures().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.useSimilarityScore = useSimilarityScore;
        this.isCaching = isCaching;
        this.reader = reader;
        this.aggregator = aggregator;
        this.init();
    }

    public GenericFastImageSearcher(int maxHits, Class<? extends GlobalFeature> globalFeatureClass, SimpleExtractor.KeypointDetector detector, Aggregator aggregator, int codebookSize, boolean isCaching, IndexReader reader, boolean useSimilarityScore, String codebooksDir) {
        this.maxHits = maxHits;
        this.codebooksDir = codebooksDir;
        this.extractorItem = new ExtractorItem(globalFeatureClass, detector);
        this.fieldName = this.extractorItem.getFieldName() + aggregator.getFieldName() + codebookSize;
        this.codebookName = this.extractorItem.getFieldName() + codebookSize;
        try {
            this.cachedInstance = ((SimpleExtractor)this.extractorItem.getExtractorInstance()).getClassOfFeatures().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.useSimilarityScore = useSimilarityScore;
        this.isCaching = isCaching;
        this.reader = reader;
        this.aggregator = aggregator;
        this.init();
    }

    protected void init() {
        if (this.isCaching && this.reader != null) {
            Bits liveDocs = MultiFields.getLiveDocs((IndexReader)this.reader);
            int docs = this.reader.numDocs();
            this.featureCache = new LinkedHashMap(docs);
            try {
                for (int i = 0; i < docs; ++i) {
                    Document d;
                    if (this.reader.hasDeletions() && !liveDocs.get(i) || (d = this.reader.document(i)).getField(this.fieldName) == null) continue;
                    this.cachedInstance.setByteArrayRepresentation(d.getField((String)this.fieldName).binaryValue().bytes, d.getField((String)this.fieldName).binaryValue().offset, d.getField((String)this.fieldName).binaryValue().length);
                    this.featureCache.put(i, this.cachedInstance.getByteArrayRepresentation());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected double findSimilar(IndexReader reader, LireFeature lireFeature) throws IOException {
        this.maxDistance = -1.0;
        this.docs.clear();
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
        int docs = reader.numDocs();
        if (!this.isCaching) {
            for (int i = 0; i < docs; ++i) {
                if (reader.hasDeletions() && !liveDocs.get(i)) continue;
                Document d = reader.document(i);
                double tmpDistance = this.getDistance(d, lireFeature);
                assert (tmpDistance >= 0.0);
                if (this.docs.size() < this.maxHits) {
                    this.docs.add(new SimpleResult(tmpDistance, i));
                    if (!(tmpDistance > this.maxDistance)) continue;
                    this.maxDistance = tmpDistance;
                    continue;
                }
                if (!(tmpDistance < this.maxDistance)) continue;
                this.docs.remove(this.docs.last());
                this.docs.add(new SimpleResult(tmpDistance, i));
                this.maxDistance = this.docs.last().getDistance();
            }
        } else {
            LinkedList<Consumer> tasks = new LinkedList<Consumer>();
            LinkedList<Thread> threads = new LinkedList<Thread>();
            Thread p = new Thread(new Producer());
            p.start();
            for (int i = 0; i < this.numThreads; ++i) {
                Consumer consumer = new Consumer(lireFeature);
                Thread thread = new Thread(consumer);
                thread.start();
                tasks.add(consumer);
                threads.add(thread);
            }
            for (Thread next : threads) {
                try {
                    next.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            for (Consumer task : tasks) {
                TreeSet<SimpleResult> tmpDocs = task.getResult();
                boolean flag = true;
                while (flag && tmpDocs.size() > 0) {
                    SimpleResult simpleResult = tmpDocs.pollFirst();
                    if (this.docs.size() < this.maxHits) {
                        this.docs.add(simpleResult);
                        if (!(simpleResult.getDistance() > this.maxDistance)) continue;
                        this.maxDistance = simpleResult.getDistance();
                        continue;
                    }
                    if (simpleResult.getDistance() < this.maxDistance) {
                        this.docs.pollLast();
                        this.docs.add(simpleResult);
                        this.maxDistance = this.docs.last().getDistance();
                        continue;
                    }
                    flag = false;
                }
            }
        }
        return this.maxDistance;
    }

    protected double getDistance(Document document, LireFeature lireFeature) {
        if (document.getField(this.fieldName).binaryValue() != null && document.getField((String)this.fieldName).binaryValue().length > 0) {
            this.cachedInstance.setByteArrayRepresentation(document.getField((String)this.fieldName).binaryValue().bytes, document.getField((String)this.fieldName).binaryValue().offset, document.getField((String)this.fieldName).binaryValue().length);
            return lireFeature.getDistance(this.cachedInstance);
        }
        this.logger.warning("No feature stored in this document! (" + this.extractorItem.getExtractorClass().getName() + ")");
        return 0.0;
    }

    @Override
    public ImageSearchHits search(Document doc, IndexReader reader) throws IOException {
        SimpleImageSearchHits searchHits = null;
        LireFeature lireFeature = this.extractorItem.getFeatureInstance();
        if (doc.getField(this.fieldName).binaryValue() != null && doc.getField((String)this.fieldName).binaryValue().length > 0) {
            lireFeature.setByteArrayRepresentation(doc.getField((String)this.fieldName).binaryValue().bytes, doc.getField((String)this.fieldName).binaryValue().offset, doc.getField((String)this.fieldName).binaryValue().length);
        }
        double maxDistance = this.findSimilar(reader, lireFeature);
        searchHits = !this.useSimilarityScore ? new SimpleImageSearchHits(this.docs, maxDistance) : new SimpleImageSearchHits(this.docs, maxDistance, this.useSimilarityScore);
        return searchHits;
    }

    @Override
    public ImageSearchHits search(BufferedImage image, IndexReader reader) throws IOException {
        this.logger.finer("Starting extraction.");
        SimpleImageSearchHits searchHits = null;
        if (this.extractorItem.isGlobal()) {
            GlobalDocumentBuilder globalDocumentBuilder = new GlobalDocumentBuilder();
            GlobalFeature globalFeature = globalDocumentBuilder.extractGlobalFeature(image, (GlobalFeature)this.extractorItem.getExtractorInstance());
            double maxDistance = this.findSimilar(reader, globalFeature);
            searchHits = !this.useSimilarityScore ? new SimpleImageSearchHits(this.docs, maxDistance) : new SimpleImageSearchHits(this.docs, maxDistance, this.useSimilarityScore);
        } else if (this.extractorItem.isLocal()) {
            LocalDocumentBuilder localDocumentBuilder = new LocalDocumentBuilder();
            LocalFeatureExtractor localFeatureExtractor = localDocumentBuilder.extractLocalFeatures(image, (LocalFeatureExtractor)this.extractorItem.getExtractorInstance());
            this.aggregator.createVectorRepresentation(localFeatureExtractor.getFeatures(), Cluster.readClusters(this.codebooksDir + File.separator + this.codebookName));
            this.extractorItem.getFeatureInstance().setByteArrayRepresentation(this.aggregator.getByteVectorRepresentation());
            double maxDistance = this.findSimilar(reader, this.extractorItem.getFeatureInstance());
            searchHits = !this.useSimilarityScore ? new SimpleImageSearchHits(this.docs, maxDistance) : new SimpleImageSearchHits(this.docs, maxDistance, this.useSimilarityScore);
        } else if (this.extractorItem.isSimple()) {
            SimpleDocumentBuilder simpleDocumentBuilder = new SimpleDocumentBuilder();
            LocalFeatureExtractor localFeatureExtractor = simpleDocumentBuilder.extractLocalFeatures(image, (LocalFeatureExtractor)this.extractorItem.getExtractorInstance());
            this.aggregator.createVectorRepresentation(localFeatureExtractor.getFeatures(), Cluster.readClusters(this.codebooksDir + File.separator + this.codebookName));
            this.extractorItem.getFeatureInstance().setByteArrayRepresentation(this.aggregator.getByteVectorRepresentation());
            double maxDistance = this.findSimilar(reader, this.extractorItem.getFeatureInstance());
            searchHits = !this.useSimilarityScore ? new SimpleImageSearchHits(this.docs, maxDistance) : new SimpleImageSearchHits(this.docs, maxDistance, this.useSimilarityScore);
        } else {
            throw new UnsupportedOperationException("");
        }
        return searchHits;
    }

    @Override
    public ImageDuplicates findDuplicates(IndexReader reader) throws IOException {
        SimpleImageDuplicates simpleImageDuplicates = null;
        Document doc = reader.document(0);
        LireFeature lireFeature = this.extractorItem.getFeatureInstance();
        if (doc.getField(this.fieldName).binaryValue() != null && doc.getField((String)this.fieldName).binaryValue().length > 0) {
            lireFeature.setByteArrayRepresentation(doc.getField((String)this.fieldName).binaryValue().bytes, doc.getField((String)this.fieldName).binaryValue().offset, doc.getField((String)this.fieldName).binaryValue().length);
        }
        HashMap duplicates = new HashMap();
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
        int docs = reader.numDocs();
        int numDuplicates = 0;
        for (int i = 0; i < docs; ++i) {
            if (reader.hasDeletions() && !liveDocs.get(i)) continue;
            Document d = reader.document(i);
            double distance = this.getDistance(d, lireFeature);
            if (!duplicates.containsKey(distance)) {
                duplicates.put(distance, new LinkedList());
            } else {
                ++numDuplicates;
            }
            ((List)duplicates.get(distance)).add(d.getField("ImageIdentifier").stringValue());
        }
        if (numDuplicates == 0) {
            return null;
        }
        LinkedList<List<String>> results = new LinkedList<List<String>>();
        Iterator iterator = duplicates.keySet().iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            if (((List)duplicates.get(d)).size() <= 1) continue;
            results.add((List<String>)duplicates.get(d));
        }
        simpleImageDuplicates = new SimpleImageDuplicates(results);
        return simpleImageDuplicates;
    }

    public String toString() {
        return "GenericSearcher using " + this.extractorItem.getExtractorClass().getName();
    }

    private class Consumer
    implements Runnable {
        private boolean locallyEnded = false;
        private TreeSet<SimpleResult> localDocs = new TreeSet();
        private LireFeature localCachedInstance;
        private LireFeature localLireFeature;

        private Consumer(LireFeature lireFeature) {
            try {
                this.localCachedInstance = (LireFeature)GenericFastImageSearcher.this.cachedInstance.getClass().newInstance();
                this.localLireFeature = (LireFeature)lireFeature.getClass().newInstance();
                this.localLireFeature.setByteArrayRepresentation(lireFeature.getByteArrayRepresentation());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            double localMaxDistance = -1.0;
            while (!this.locallyEnded) {
                try {
                    Map.Entry<Integer, byte[]> tmp = GenericFastImageSearcher.this.queue.take();
                    if (tmp.getKey() < 0) {
                        this.locallyEnded = true;
                    }
                    if (this.locallyEnded) continue;
                    this.localCachedInstance.setByteArrayRepresentation(tmp.getValue());
                    double tmpDistance = this.localLireFeature.getDistance(this.localCachedInstance);
                    assert (tmpDistance >= 0.0);
                    if (this.localDocs.size() < GenericFastImageSearcher.this.maxHits) {
                        this.localDocs.add(new SimpleResult(tmpDistance, tmp.getKey()));
                        if (!(tmpDistance > localMaxDistance)) continue;
                        localMaxDistance = tmpDistance;
                        continue;
                    }
                    if (!(tmpDistance < localMaxDistance)) continue;
                    this.localDocs.pollLast();
                    this.localDocs.add(new SimpleResult(tmpDistance, tmp.getKey()));
                    localMaxDistance = this.localDocs.last().getDistance();
                }
                catch (InterruptedException e) {
                    e.getMessage();
                }
            }
        }

        public TreeSet<SimpleResult> getResult() {
            return this.localDocs;
        }
    }

    class Producer
    implements Runnable {
        private Producer() {
            GenericFastImageSearcher.this.queue.clear();
        }

        @Override
        public void run() {
            for (Map.Entry<Integer, byte[]> documentEntry : GenericFastImageSearcher.this.featureCache.entrySet()) {
                try {
                    GenericFastImageSearcher.this.queue.put(documentEntry);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            LinkedHashMap tmpMap = new LinkedHashMap(GenericFastImageSearcher.this.numThreads * 3);
            for (int i = 1; i < GenericFastImageSearcher.this.numThreads * 3; ++i) {
                tmpMap.put(-i, null);
            }
            for (Map.Entry documentEntry : tmpMap.entrySet()) {
                try {
                    GenericFastImageSearcher.this.queue.put(documentEntry);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

