/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.searchers;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.TreeSet;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.indexers.hashing.LocalitySensitiveHashing;
import net.semanticmetadata.lire.searchers.AbstractImageSearcher;
import net.semanticmetadata.lire.searchers.ImageDuplicates;
import net.semanticmetadata.lire.searchers.ImageSearchHits;
import net.semanticmetadata.lire.searchers.SimpleImageSearchHits;
import net.semanticmetadata.lire.searchers.SimpleResult;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.similarities.DefaultSimilarity;
import org.apache.lucene.search.similarities.Similarity;

public class LshImageSearcher
extends AbstractImageSearcher {
    private int maxResultsHashBased = 1000;
    private int maximumHits = 100;
    private String featureFieldName = "OppHist";
    private GlobalFeature feature;
    private String hashesFieldName = null;

    public LshImageSearcher(int maximumHits, String featureFieldName, String hashesFieldName, GlobalFeature feature) {
        this.maximumHits = maximumHits;
        this.featureFieldName = featureFieldName;
        this.hashesFieldName = hashesFieldName;
        this.feature = feature;
        try {
            LocalitySensitiveHashing.readHashFunctions();
        }
        catch (IOException e) {
            System.err.println("Error reading hash functions from default location.");
            e.printStackTrace();
        }
    }

    public LshImageSearcher(int maximumHits, String featureFieldName, String hashesFieldName, GlobalFeature feature, int numHashedResults) {
        this.maximumHits = maximumHits;
        this.featureFieldName = featureFieldName;
        this.hashesFieldName = hashesFieldName;
        this.feature = feature;
        this.maxResultsHashBased = numHashedResults;
        try {
            LocalitySensitiveHashing.readHashFunctions();
        }
        catch (IOException e) {
            System.err.println("Error reading hash functions from default location.");
            e.printStackTrace();
        }
    }

    public LshImageSearcher(int maximumHits, String featureFieldName, String hashesFieldName, GlobalFeature feature, InputStream hashes) {
        this.maximumHits = maximumHits;
        this.featureFieldName = featureFieldName;
        this.hashesFieldName = hashesFieldName;
        this.feature = feature;
        try {
            LocalitySensitiveHashing.readHashFunctions();
            hashes.close();
        }
        catch (IOException e) {
            System.err.println("Error reading has functions from given input stream.");
            e.printStackTrace();
        }
    }

    public LshImageSearcher(int maximumHits, String featureFieldName, String hashesFieldName, GlobalFeature feature, InputStream hashes, int numHashedResults) {
        this.maximumHits = maximumHits;
        this.featureFieldName = featureFieldName;
        this.hashesFieldName = hashesFieldName;
        this.feature = feature;
        this.maxResultsHashBased = numHashedResults;
        try {
            LocalitySensitiveHashing.readHashFunctions();
            hashes.close();
        }
        catch (IOException e) {
            System.err.println("Error reading has functions from given input stream.");
            e.printStackTrace();
        }
    }

    @Override
    public ImageSearchHits search(BufferedImage image, IndexReader reader) throws IOException {
        try {
            GlobalFeature queryFeature = (GlobalFeature)this.feature.getClass().newInstance();
            queryFeature.extract(image);
            int[] ints = LocalitySensitiveHashing.generateHashes(queryFeature.getFeatureVector());
            String[] hashes = new String[ints.length];
            for (int i = 0; i < ints.length; ++i) {
                hashes[i] = Integer.toString(ints[i]);
            }
            return this.search(hashes, queryFeature, reader);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ImageSearchHits search(Document doc, IndexReader reader) throws IOException {
        try {
            GlobalFeature queryFeature = (GlobalFeature)this.feature.getClass().newInstance();
            queryFeature.setByteArrayRepresentation(doc.getBinaryValue((String)this.featureFieldName).bytes, doc.getBinaryValue((String)this.featureFieldName).offset, doc.getBinaryValue((String)this.featureFieldName).length);
            return this.search(doc.getValues(this.hashesFieldName)[0].split(" "), queryFeature, reader);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ImageSearchHits search(String[] hashes, GlobalFeature queryFeature, IndexReader reader) throws IOException {
        IndexSearcher searcher = new IndexSearcher(reader);
        searcher.setSimilarity((Similarity)new DefaultSimilarity(){

            public float tf(float freq) {
                return 1.0f;
            }

            public float idf(long docFreq, long numDocs) {
                return 1.0f;
            }

            public float coord(int overlap, int maxOverlap) {
                return 1.0f;
            }

            public float queryNorm(float sumOfSquaredWeights) {
                return 1.0f;
            }

            public float sloppyFreq(int distance) {
                return 1.0f;
            }

            public float lengthNorm(FieldInvertState state) {
                return 1.0f;
            }
        });
        BooleanQuery query = new BooleanQuery();
        for (int i = 0; i < hashes.length; ++i) {
            query.add(new BooleanClause((Query)new TermQuery(new Term(this.hashesFieldName, hashes[i] + "")), BooleanClause.Occur.SHOULD));
        }
        TopDocs docs = searcher.search((Query)query, this.maxResultsHashBased);
        TreeSet<SimpleResult> resultScoreDocs = new TreeSet<SimpleResult>();
        double maxDistance = 0.0;
        double tmpScore = 0.0;
        for (int i = 0; i < docs.scoreDocs.length; ++i) {
            this.feature.setByteArrayRepresentation(reader.document((int)docs.scoreDocs[i].doc).getBinaryValue((String)this.featureFieldName).bytes, reader.document((int)docs.scoreDocs[i].doc).getBinaryValue((String)this.featureFieldName).offset, reader.document((int)docs.scoreDocs[i].doc).getBinaryValue((String)this.featureFieldName).length);
            tmpScore = queryFeature.getDistance(this.feature);
            if (resultScoreDocs.size() < this.maximumHits) {
                resultScoreDocs.add(new SimpleResult(tmpScore, docs.scoreDocs[i].doc));
                maxDistance = Math.max(maxDistance, tmpScore);
            } else if (tmpScore < maxDistance) {
                resultScoreDocs.add(new SimpleResult(tmpScore, docs.scoreDocs[i].doc));
            }
            while (resultScoreDocs.size() > this.maximumHits) {
                resultScoreDocs.remove(resultScoreDocs.last());
                maxDistance = resultScoreDocs.last().getDistance();
            }
        }
        return new SimpleImageSearchHits(resultScoreDocs, maxDistance);
    }

    @Override
    public ImageDuplicates findDuplicates(IndexReader reader) throws IOException {
        throw new UnsupportedOperationException("not implemented.");
    }
}

