/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.searchers;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.indexers.hashing.MetricSpaces;
import net.semanticmetadata.lire.searchers.AbstractImageSearcher;
import net.semanticmetadata.lire.searchers.ImageDuplicates;
import net.semanticmetadata.lire.searchers.ImageSearchHits;
import net.semanticmetadata.lire.searchers.SimpleImageSearchHits;
import net.semanticmetadata.lire.searchers.SimpleResult;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.similarities.DefaultSimilarity;
import org.apache.lucene.search.similarities.Similarity;

public class MetricSpacesImageSearcher
extends AbstractImageSearcher {
    private MetricSpaces.Parameters p;
    private int maxResultsHashBased = 1000;
    private int maximumHits = 100;
    private String featureFieldName = null;
    private GlobalFeature feature = null;
    private String hashesFieldName = null;
    private int numHashesUsedForQuery = 25;
    private boolean useDocValues = false;
    private BinaryDocValues docValues = null;
    private IndexReader reader = null;

    public MetricSpacesImageSearcher(int maximumHits, File referencePointFile) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this.maximumHits = maximumHits;
        try {
            this.p = MetricSpaces.loadReferencePoints(referencePointFile);
            this.feature = (GlobalFeature)this.p.featureClass.newInstance();
            this.featureFieldName = this.feature.getFieldName();
            this.hashesFieldName = this.featureFieldName + "_hash";
        }
        catch (IOException e) {
            System.err.println("Error reading hash functions from default location.");
            e.printStackTrace();
        }
    }

    public MetricSpacesImageSearcher(int maximumHits, File referencePointFile, int numHashedResults) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this.maximumHits = maximumHits;
        this.maxResultsHashBased = numHashedResults;
        try {
            this.p = MetricSpaces.loadReferencePoints(referencePointFile);
            this.feature = (GlobalFeature)this.p.featureClass.newInstance();
            this.featureFieldName = this.feature.getFieldName();
            this.hashesFieldName = this.featureFieldName + "_hash";
        }
        catch (IOException e) {
            System.err.println("Error reading hash functions from default location.");
            e.printStackTrace();
        }
    }

    @Override
    public ImageSearchHits search(BufferedImage image, IndexReader reader) throws IOException {
        try {
            GlobalFeature queryFeature = (GlobalFeature)this.feature.getClass().newInstance();
            queryFeature.extract(image);
            String query = MetricSpaces.generateBoostedQuery(queryFeature, this.numHashesUsedForQuery);
            return this.search(query, queryFeature, reader);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ImageSearchHits search(Document doc, IndexReader reader) throws IOException {
        try {
            GlobalFeature queryFeature = (GlobalFeature)this.feature.getClass().newInstance();
            queryFeature.setByteArrayRepresentation(doc.getBinaryValue((String)this.featureFieldName).bytes, doc.getBinaryValue((String)this.featureFieldName).offset, doc.getBinaryValue((String)this.featureFieldName).length);
            return this.search(MetricSpaces.generateBoostedQuery(queryFeature, this.numHashesUsedForQuery), queryFeature, reader);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ImageSearchHits search(String hashes, GlobalFeature queryFeature, IndexReader reader) throws IOException {
        IndexSearcher searcher = new IndexSearcher(reader);
        searcher.setSimilarity((Similarity)new BaseSimilarity());
        QueryParser qp = new QueryParser(this.hashesFieldName, (Analyzer)new WhitespaceAnalyzer());
        Query query = null;
        try {
            query = qp.parse(hashes);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (query == null) {
            return null;
        }
        TopDocs docs = searcher.search(query, this.maxResultsHashBased);
        TreeSet<SimpleResult> resultScoreDocs = new TreeSet<SimpleResult>();
        double maxDistance = -1.0;
        for (int i = 0; i < docs.scoreDocs.length; ++i) {
            this.feature.setByteArrayRepresentation(reader.document((int)docs.scoreDocs[i].doc).getBinaryValue((String)this.featureFieldName).bytes, reader.document((int)docs.scoreDocs[i].doc).getBinaryValue((String)this.featureFieldName).offset, reader.document((int)docs.scoreDocs[i].doc).getBinaryValue((String)this.featureFieldName).length);
            double tmpScore = queryFeature.getDistance(this.feature);
            assert (tmpScore >= 0.0);
            if (resultScoreDocs.size() < this.maximumHits) {
                resultScoreDocs.add(new SimpleResult(tmpScore, docs.scoreDocs[i].doc));
                maxDistance = Math.max(maxDistance, tmpScore);
                continue;
            }
            if (!(tmpScore < maxDistance)) continue;
            resultScoreDocs.remove(resultScoreDocs.last());
            resultScoreDocs.add(new SimpleResult(tmpScore, docs.scoreDocs[i].doc));
            maxDistance = resultScoreDocs.last().getDistance();
        }
        assert (resultScoreDocs.size() <= this.maximumHits);
        return new SimpleImageSearchHits(resultScoreDocs, maxDistance);
    }

    @Override
    public ImageDuplicates findDuplicates(IndexReader reader) throws IOException {
        throw new UnsupportedOperationException("not implemented.");
    }

    public int getNumHashesUsedForQuery() {
        return this.numHashesUsedForQuery;
    }

    public void setNumHashesUsedForQuery(int numHashesUsedForQuery) {
        this.numHashesUsedForQuery = numHashesUsedForQuery;
    }

    class BaseSimilarity
    extends DefaultSimilarity {
        BaseSimilarity() {
        }

        public float tf(float freq) {
            return freq;
        }

        public float idf(long docFreq, long numDocs) {
            return 1.0f;
        }

        public float coord(int overlap, int maxOverlap) {
            return 1.0f;
        }

        public float queryNorm(float sumOfSquaredWeights) {
            return 1.0f;
        }

        public float sloppyFreq(int distance) {
            return 1.0f;
        }

        public float lengthNorm(FieldInvertState state) {
            return 1.0f;
        }
    }
}

