/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.searchers;

import java.util.ArrayList;
import java.util.Collection;
import net.semanticmetadata.lire.searchers.ImageSearchHits;
import net.semanticmetadata.lire.searchers.SimpleResult;

public class SimpleImageSearchHits
implements ImageSearchHits {
    ArrayList<SimpleResult> results;

    public SimpleImageSearchHits(Collection<SimpleResult> results, double maxDistance) {
        this.results = new ArrayList(results.size());
        this.results.addAll(results);
    }

    public SimpleImageSearchHits(Collection<SimpleResult> results, double maxDistance, boolean useSimilarityScore) {
        this.results = new ArrayList(results.size());
        this.results.addAll(results);
        for (SimpleResult result : this.results) {
            if (!useSimilarityScore) continue;
            result.setDistance(1.0 - result.getDistance() / maxDistance);
        }
    }

    @Override
    public int length() {
        return this.results.size();
    }

    @Override
    public double score(int position) {
        return this.results.get(position).getDistance();
    }

    @Override
    public int documentID(int position) {
        return this.results.get(position).getIndexNumber();
    }

    private double sigmoid(float f) {
        double result = 0.0;
        result = -1.0 + 2.0 / (1.0 + Math.exp(-2.0 * (double)f / 0.6));
        return 1.0 - result;
    }
}

