/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.searchers.custom;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.global.CEDD;
import net.semanticmetadata.lire.searchers.AbstractImageSearcher;
import net.semanticmetadata.lire.searchers.ImageDuplicates;
import net.semanticmetadata.lire.searchers.ImageSearchHits;
import net.semanticmetadata.lire.searchers.SimpleImageSearchHits;
import net.semanticmetadata.lire.searchers.SimpleResult;
import net.semanticmetadata.lire.utils.MetricsUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;

public class SingleNddCeddImageSearcher
extends AbstractImageSearcher {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    Class<?> descriptorClass = CEDD.class;
    String fieldName = null;
    protected GlobalFeature cachedInstance = null;
    protected boolean isCaching = true;
    protected ArrayList<double[]> featureCache;
    protected IndexReader reader;
    protected TreeSet<SimpleResult> docs;
    HashMap<double[], LinkedList<Integer>> hashMap;
    protected double maxDistance;
    protected boolean useSimilarityScore = false;
    private boolean halfDimensions = false;

    public SingleNddCeddImageSearcher(IndexReader reader) {
        this.init(reader);
    }

    public SingleNddCeddImageSearcher(IndexReader reader, boolean approximate) {
        this.halfDimensions = approximate;
        this.init(reader);
    }

    public SingleNddCeddImageSearcher(IndexReader reader, boolean approximate, Class descriptorClass, String fieldName) {
        this.halfDimensions = approximate;
        this.descriptorClass = descriptorClass;
        this.fieldName = fieldName;
        this.init(reader);
    }

    protected void init(IndexReader reader) {
        this.reader = reader;
        if (reader.hasDeletions()) {
            throw new UnsupportedOperationException("The index has to be optimized first to be cached! Use IndexWriter.forceMerge(0) to do this.");
        }
        this.docs = new TreeSet();
        try {
            this.cachedInstance = (GlobalFeature)this.descriptorClass.newInstance();
            if (this.fieldName == null) {
                this.fieldName = this.cachedInstance.getFieldName();
            }
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher (" + this.descriptorClass.getName() + "): " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher (" + this.descriptorClass.getName() + "): " + e.getMessage());
        }
        if (this.isCaching && reader != null) {
            int docs = reader.numDocs();
            this.featureCache = new ArrayList(docs);
            try {
                for (int i = 0; i < docs; ++i) {
                    Document d = reader.document(i);
                    this.cachedInstance.setByteArrayRepresentation(d.getField((String)this.fieldName).binaryValue().bytes, d.getField((String)this.fieldName).binaryValue().offset, d.getField((String)this.fieldName).binaryValue().length);
                    if (!this.halfDimensions) {
                        this.featureCache.add(this.normalize(this.cachedInstance.getFeatureVector()));
                        continue;
                    }
                    this.featureCache.add(this.crunch(this.cachedInstance.getFeatureVector()));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private double[] normalize(double[] doubleHistogram) {
        double[] result = new double[doubleHistogram.length];
        for (int i = 0; i < doubleHistogram.length; ++i) {
            result[i] = doubleHistogram[i] / 8.0;
        }
        return result;
    }

    private double[] crunch(double[] doubleHistogram) {
        double[] result = new double[doubleHistogram.length / 2];
        for (int i = 0; i < doubleHistogram.length; i += 2) {
            result[i / 2] = doubleHistogram[i] + doubleHistogram[i + 1] / 16.0;
        }
        return result;
    }

    @Override
    public ImageSearchHits search(BufferedImage image, IndexReader reader) throws IOException {
        throw new UnsupportedOperationException("not implemented!");
    }

    protected double findSimilar(IndexReader reader, GlobalFeature globalFeature) throws IOException {
        this.maxDistance = -1.0;
        this.docs.clear();
        int count = 0;
        double[] doubleHistogram = !this.halfDimensions ? this.normalize(globalFeature.getFeatureVector()) : this.crunch(globalFeature.getFeatureVector());
        int index = -1;
        for (double[] tmp : this.featureCache) {
            double tmpDistance = MetricsUtils.distL1(doubleHistogram, tmp);
            assert (tmpDistance >= 0.0);
            if (tmpDistance < this.maxDistance) {
                this.maxDistance = tmpDistance;
                index = count;
            }
            ++count;
        }
        this.docs.add(new SimpleResult(this.maxDistance, index));
        return this.maxDistance;
    }

    public SimpleResult findMostSimilar(GlobalFeature globalFeature) throws IOException {
        this.findSimilar(this.reader, globalFeature);
        return this.docs.first();
    }

    public SimpleResult[] findMostSimilar(GlobalFeature[] globalFeatures) throws IOException {
        return this.findMostSimilar(globalFeatures, 0, globalFeatures.length);
    }

    public SimpleResult[] findMostSimilar(GlobalFeature[] globalFeatures, int offset, int length) throws IOException {
        int i;
        double[] maxDistanceArray = new double[length - offset];
        Arrays.fill(maxDistanceArray, Double.MAX_VALUE);
        int count = 0;
        Object dhs = new double[][]{};
        try {
            dhs = new double[length][this.featureCache.get(0).length];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i2 = 0; i2 < ((double[][])dhs).length; ++i2) {
            dhs[i2] = !this.halfDimensions ? this.normalize(globalFeatures[offset + i2].getFeatureVector()) : this.crunch(globalFeatures[offset + i2].getFeatureVector());
        }
        int[] indexes = new int[length];
        Arrays.fill(indexes, -1);
        for (double[] tmp : this.featureCache) {
            for (i = 0; i < ((double[][])dhs).length; ++i) {
                double tmpDistance = MetricsUtils.distL1(dhs[i], tmp);
                assert (tmpDistance >= 0.0);
                if (!(tmpDistance < maxDistanceArray[i])) continue;
                maxDistanceArray[i] = tmpDistance;
                indexes[i] = count;
            }
            ++count;
        }
        SimpleResult[] results = new SimpleResult[length];
        for (i = 0; i < results.length; ++i) {
            results[i] = indexes[i] >= 0 && indexes[i] < this.reader.maxDoc() ? new SimpleResult(maxDistanceArray[i], indexes[i]) : null;
        }
        return results;
    }

    protected double getDistance(Document document, GlobalFeature globalFeature) {
        if (document.getField(this.fieldName).binaryValue() != null && document.getField((String)this.fieldName).binaryValue().length > 0) {
            this.cachedInstance.setByteArrayRepresentation(document.getField((String)this.fieldName).binaryValue().bytes, document.getField((String)this.fieldName).binaryValue().offset, document.getField((String)this.fieldName).binaryValue().length);
            return globalFeature.getDistance(this.cachedInstance);
        }
        this.logger.warning("No feature stored in this document! (" + this.descriptorClass.getName() + ")");
        return 0.0;
    }

    @Override
    public ImageSearchHits search(Document doc, IndexReader reader) throws IOException {
        SimpleImageSearchHits searchHits = null;
        try {
            GlobalFeature globalFeature = (GlobalFeature)this.descriptorClass.newInstance();
            if (doc.getField(this.fieldName).binaryValue() != null && doc.getField((String)this.fieldName).binaryValue().length > 0) {
                globalFeature.setByteArrayRepresentation(doc.getField((String)this.fieldName).binaryValue().bytes, doc.getField((String)this.fieldName).binaryValue().offset, doc.getField((String)this.fieldName).binaryValue().length);
            }
            double maxDistance = this.findSimilar(reader, globalFeature);
            searchHits = !this.useSimilarityScore ? new SimpleImageSearchHits(this.docs, maxDistance) : new SimpleImageSearchHits(this.docs, maxDistance, this.useSimilarityScore);
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        return searchHits;
    }

    @Override
    public ImageDuplicates findDuplicates(IndexReader reader) throws IOException {
        throw new UnsupportedOperationException("not implemented!");
    }

    public String toString() {
        return "GenericSearcher using " + this.descriptorClass.getName();
    }
}

