/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.searchers.custom;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.searchers.ImageSearchHits;
import net.semanticmetadata.lire.searchers.SimpleImageSearchHits;
import net.semanticmetadata.lire.searchers.SimpleResult;
import net.semanticmetadata.lire.utils.ImageUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Bits;

public class TopDocsImageSearcher {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    Class<?> descriptorClass;
    String fieldName;
    private int maxHits = 10;
    protected TreeSet<SimpleResult> docs;

    public TopDocsImageSearcher(int maxHits, Class<?> descriptorClass, String fieldName) {
        this.maxHits = maxHits;
        this.docs = new TreeSet();
        this.descriptorClass = descriptorClass;
        this.fieldName = fieldName;
    }

    public ImageSearchHits search(BufferedImage image, IndexReader reader, TopDocs results) throws IOException {
        this.logger.finer("Starting extraction.");
        GlobalFeature globalFeature = null;
        SimpleImageSearchHits searchHits = null;
        try {
            globalFeature = (GlobalFeature)this.descriptorClass.newInstance();
            BufferedImage bimg = image;
            if (Math.max(image.getHeight(), image.getWidth()) > 1024) {
                bimg = ImageUtils.scaleImage(image, 1024);
            }
            globalFeature.extract(bimg);
            this.logger.fine("Extraction from image finished");
            double maxDistance = this.findSimilar(results, reader, globalFeature);
            searchHits = new SimpleImageSearchHits(this.docs, maxDistance);
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        return searchHits;
    }

    protected double findSimilar(TopDocs results, IndexReader reader, GlobalFeature globalFeature) throws IOException {
        double maxDistance = -1.0;
        double overallMaxDistance = -1.0;
        boolean hasDeletions = reader.hasDeletions();
        this.docs.clear();
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
        int docs = results.totalHits;
        for (int i = 0; i < docs; ++i) {
            if (reader.hasDeletions() && !liveDocs.get(i)) continue;
            Document d = reader.document(results.scoreDocs[i].doc);
            double distance = this.getDistance(d, globalFeature);
            assert (distance >= 0.0);
            if (overallMaxDistance < distance) {
                overallMaxDistance = distance;
            }
            if (maxDistance < 0.0) {
                maxDistance = distance;
            }
            if (this.docs.size() < this.maxHits) {
                this.docs.add(new SimpleResult(distance, results.scoreDocs[i].doc));
                if (!(distance > maxDistance)) continue;
                maxDistance = distance;
                continue;
            }
            if (!(distance < maxDistance)) continue;
            this.docs.remove(this.docs.last());
            this.docs.add(new SimpleResult(distance, results.scoreDocs[i].doc));
            maxDistance = this.docs.last().getDistance();
        }
        return maxDistance;
    }

    protected double getDistance(Document d, GlobalFeature globalFeature) {
        double distance = 0.0;
        try {
            GlobalFeature lf = (GlobalFeature)this.descriptorClass.newInstance();
            lf.setByteArrayRepresentation(d.getField((String)this.fieldName).binaryValue().bytes, d.getField((String)this.fieldName).binaryValue().offset, d.getField((String)this.fieldName).binaryValue().length);
            distance = globalFeature.getDistance(lf);
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        return distance;
    }

    public ImageSearchHits search(TopDocs results, Document d, IndexReader reader) throws IOException {
        SimpleImageSearchHits searchHits = null;
        try {
            GlobalFeature lf = (GlobalFeature)this.descriptorClass.newInstance();
            lf.setByteArrayRepresentation(d.getField((String)this.fieldName).binaryValue().bytes, d.getField((String)this.fieldName).binaryValue().offset, d.getField((String)this.fieldName).binaryValue().length);
            double maxDistance = this.findSimilar(results, reader, lf);
            searchHits = new SimpleImageSearchHits(this.docs, maxDistance);
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        return searchHits;
    }

    public String toString() {
        return "TopDocsImageSearcher using " + this.descriptorClass.getName();
    }
}

