/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.searchers.forevaluations;

import java.util.ArrayList;
import java.util.Collection;
import net.semanticmetadata.lire.searchers.ImageSearchHits;
import net.semanticmetadata.lire.searchers.forevaluations.SimpleResultForEvaluation;

public class ImageSearchHitsForEvaluation
implements ImageSearchHits {
    ArrayList<SimpleResultForEvaluation> results;

    public ImageSearchHitsForEvaluation(Collection<SimpleResultForEvaluation> results, double maxDistance) {
        this.results = new ArrayList(results.size());
        this.results.addAll(results);
    }

    public ImageSearchHitsForEvaluation(Collection<SimpleResultForEvaluation> results, double maxDistance, boolean useSimilarityScore) {
        this.results = new ArrayList(results.size());
        this.results.addAll(results);
        for (SimpleResultForEvaluation result : this.results) {
            if (!useSimilarityScore) continue;
            result.setDistance(1.0 - result.getDistance() / maxDistance);
        }
    }

    @Override
    public int length() {
        return this.results.size();
    }

    @Override
    public double score(int position) {
        return this.results.get(position).getDistance();
    }

    @Override
    public int documentID(int position) {
        return this.results.get(position).getIndexNumber();
    }

    public String path(int position) {
        return this.results.get(position).getPath();
    }
}

