/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.searchers.forevaluations;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import net.semanticmetadata.lire.aggregators.Aggregator;
import net.semanticmetadata.lire.imageanalysis.features.GlobalFeature;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.imageanalysis.features.LocalFeatureExtractor;
import net.semanticmetadata.lire.imageanalysis.features.local.simple.SimpleExtractor;
import net.semanticmetadata.lire.searchers.forevaluations.GenericFastImageSearcherForEvaluation;
import net.semanticmetadata.lire.searchers.forevaluations.SearchItemForEvaluation;
import net.semanticmetadata.lire.searchers.forevaluations.SimpleResultForEvaluation;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.util.Bits;

public class ImageSearcherUsingWSsForEvaluation
extends GenericFastImageSearcherForEvaluation {
    private double[] idfValues;
    private boolean termFrequency = false;
    private boolean inverseDocFrequency = false;
    private boolean normalizeHistogram = false;
    private String ws = "nnn";

    public ImageSearcherUsingWSsForEvaluation(int maxHits, Class<? extends LocalFeatureExtractor> localFeatureExtractor, Aggregator aggregator, int codebookSize, IndexReader reader, String codebooksDir, boolean tf, boolean idf, boolean n) {
        super(maxHits, localFeatureExtractor, aggregator, codebookSize, true, reader, codebooksDir);
        this.termFrequency = tf;
        this.inverseDocFrequency = idf;
        this.normalizeHistogram = n;
        this.setWS();
    }

    public ImageSearcherUsingWSsForEvaluation(int maxHits, Class<? extends GlobalFeature> globalFeature, SimpleExtractor.KeypointDetector detector, Aggregator aggregator, int codebookSize, IndexReader reader, String codebooksDir, boolean tf, boolean idf, boolean n) {
        super(maxHits, globalFeature, detector, aggregator, codebookSize, true, reader, codebooksDir);
        this.termFrequency = tf;
        this.inverseDocFrequency = idf;
        this.normalizeHistogram = n;
        this.setWS();
    }

    private void setWS() {
        if (this.termFrequency) {
            if (this.inverseDocFrequency) {
                if (this.normalizeHistogram) {
                    this.ws = "ltc";
                } else if (!this.normalizeHistogram) {
                    this.ws = "ltn";
                }
            } else if (!this.inverseDocFrequency) {
                if (this.normalizeHistogram) {
                    this.ws = "lnc";
                } else if (!this.normalizeHistogram) {
                    this.ws = "lnn";
                }
            }
        } else if (!this.termFrequency) {
            if (this.inverseDocFrequency) {
                if (this.normalizeHistogram) {
                    this.ws = "ntc";
                } else if (!this.normalizeHistogram) {
                    this.ws = "ntn";
                }
            } else if (!this.inverseDocFrequency) {
                if (this.normalizeHistogram) {
                    this.ws = "nnc";
                } else if (!this.normalizeHistogram) {
                    this.ws = "nnn";
                }
            }
        }
        LinkedList<Thread> threads = new LinkedList<Thread>();
        Thread p = new Thread(new Producer());
        p.start();
        for (int i = 0; i < this.numThreads; ++i) {
            Thread thread = new Thread(new Compute());
            thread.start();
            threads.add(thread);
        }
        for (Thread next : threads) {
            try {
                next.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void computeFeatureCache(LireFeature f) {
        int i;
        double[] v = f.getFeatureVector();
        if (this.termFrequency) {
            for (i = 0; i < v.length; ++i) {
                if (!(v[i] > 0.0)) continue;
                v[i] = 1.0 + Math.log10(v[i]);
            }
        }
        if (this.inverseDocFrequency) {
            for (i = 0; i < v.length; ++i) {
                if (!(this.idfValues[i] > 0.0)) continue;
                v[i] = Math.log10((double)this.reader.numDocs() / this.idfValues[i]) * v[i];
            }
        }
        if (this.normalizeHistogram) {
            double len = 0.0;
            for (double next : v) {
                len += next * next;
            }
            len = Math.sqrt(len);
            for (int i2 = 0; i2 < v.length; ++i2) {
                if (v[i2] == 0.0) continue;
                int n = i2;
                v[n] = v[n] / len;
            }
        }
    }

    @Override
    protected void init() {
        if (this.reader != null && this.reader.numDocs() > 0) {
            Bits liveDocs = MultiFields.getLiveDocs((IndexReader)this.reader);
            int docs = this.reader.numDocs();
            this.featureCache = new LinkedHashMap(docs);
            try {
                int counter;
                for (counter = 0; this.reader.hasDeletions() && !liveDocs.get(counter) && counter < docs; ++counter) {
                }
                Document d = this.reader.document(counter);
                this.cachedInstance.setByteArrayRepresentation(d.getField((String)this.fieldName).binaryValue().bytes, d.getField((String)this.fieldName).binaryValue().offset, d.getField((String)this.fieldName).binaryValue().length);
                this.featureCache.put(counter, new SearchItemForEvaluation(this.cachedInstance.getByteArrayRepresentation(), new SimpleResultForEvaluation(-1.0, counter, d.getValues("ImageIdentifier")[0])));
                this.idfValues = new double[this.cachedInstance.getFeatureVector().length];
                for (int j = 0; j < this.cachedInstance.getFeatureVector().length; ++j) {
                    if (!(this.cachedInstance.getFeatureVector()[j] > 0.0)) continue;
                    int n = j;
                    this.idfValues[n] = this.idfValues[n] + 1.0;
                }
                for (int i = ++counter; i < docs; ++i) {
                    if (this.reader.hasDeletions() && !liveDocs.get(i)) continue;
                    d = this.reader.document(i);
                    this.cachedInstance.setByteArrayRepresentation(d.getField((String)this.fieldName).binaryValue().bytes, d.getField((String)this.fieldName).binaryValue().offset, d.getField((String)this.fieldName).binaryValue().length);
                    this.featureCache.put(i, new SearchItemForEvaluation(this.cachedInstance.getByteArrayRepresentation(), new SimpleResultForEvaluation(-1.0, i, d.getValues("ImageIdentifier")[0])));
                    for (int j = 0; j < this.cachedInstance.getFeatureVector().length; ++j) {
                        if (!(this.cachedInstance.getFeatureVector()[j] > 0.0)) continue;
                        int n = j;
                        this.idfValues[n] = this.idfValues[n] + 1.0;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected double findSimilar(IndexReader reader, LireFeature lireFeature) throws IOException {
        this.maxDistance = -1.0;
        this.docs.clear();
        if (!this.isCaching) {
            throw new UnsupportedOperationException("ImageSearcherUsingWSs works only with Caching!!!");
        }
        LinkedList<Consumer> tasks = new LinkedList<Consumer>();
        LinkedList<Thread> threads = new LinkedList<Thread>();
        Thread p = new Thread(new Producer());
        p.start();
        for (int i = 0; i < this.numThreads; ++i) {
            Consumer consumer = new Consumer(lireFeature);
            Thread thread = new Thread(consumer);
            thread.start();
            tasks.add(consumer);
            threads.add(thread);
        }
        for (Thread next : threads) {
            try {
                next.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (Consumer task : tasks) {
            TreeSet<SimpleResultForEvaluation> tmpDocs = task.getResult();
            boolean flag = true;
            while (flag && tmpDocs.size() > 0) {
                SimpleResultForEvaluation simpleResult = tmpDocs.pollFirst();
                if (this.docs.size() < this.maxHits) {
                    this.docs.add(simpleResult);
                    if (!(simpleResult.getDistance() > this.maxDistance)) continue;
                    this.maxDistance = simpleResult.getDistance();
                    continue;
                }
                if (simpleResult.getDistance() < this.maxDistance) {
                    this.docs.pollLast();
                    this.docs.add(simpleResult);
                    this.maxDistance = ((SimpleResultForEvaluation)this.docs.last()).getDistance();
                    continue;
                }
                flag = false;
            }
        }
        return this.maxDistance;
    }

    @Override
    public String toString() {
        return "ImageSearcherUsingWSsForEvaluation using " + this.extractorItem.getExtractorClass().getName() + " and ws: " + this.ws;
    }

    private class Consumer
    implements Runnable {
        private boolean locallyEnded = false;
        private TreeSet<SimpleResultForEvaluation> localDocs = new TreeSet();
        private LireFeature localCachedInstance;
        private LireFeature localLireFeature;

        private Consumer(LireFeature lireFeature) {
            try {
                this.localCachedInstance = (LireFeature)ImageSearcherUsingWSsForEvaluation.this.cachedInstance.getClass().newInstance();
                this.localLireFeature = (LireFeature)lireFeature.getClass().newInstance();
                this.localLireFeature.setByteArrayRepresentation(lireFeature.getByteArrayRepresentation());
                ImageSearcherUsingWSsForEvaluation.this.computeFeatureCache(this.localLireFeature);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            double localMaxDistance = -1.0;
            while (!this.locallyEnded) {
                try {
                    Map.Entry tmp = (Map.Entry)ImageSearcherUsingWSsForEvaluation.this.queue.take();
                    if ((Integer)tmp.getKey() < 0) {
                        this.locallyEnded = true;
                    }
                    if (this.locallyEnded) continue;
                    this.localCachedInstance.setByteArrayRepresentation(((SearchItemForEvaluation)tmp.getValue()).getBuffer());
                    double tmpDistance = this.localLireFeature.getDistance(this.localCachedInstance);
                    assert (tmpDistance >= 0.0);
                    if (this.localDocs.size() < ImageSearcherUsingWSsForEvaluation.this.maxHits) {
                        ((SearchItemForEvaluation)tmp.getValue()).simpleResultForEvaluation.setDistance(tmpDistance);
                        this.localDocs.add(((SearchItemForEvaluation)tmp.getValue()).getSimpleResultForEvaluation());
                        if (!(tmpDistance > localMaxDistance)) continue;
                        localMaxDistance = tmpDistance;
                        continue;
                    }
                    if (!(tmpDistance < localMaxDistance)) continue;
                    ((SearchItemForEvaluation)tmp.getValue()).simpleResultForEvaluation.setDistance(tmpDistance);
                    this.localDocs.pollLast();
                    this.localDocs.add(((SearchItemForEvaluation)tmp.getValue()).getSimpleResultForEvaluation());
                    localMaxDistance = this.localDocs.last().getDistance();
                }
                catch (InterruptedException e) {
                    e.getMessage();
                }
            }
        }

        public TreeSet<SimpleResultForEvaluation> getResult() {
            return this.localDocs;
        }
    }

    class Producer
    implements Runnable {
        private Producer() {
            ImageSearcherUsingWSsForEvaluation.this.queue.clear();
        }

        @Override
        public void run() {
            for (Map.Entry documentEntry : ImageSearcherUsingWSsForEvaluation.this.featureCache.entrySet()) {
                try {
                    ImageSearcherUsingWSsForEvaluation.this.queue.put(documentEntry);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            LinkedHashMap tmpMap = new LinkedHashMap(ImageSearcherUsingWSsForEvaluation.this.numThreads * 3);
            for (int i = 1; i < ImageSearcherUsingWSsForEvaluation.this.numThreads * 3; ++i) {
                tmpMap.put(-i, null);
            }
            for (Map.Entry documentEntry : tmpMap.entrySet()) {
                try {
                    ImageSearcherUsingWSsForEvaluation.this.queue.put(documentEntry);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class Compute
    implements Runnable {
        private boolean locallyEnded = false;
        private LireFeature localCachedInstance;

        private Compute() {
            try {
                this.localCachedInstance = (LireFeature)ImageSearcherUsingWSsForEvaluation.this.cachedInstance.getClass().newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            while (!this.locallyEnded) {
                try {
                    Map.Entry tmp = (Map.Entry)ImageSearcherUsingWSsForEvaluation.this.queue.take();
                    if ((Integer)tmp.getKey() < 0) {
                        this.locallyEnded = true;
                    }
                    if (this.locallyEnded) continue;
                    this.localCachedInstance.setByteArrayRepresentation(((SearchItemForEvaluation)tmp.getValue()).getBuffer());
                    ImageSearcherUsingWSsForEvaluation.this.computeFeatureCache(this.localCachedInstance);
                    ((SearchItemForEvaluation)tmp.getValue()).setBuffer(this.localCachedInstance.getByteArrayRepresentation());
                }
                catch (InterruptedException e) {
                    e.getMessage();
                }
            }
        }
    }
}

