/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.utils;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.semanticmetadata.lire.indexers.LireCustomCodec;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;

public class LuceneUtils {
    public static final Version LUCENE_VERSION = Version.LUCENE_5_2_1;

    public static IndexWriter createIndexWriter(String indexPath, boolean create) throws IOException {
        return LuceneUtils.createIndexWriter(indexPath, create, AnalyzerType.SimpleAnalyzer);
    }

    public static IndexWriter createIndexWriter(String indexPath, boolean create, AnalyzerType analyzer) throws IOException {
        return LuceneUtils.createIndexWriter((Directory)FSDirectory.open((Path)Paths.get(indexPath, new String[0])), create, analyzer);
    }

    public static IndexWriter createIndexWriter(Directory directory, boolean create, AnalyzerType analyzer) throws IOException {
        SimpleAnalyzer tmpAnalyzer = null;
        if (analyzer == AnalyzerType.SimpleAnalyzer) {
            tmpAnalyzer = new SimpleAnalyzer();
        } else if (analyzer == AnalyzerType.WhitespaceAnalyzer) {
            tmpAnalyzer = new WhitespaceAnalyzer();
        } else if (analyzer == AnalyzerType.KeywordAnalyzer) {
            tmpAnalyzer = new KeywordAnalyzer();
        } else if (analyzer == AnalyzerType.StandardAnalyzer) {
            tmpAnalyzer = new StandardAnalyzer();
        }
        IndexWriterConfig config = new IndexWriterConfig((Analyzer)tmpAnalyzer);
        config.setRAMBufferSizeMB(512.0);
        config.setCommitOnClose(true);
        if (create) {
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        } else {
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        }
        config.setCodec((Codec)new LireCustomCodec());
        return new IndexWriter(directory, config);
    }

    public static IndexWriter createIndexWriter(Directory directory, boolean create, AnalyzerType analyzer, double RAMBufferSize) throws IOException {
        SimpleAnalyzer tmpAnalyzer = null;
        if (analyzer == AnalyzerType.SimpleAnalyzer) {
            tmpAnalyzer = new SimpleAnalyzer();
        } else if (analyzer == AnalyzerType.WhitespaceAnalyzer) {
            tmpAnalyzer = new WhitespaceAnalyzer();
        }
        IndexWriterConfig config = new IndexWriterConfig((Analyzer)tmpAnalyzer);
        if (create) {
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        } else {
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        }
        config.setRAMBufferSizeMB(RAMBufferSize);
        config.setCodec((Codec)new LireCustomCodec());
        return new IndexWriter(directory, config);
    }

    public static void optimizeWriter(IndexWriter iw) throws IOException {
        iw.forceMerge(1);
    }

    public static void commitWriter(IndexWriter iw) throws IOException {
        iw.commit();
    }

    public static void closeWriter(IndexWriter iw) throws IOException {
        iw.close();
    }

    public static IndexReader openIndexReader(String indexPath) throws IOException {
        return LuceneUtils.openIndexReader(FSDirectory.open((Path)Paths.get(indexPath, new String[0])), false);
    }

    public static IndexReader openIndexReader(String indexPath, boolean RAMDirectory) throws IOException {
        return LuceneUtils.openIndexReader(FSDirectory.open((Path)Paths.get(indexPath, new String[0])), RAMDirectory);
    }

    public static IndexReader openIndexReader(FSDirectory directory) throws IOException {
        return LuceneUtils.openIndexReader(directory, false);
    }

    public static IndexReader openIndexReader(FSDirectory directory, boolean RAMDirectory2) throws IOException {
        if (RAMDirectory2) {
            return DirectoryReader.open((Directory)new RAMDirectory(directory, IOContext.READONCE));
        }
        return DirectoryReader.open((Directory)directory);
    }

    public static IndexReader openIndexReader(IndexWriter writer, boolean applyDeletes) throws IOException {
        return DirectoryReader.open((IndexWriter)writer, (boolean)applyDeletes);
    }

    public static void closeReader(IndexReader reader) throws IOException {
        reader.close();
    }

    public static IndexSearcher openIndexSearcher(IndexReader reader) {
        return new IndexSearcher(reader);
    }

    public static byte[] getBytes(BytesRef byteRef) {
        byte[] result = new byte[byteRef.length];
        System.arraycopy(byteRef.bytes, byteRef.offset, result, 0, byteRef.length);
        return result;
    }

    public static enum AnalyzerType {
        SimpleAnalyzer,
        WhitespaceAnalyzer,
        KeywordAnalyzer,
        StandardAnalyzer;

    }
}

