/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.utils;

public class MetricsUtils {
    public static double distL1(int[] h1, int[] h2) {
        assert (h1.length == h2.length);
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += (double)Math.abs(h1[i] - h2[i]);
        }
        return sum / (double)h1.length;
    }

    public static double distL1(double[] h1, double[] h2) {
        assert (h1.length == h2.length);
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += Math.abs(h1[i] - h2[i]);
        }
        return sum / (double)h1.length;
    }

    public static double distL2(int[] h1, int[] h2) {
        assert (h1.length == h2.length);
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += (double)((h1[i] - h2[i]) * (h1[i] - h2[i]));
        }
        return Math.sqrt(sum);
    }

    public static double distL2(double[] h1, double[] h2) {
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += (h1[i] - h2[i]) * (h1[i] - h2[i]);
        }
        return Math.sqrt(sum);
    }

    public static double distL2(float[] h1, float[] h2) {
        assert (h1.length == h2.length);
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += (double)((h1[i] - h2[i]) * (h1[i] - h2[i]));
        }
        return Math.sqrt(sum);
    }

    public static double jsd(int[] h1, int[] h2) {
        assert (h1.length == h2.length);
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += (h1[i] > 0 ? (double)h1[i] * Math.log(2.0 * (double)h1[i] / (double)(h1[i] + h2[i])) : 0.0) + (h2[i] > 0 ? (double)h2[i] * Math.log(2.0 * (double)h2[i] / (double)(h1[i] + h2[i])) : 0.0);
        }
        return sum;
    }

    public static double chisquare(double[] d1, double[] d2) {
        assert (d1.length == d2.length);
        double sum = 0.0;
        for (int i = 0; i < d1.length; ++i) {
            double m = (d1[i] + d2[i]) / 2.0;
            sum += (d1[i] - m) * (d1[i] - m) / m;
        }
        return sum;
    }

    public static double simpleEMD(double[] d1, double[] d2) {
        assert (d1.length == d2.length);
        double sum = 0.0;
        double m1 = 0.0;
        double m2 = 0.0;
        for (int i = 0; i < d1.length; ++i) {
            sum += Math.abs((m1 += d1[i]) - (m2 += d2[i]));
        }
        return sum;
    }

    public static double ksDistance(double[] d1, double[] d2) {
        assert (d1.length == d2.length);
        double max = 0.0;
        double m1 = 0.0;
        double m2 = 0.0;
        for (int i = 0; i < d1.length; ++i) {
            max = Math.max(Math.abs((m1 += d1[i]) - (m2 += d2[i])), max);
        }
        return max;
    }

    public static double jsd(byte[] h1, byte[] h2) {
        assert (h1.length == h2.length);
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += (h1[i] > 0 ? (double)h1[i] * Math.log(2.0 * (double)h1[i] / (double)(h1[i] + h2[i])) : 0.0) + (h2[i] > 0 ? (double)h2[i] * Math.log(2.0 * (double)h2[i] / (double)(h1[i] + h2[i])) : 0.0);
        }
        return sum;
    }

    public static double jsd(float[] h1, float[] h2) {
        assert (h1.length == h2.length);
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += (h1[i] > 0.0f ? (double)h1[i] / 2.0 * Math.log(2.0 * (double)h1[i] / (double)(h1[i] + h2[i])) : 0.0) + (h2[i] > 0.0f ? (double)h2[i] / 2.0 * Math.log(2.0 * (double)h2[i] / (double)(h1[i] + h2[i])) : 0.0);
        }
        return sum;
    }

    public static double jsd(double[] h1, double[] h2) {
        assert (h1.length == h2.length);
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += (h1[i] > 0.0 ? h1[i] / 2.0 * Math.log(2.0 * h1[i] / (h1[i] + h2[i])) : 0.0) + (h2[i] > 0.0 ? h2[i] / 2.0 * Math.log(2.0 * h2[i] / (h1[i] + h2[i])) : 0.0);
        }
        return sum;
    }

    public static double tanimoto(int[] h1, int[] h2) {
        int i;
        assert (h1.length == h2.length);
        double result = 0.0;
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double tmpCnt1 = 0.0;
        double tmpCnt2 = 0.0;
        double tmpCnt3 = 0.0;
        for (i = 0; i < h1.length; ++i) {
            tmp1 += (double)h1[i];
            tmp2 += (double)h2[i];
        }
        if (tmp1 == 0.0 && tmp2 == 0.0) {
            return 0.0;
        }
        if (tmp1 == 0.0 || tmp2 == 0.0) {
            return 100.0;
        }
        if (tmp1 > 0.0 && tmp2 > 0.0) {
            for (i = 0; i < h1.length; ++i) {
                tmpCnt1 += (double)h1[i] / tmp1 * ((double)h2[i] / tmp2);
                tmpCnt2 += (double)h2[i] / tmp2 * ((double)h2[i] / tmp2);
                tmpCnt3 += (double)h1[i] / tmp1 * ((double)h1[i] / tmp1);
            }
            result = 100.0 - 100.0 * (tmpCnt1 / (tmpCnt2 + tmpCnt3 - tmpCnt1));
        }
        return result;
    }

    public static double tanimoto(float[] h1, float[] h2) {
        int i;
        assert (h1.length == h2.length);
        double result = 0.0;
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double tmpCnt1 = 0.0;
        double tmpCnt2 = 0.0;
        double tmpCnt3 = 0.0;
        for (i = 0; i < h1.length; ++i) {
            tmp1 += (double)h1[i];
            tmp2 += (double)h2[i];
        }
        if (tmp1 == 0.0 && tmp2 == 0.0) {
            return 0.0;
        }
        if (tmp1 == 0.0 || tmp2 == 0.0) {
            return 100.0;
        }
        if (tmp1 > 0.0 && tmp2 > 0.0) {
            for (i = 0; i < h1.length; ++i) {
                tmpCnt1 += (double)h1[i] / tmp1 * ((double)h2[i] / tmp2);
                tmpCnt2 += (double)h2[i] / tmp2 * ((double)h2[i] / tmp2);
                tmpCnt3 += (double)h1[i] / tmp1 * ((double)h1[i] / tmp1);
            }
            result = 100.0 - 100.0 * (tmpCnt1 / (tmpCnt2 + tmpCnt3 - tmpCnt1));
        }
        return result;
    }

    public static double tanimoto(double[] h1, double[] h2) {
        int i;
        assert (h1.length == h2.length);
        double result = 0.0;
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double tmpCnt1 = 0.0;
        double tmpCnt2 = 0.0;
        double tmpCnt3 = 0.0;
        for (i = 0; i < h1.length; ++i) {
            tmp1 += h1[i];
            tmp2 += h2[i];
        }
        if (tmp1 == 0.0 && tmp2 == 0.0) {
            return 0.0;
        }
        if (tmp1 == 0.0 || tmp2 == 0.0) {
            return 100.0;
        }
        if (tmp1 > 0.0 && tmp2 > 0.0) {
            for (i = 0; i < h1.length; ++i) {
                tmpCnt1 += h1[i] / tmp1 * (h2[i] / tmp2);
                tmpCnt2 += h2[i] / tmp2 * (h2[i] / tmp2);
                tmpCnt3 += h1[i] / tmp1 * (h1[i] / tmp1);
            }
            result = 100.0 - 100.0 * (tmpCnt1 / (tmpCnt2 + tmpCnt3 - tmpCnt1));
        }
        return result;
    }

    public static double cosineCoefficient(double[] hist1, double[] hist2) {
        assert (hist1.length == hist2.length);
        double distance = 0.0;
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        for (int i = 0; i < hist1.length; ++i) {
            distance += hist1[i] * hist2[i];
            tmp1 += hist1[i] * hist1[i];
            tmp2 += hist2[i] * hist2[i];
        }
        if (tmp1 * tmp2 > 0.0) {
            return Math.max(0.0, 1.0 - distance / (Math.sqrt(tmp1) * Math.sqrt(tmp2)));
        }
        return 1.0;
    }

    public static double distL1(float[] h1, float[] h2) {
        assert (h1.length == h2.length);
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += (double)Math.abs(h1[i] - h2[i]);
        }
        return sum;
    }

    public static double distL1(byte[] h1, byte[] h2) {
        assert (h1.length == h2.length);
        double sum = 0.0;
        for (int i = 0; i < h1.length; ++i) {
            sum += (double)Math.abs(h1[i] - h2[i]);
        }
        return sum;
    }

    public static double[] normalizeMax(double[] histogram) {
        int i;
        double[] result = new double[histogram.length];
        double max = 0.0;
        for (i = 0; i < histogram.length; ++i) {
            max = Math.max(max, histogram[i]);
        }
        for (i = 0; i < histogram.length; ++i) {
            result[i] = histogram[i] / max;
        }
        return result;
    }

    public static double[] normalizeL2(double[] histogram) {
        int i;
        double[] result = new double[histogram.length];
        double len = 0.0;
        for (i = 0; i < histogram.length; ++i) {
            len += histogram[i] * histogram[i];
        }
        len = Math.sqrt(len);
        for (i = 0; i < histogram.length; ++i) {
            result[i] = histogram[i] != 0.0 ? histogram[i] / len : 0.0;
        }
        return result;
    }

    public static double[] normalizeL1(double[] histogram) {
        int i;
        double[] result = new double[histogram.length];
        double len = 0.0;
        for (i = 0; i < histogram.length; ++i) {
            len += Math.abs(histogram[i]);
        }
        for (i = 0; i < histogram.length; ++i) {
            result[i] = histogram[i] / len;
        }
        return result;
    }
}

